/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.limit;

import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public class LimitFunction
implements JpqlFunction {
    protected final DbmsDialect dbmsDialect;

    public LimitFunction(DbmsDialect dbmsDialect) {
        this.dbmsDialect = dbmsDialect;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return firstArgumentType;
    }

    public void render(FunctionRenderContext functionRenderContext) {
        switch (functionRenderContext.getArgumentsSize()) {
            case 3: {
                if (!LimitFunction.isNotNull(functionRenderContext.getArgument(1)) || !LimitFunction.isNotNull(functionRenderContext.getArgument(2))) break;
                this.renderLimitOffset(functionRenderContext);
                return;
            }
            case 2: {
                if (!LimitFunction.isNotNull(functionRenderContext.getArgument(1))) break;
                this.renderLimitOnly(functionRenderContext);
                return;
            }
        }
        throw new RuntimeException("The limit function needs two or three non null arguments <sub_query>, <limit> and optionally <offset>! args=" + functionRenderContext);
    }

    protected void renderLimitOffset(FunctionRenderContext functionRenderContext) {
        StringBuilder sqlSb = LimitFunction.getSql(functionRenderContext);
        this.dbmsDialect.appendExtendedSql(sqlSb, DbmsStatementType.SELECT, true, false, null, functionRenderContext.getArgument(1), functionRenderContext.getArgument(2), null, null);
        functionRenderContext.addChunk(sqlSb.toString());
    }

    protected void renderLimitOnly(FunctionRenderContext functionRenderContext) {
        StringBuilder sqlSb = LimitFunction.getSql(functionRenderContext);
        this.dbmsDialect.appendExtendedSql(sqlSb, DbmsStatementType.SELECT, true, false, null, functionRenderContext.getArgument(1), null, null, null);
        functionRenderContext.addChunk(sqlSb.toString());
    }

    private static boolean isNotNull(String argument) {
        return argument != null && !"NULL".equalsIgnoreCase(argument);
    }

    private static StringBuilder getSql(FunctionRenderContext functionRenderContext) {
        String subquery = functionRenderContext.getArgument(0);
        if (LimitFunction.startsWithIgnoreCase(subquery, "(select")) {
            int endIndex = subquery.length() - (subquery.charAt(subquery.length() - 1) == ')' ? 1 : 0);
            return new StringBuilder(subquery.length() - 2).append(subquery, 1, endIndex);
        }
        return new StringBuilder(subquery);
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.regionMatches(true, 0, s2, 0, s2.length());
    }
}

