/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.set;

import com.blazebit.persistence.impl.DefaultOrderByElement;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;

public class SetFunction
implements JpqlFunction {
    protected final SetOperationType type;
    protected final DbmsDialect dbmsDialect;

    public SetFunction(SetOperationType type, DbmsDialect dbmsDialect) {
        this.type = type;
        this.dbmsDialect = dbmsDialect;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return firstArgumentType;
    }

    public void render(FunctionRenderContext functionRenderContext) {
        if (functionRenderContext.getArgumentsSize() == 0) {
            throw new RuntimeException("The " + this.type + " function needs at least one argument <sub_query>! args=" + functionRenderContext);
        }
        int size = 0;
        Mode mode = Mode.SUBQUERIES;
        ArrayList<String> operands = new ArrayList<String>(functionRenderContext.getArgumentsSize());
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(0);
        String limit = null;
        String offset = null;
        block6: for (int i = 0; i < functionRenderContext.getArgumentsSize(); ++i) {
            String argument = functionRenderContext.getArgument(i);
            if ("'ORDER_BY'".equals(argument)) {
                mode = Mode.ORDER_BYS;
                size += argument.length();
                continue;
            }
            if ("'LIMIT'".equals(argument)) {
                mode = Mode.LIMIT;
                size += argument.length();
                continue;
            }
            if ("'OFFSET'".equals(argument)) {
                mode = Mode.OFFSET;
                size += argument.length();
                continue;
            }
            switch (mode) {
                case SUBQUERIES: {
                    size += argument.length();
                    operands.add(argument);
                    continue block6;
                }
                case ORDER_BYS: {
                    size += argument.length() + 30;
                    orderByElements.add(DefaultOrderByElement.fromString(argument, 1, argument.length() - 2));
                    continue block6;
                }
                case LIMIT: {
                    size += argument.length() + 30;
                    limit = argument;
                    continue block6;
                }
                case OFFSET: {
                    size += argument.length() + 30;
                    offset = argument;
                }
            }
        }
        StringBuilder sqlSb = new StringBuilder(size + functionRenderContext.getArgumentsSize() * 12);
        this.dbmsDialect.appendSet(sqlSb, this.type, true, operands, orderByElements, limit, offset);
        functionRenderContext.addChunk(sqlSb.toString());
    }

    private static enum Mode {
        SUBQUERIES,
        ORDER_BYS,
        LIMIT,
        OFFSET;

    }
}

