/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.jpaprovider;

import com.blazebit.persistence.impl.jpaprovider.JpaProvider;
import javax.persistence.EntityManager;

public class HibernateJpaProvider
implements JpaProvider {
    private final DB db;

    public HibernateJpaProvider(EntityManager em, String dbms) {
        try {
            this.db = em == null ? DB.OTHER : ("mysql".equals(dbms) ? DB.MY_SQL : ("db2".equals(dbms) ? DB.DB2 : DB.OTHER));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportsJpa21() {
        return false;
    }

    @Override
    public boolean supportsInsertStatement() {
        return true;
    }

    @Override
    public boolean needsBracketsForListParamter() {
        return true;
    }

    @Override
    public String getBooleanExpression(boolean value) {
        return value ? "CASE WHEN 1 = 1 THEN true ELSE false END" : "CASE WHEN 1 = 1 THEN false ELSE true END";
    }

    @Override
    public String getBooleanConditionalExpression(boolean value) {
        return value ? "1 = 1" : "1 = 0";
    }

    @Override
    public String escapeCharacter(char character) {
        if (character == '\\' && this.db == DB.MY_SQL) {
            return "\\\\";
        }
        return Character.toString(character);
    }

    @Override
    public boolean supportsNullPrecedenceExpression() {
        return this.db != DB.MY_SQL && this.db != DB.DB2;
    }

    @Override
    public void renderNullPrecedence(StringBuilder sb, String expression, String resolvedExpression, String order, String nulls) {
        sb.append(expression).append(' ').append(order);
        if (nulls != null) {
            if (this.db == DB.DB2 || this.db == DB.MY_SQL) {
                if (this.db == DB.DB2 && ("FIRST".equals(nulls) && "DESC".equalsIgnoreCase(order) || "LAST".equals(nulls) && "ASC".equalsIgnoreCase(order))) {
                    sb.append(" NULLS ").append(nulls);
                    return;
                }
                sb.append("CASE WHEN ").append(resolvedExpression != null ? resolvedExpression : expression).append(" IS NULL THEN ");
                if ("FIRST".equals(nulls)) {
                    sb.append("0 ELSE 1");
                } else {
                    sb.append("1 ELSE 0");
                }
                sb.append(" END, ");
                sb.append(expression).append(" ").append(order);
            } else {
                sb.append(" NULLS ").append(nulls);
            }
        }
    }

    @Override
    public String getOnClause() {
        return "WITH";
    }

    @Override
    public String getCollectionValueFunction() {
        return null;
    }

    @Override
    public Class<?> getDefaultQueryResultType() {
        return Object.class;
    }

    @Override
    public String getCustomFunctionInvocation(String functionName, int argumentCount) {
        return functionName + "(";
    }

    private static enum DB {
        OTHER,
        MY_SQL,
        DB2;

    }
}

