/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.jpaprovider;

import com.blazebit.persistence.impl.jpaprovider.DataNucleusJpaProvider;
import com.blazebit.persistence.impl.jpaprovider.EclipseLinkJpaProvider;
import com.blazebit.persistence.impl.jpaprovider.HibernateJpa21Provider;
import com.blazebit.persistence.impl.jpaprovider.HibernateJpaProvider;
import com.blazebit.persistence.impl.jpaprovider.JpaProvider;
import javax.persistence.EntityManager;

public class JpaProviders {
    public static JpaProvider resolveJpaProvider(EntityManager em, String dbms) {
        Class<?> jpaEMClass;
        boolean jpa21 = false;
        try {
            EntityManager.class.getMethod("createEntityGraph", Class.class);
            jpa21 = true;
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Class<?> sessionClass = Class.forName("org.hibernate.Session");
            if (em == null || em.unwrap(sessionClass) != null) {
                if (jpa21) {
                    return new HibernateJpa21Provider(em, dbms);
                }
                return new HibernateJpaProvider(em, dbms);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            jpaEMClass = Class.forName("org.eclipse.persistence.jpa.JpaEntityManager");
            if (em == null || em.unwrap(jpaEMClass) != null) {
                boolean eclipseLink24;
                Class<?> versionClass = Class.forName("org.eclipse.persistence.Version");
                String version = (String)versionClass.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
                String[] versionParts = version.split("\\.");
                int major = Integer.parseInt(versionParts[0]);
                int minor = Integer.parseInt(versionParts[1]);
                boolean bl = eclipseLink24 = major > 2 || major == 2 && minor >= 4;
                if (!eclipseLink24) {
                    throw new IllegalArgumentException("Unsupported EclipseLink version " + version + "!");
                }
                return new EclipseLinkJpaProvider(em);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jpaEMClass = Class.forName("org.datanucleus.ExecutionContext");
            if (em == null || em.unwrap(jpaEMClass) != null) {
                return new DataNucleusJpaProvider(em);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("Unsupported jpa provider!");
    }
}

