/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.keyset.KeysetLink;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractKeysetLink
implements KeysetLink {
    private final KeysetMode keysetMode;

    public AbstractKeysetLink(KeysetMode keysetMode) {
        this.keysetMode = keysetMode;
    }

    protected void validate(Keyset keyset, List<OrderByExpression> orderByExpressions) {
        if (keyset == null) {
            throw new IllegalArgumentException("Invalid null keyset given!");
        }
        Object[] key = keyset.getTuple();
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Invalid empty keyset key given!");
        }
        if (key.length != orderByExpressions.size()) {
            throw new IllegalArgumentException("The given keyset key [" + Arrays.deepToString(key) + "] does not fit the order by expressions " + orderByExpressions + "!");
        }
    }

    @Override
    public KeysetMode getKeysetMode() {
        return this.keysetMode;
    }
}

