/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.keyset.AbstractKeysetBuilderEndedListener;
import com.blazebit.persistence.impl.keyset.KeysetLink;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import java.io.Serializable;
import java.util.List;

public class KeysetManager
extends AbstractKeysetBuilderEndedListener {
    private static final String KEY_SET_PARAMETER_NAME = "_keysetParameter";
    private final ResolvingQueryGenerator queryGenerator;
    private final ParameterManager parameterManager;
    private List<OrderByExpression> orderByExpressions;

    public KeysetManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager) {
        this.queryGenerator = queryGenerator;
        this.parameterManager = parameterManager;
    }

    public boolean hasKeyset() {
        return this.getKeysetLink() != null;
    }

    public void initialize(List<OrderByExpression> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
        KeysetLink keysetLink = this.getKeysetLink();
        keysetLink.initialize(orderByExpressions);
    }

    public void buildKeysetPredicate(StringBuilder sb) {
        int i;
        int expressionCount = this.orderByExpressions.size();
        KeysetLink keysetLink = this.getKeysetLink();
        KeysetMode keysetMode = keysetLink.getKeysetMode();
        Keyset keyset = keysetLink.getKeyset();
        Serializable[] key = keyset.getTuple();
        boolean generateEqualPredicate = true;
        int brackets = 0;
        boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
        ++brackets;
        sb.append('(');
        for (i = 0; i < expressionCount; ++i) {
            boolean isNotLast = i + 1 != expressionCount;
            OrderByExpression orderByExpr = this.orderByExpressions.get(i);
            Expression expr = orderByExpr.getExpression();
            if (orderByExpr.isNullable()) {
                boolean isPrevious;
                boolean bl = isPrevious = keysetMode == KeysetMode.PREVIOUS;
                if (key[i] == null) {
                    if (orderByExpr.isNullFirst() == isPrevious) {
                        generateEqualPredicate = false;
                        this.applyKeysetNullItem(sb, expr, false);
                    } else {
                        this.applyKeysetNullItem(sb, expr, true);
                    }
                } else if (orderByExpr.isNullFirst() == isPrevious) {
                    sb.append('(');
                    this.applyKeysetNotNullableItem(orderByExpr, sb, expr, i, key, keysetMode);
                    sb.append(" OR ");
                    this.applyKeysetNullItem(sb, expr, false);
                    sb.append(')');
                } else {
                    this.applyKeysetNotNullableItem(orderByExpr, sb, expr, i, key, keysetMode);
                }
            } else {
                this.applyKeysetNotNullableItem(orderByExpr, sb, expr, i, key, keysetMode);
            }
            if (!isNotLast) continue;
            if (generateEqualPredicate) {
                ++brackets;
                sb.append(" OR (");
                if (key[i] == null) {
                    this.applyKeysetNullItem(sb, expr, false);
                } else {
                    this.applyKeysetItem(sb, expr, "=", i, key[i]);
                }
            }
            sb.append(" AND ");
            if (i + 2 != expressionCount) {
                ++brackets;
                sb.append('(');
            }
            generateEqualPredicate = true;
        }
        for (i = 0; i < brackets; ++i) {
            sb.append(')');
        }
        this.queryGenerator.setConditionalContext(conditionalContext);
    }

    private void applyKeysetNotNullableItem(OrderByExpression orderByExpr, StringBuilder sb, Expression expr, int i, Serializable[] key, KeysetMode keysetMode) {
        String operator;
        switch (keysetMode) {
            case SAME: {
                operator = orderByExpr.isAscending() ? ">=" : "<=";
                break;
            }
            case NEXT: {
                operator = orderByExpr.isAscending() ? ">" : "<";
                break;
            }
            case PREVIOUS: {
                operator = orderByExpr.isAscending() ? "<" : ">";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key set mode: " + (Object)((Object)keysetMode));
            }
        }
        this.applyKeysetItem(sb, expr, operator, i, key[i]);
    }

    private void applyKeysetItem(StringBuilder sb, Expression expr, String operator, int position, Serializable keyElement) {
        this.queryGenerator.setQueryBuffer(sb);
        expr.accept((Expression.Visitor)this.queryGenerator);
        sb.append(" ");
        sb.append(operator);
        sb.append(" :");
        String parameterName = KEY_SET_PARAMETER_NAME + '_' + position;
        sb.append(parameterName);
        this.parameterManager.addParameterMapping(parameterName, keyElement);
    }

    private void applyKeysetNullItem(StringBuilder sb, Expression expr, boolean not) {
        this.queryGenerator.setQueryBuffer(sb);
        expr.accept((Expression.Visitor)this.queryGenerator);
        if (not) {
            sb.append(" IS NOT NULL");
        } else {
            sb.append(" IS NULL");
        }
    }
}

