/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import java.io.Serializable;

public class KeysetPaginationHelper {
    public static Serializable[] extractKey(Object[] tuple, int offset) {
        Serializable[] key = new Serializable[tuple.length - offset];
        System.arraycopy(tuple, offset, key, 0, key.length);
        return key;
    }

    public static KeysetMode getKeysetMode(KeysetPage keysetPage, int firstRow, int pageSize) {
        if (keysetPage == null) {
            return KeysetMode.NONE;
        }
        if (keysetPage.getMaxResults() != pageSize) {
            return KeysetMode.NONE;
        }
        int offset = keysetPage.getFirstResult() - firstRow;
        if (offset == pageSize) {
            if (KeysetPaginationHelper.isValidKey(keysetPage.getLowest())) {
                return KeysetMode.PREVIOUS;
            }
            return KeysetMode.NONE;
        }
        if (offset == -pageSize) {
            if (KeysetPaginationHelper.isValidKey(keysetPage.getHighest())) {
                return KeysetMode.NEXT;
            }
            return KeysetMode.NONE;
        }
        if (offset == 0) {
            if (KeysetPaginationHelper.isValidKey(keysetPage.getLowest())) {
                return KeysetMode.SAME;
            }
            return KeysetMode.NONE;
        }
        return KeysetMode.NONE;
    }

    private static boolean isValidKey(Keyset keyset) {
        if (keyset == null) {
            return false;
        }
        Serializable[] key = keyset.getTuple();
        return key != null && key.length > 0;
    }
}

