/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseCTECriteriaBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEBuilderListenerImpl;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import com.blazebit.persistence.impl.FinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.FullSelectCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.OngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.StartOngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.query.CTEQuerySpecification;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public abstract class AbstractCTECriteriaBuilder<Y, X extends BaseCTECriteriaBuilder<X>, Z, W>
extends AbstractCommonQueryBuilder<Object, X, Z, W, BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?>>
implements BaseCTECriteriaBuilder<X>,
SelectBuilder<X>,
CTEInfoBuilder {
    protected static final Integer EMPTY = -1;
    protected final Y result;
    protected final CTEBuilderListener listener;
    protected final String cteName;
    protected final EntityType<?> cteType;
    protected final Map<String, ExtendedAttribute> attributeEntries;
    protected final Map<String, Integer> bindingMap;
    protected final Map<String, String> columnBindingMap;
    protected final CTEBuilderListenerImpl subListener;
    private CTEInfo info;

    public AbstractCTECriteriaBuilder(MainQuery mainQuery, String cteName, Class<Object> clazz, Y result, CTEBuilderListener listener, BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder) {
        super(mainQuery, false, DbmsStatementType.SELECT, clazz, null, finalSetOperationBuilder, false);
        this.result = result;
        this.listener = listener;
        this.cteType = mainQuery.metamodel.entity(clazz);
        this.attributeEntries = mainQuery.metamodel.getManagedType(ExtendedManagedType.class, clazz).getAttributes();
        this.cteName = cteName;
        this.bindingMap = new LinkedHashMap<String, Integer>(this.attributeEntries.size());
        this.columnBindingMap = new LinkedHashMap<String, String>(this.attributeEntries.size());
        this.subListener = new CTEBuilderListenerImpl();
    }

    public CTEBuilderListenerImpl getSubListener() {
        return this.subListener;
    }

    @Override
    protected void buildExternalQueryString(StringBuilder sbSelectFrom) {
        this.buildBaseQueryString(sbSelectFrom, true);
    }

    @Override
    protected Query getQuery() {
        Query query;
        String baseQueryString = this.getBaseQueryStringWithCheck();
        Set<JoinNode> keyRestrictedLeftJoins = this.joinManager.getKeyRestrictedLeftJoins();
        if (this.hasLimit() || this.joinManager.hasEntityFunctions() || !keyRestrictedLeftJoins.isEmpty()) {
            query = this.em.createQuery(baseQueryString);
            Set<String> parameterListNames = this.parameterManager.getParameterListNames(query);
            String limit = null;
            String offset = null;
            if (!this.isMainQuery) {
                if (this.firstResult != 0) {
                    offset = Integer.toString(this.firstResult);
                }
                if (this.maxResults != Integer.MAX_VALUE) {
                    limit = Integer.toString(this.maxResults);
                }
            }
            List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases(query, keyRestrictedLeftJoins, Collections.EMPTY_SET);
            List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(query);
            CTEQuerySpecification querySpecification = new CTEQuerySpecification(this, query, this.parameterManager.getParameters(), parameterListNames, limit, offset, keyRestrictedLeftJoinAliases, entityFunctionNodes);
            query = new CustomSQLQuery(querySpecification, query, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        } else {
            query = this.em.createQuery(baseQueryString);
        }
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    public SelectBuilder<X> bind(String cteAttribute) {
        ExtendedAttribute attributeEntry = this.attributeEntries.get(cteAttribute);
        if (attributeEntry == null) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] does not exist!");
        }
        if (this.bindingMap.put(cteAttribute, this.selectManager.getSelectInfos().size()) != null) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] has already been bound!");
        }
        for (String column : attributeEntry.getColumnNames()) {
            if (this.columnBindingMap.put(column, cteAttribute) == null) continue;
            throw new IllegalArgumentException("The cte column [" + column + "] has already been bound!");
        }
        return this;
    }

    public Y end() {
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    protected void prepareAndCheck() {
        if (!this.needsCheck) {
            return;
        }
        try {
            List<String> attributes = this.prepareAndGetAttributes();
            List<String> columns = this.prepareAndGetColumnNames();
            super.prepareAndCheck();
            this.info = new CTEInfo(this.cteName, this.cteType, attributes, columns, false, false, this, null);
        }
        catch (RuntimeException ex) {
            this.needsCheck = true;
            throw ex;
        }
    }

    @Override
    public CTEInfo createCTEInfo() {
        this.prepareAndCheck();
        return this.info;
    }

    protected List<String> prepareAndGetAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(this.bindingMap.size());
        for (Map.Entry<String, Integer> bindingEntry : this.bindingMap.entrySet()) {
            String attributeName = bindingEntry.getKey();
            ExtendedAttribute attributeEntry = this.attributeEntries.get(attributeName);
            List attributePath = attributeEntry.getAttributePath();
            attributes.add(attributeName);
            if (!JpaMetamodelUtils.isJoinable((Attribute)((Attribute)attributePath.get(attributePath.size() - 1)))) continue;
            EntityType type = this.mainQuery.metamodel.entity(attributeEntry.getElementClass());
            SingularAttribute idAttribute = JpaMetamodelUtils.getIdAttribute(type);
            Expression selectExpression = this.selectManager.getSelectInfos().get(bindingEntry.getValue()).getExpression();
            if (selectExpression instanceof NullExpression) continue;
            if (selectExpression instanceof PathExpression) {
                PathExpression pathExpression = (PathExpression)selectExpression;
                if (idAttribute.getName().equals(((PathElementExpression)pathExpression.getExpressions().get(pathExpression.getExpressions().size() - 1)).toString())) continue;
                pathExpression.getExpressions().add(new PropertyExpression(idAttribute.getName()));
                continue;
            }
            throw new IllegalArgumentException("Illegal expression '" + selectExpression.toString() + "' for binding relation '" + attributeName + "'!");
        }
        return attributes;
    }

    protected List<String> prepareAndGetColumnNames() {
        StringBuilder sb = null;
        for (ExtendedAttribute entry : this.attributeEntries.values()) {
            for (String column : entry.getColumnNames()) {
                if (this.columnBindingMap.containsKey(column)) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append("[");
                } else {
                    sb.append(", ");
                }
                sb.append(column);
            }
        }
        if (sb != null) {
            sb.insert(0, "The following column names have not been bound: ");
            sb.append("]");
            throw new IllegalStateException(sb.toString());
        }
        return new ArrayList<String>(this.columnBindingMap.keySet());
    }

    protected BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> createFinalSetOperationBuilder(SetOperationType operator, boolean nested, boolean isSubquery) {
        FullSelectCTECriteriaBuilderImpl<?> newInitiator = this.finalSetOperationBuilder == null ? null : ((BaseFinalSetOperationCTECriteriaBuilderImpl)this.finalSetOperationBuilder).getInitiator();
        return this.createFinalSetOperationBuilder(operator, nested, isSubquery, newInitiator);
    }

    protected BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> createFinalSetOperationBuilder(SetOperationType operator, boolean nested, boolean isSubquery, FullSelectCTECriteriaBuilderImpl<?> initiator) {
        Y newResult;
        CTEBuilderListener newListener = this.finalSetOperationBuilder == null ? this.listener : ((BaseFinalSetOperationCTECriteriaBuilderImpl)this.finalSetOperationBuilder).getSubListener();
        Object object = newResult = this.finalSetOperationBuilder == null ? this.result : ((BaseFinalSetOperationCTECriteriaBuilderImpl)this.finalSetOperationBuilder).getResult();
        if (isSubquery) {
            return new OngoingFinalSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, this.cteType.getJavaType(), newResult, operator, nested, newListener, initiator);
        }
        return new FinalSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, this.cteType.getJavaType(), newResult, operator, nested, newListener, initiator);
    }

    protected LeafOngoingSetOperationCTECriteriaBuilderImpl<Y> createLeaf(BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder) {
        CTEBuilderListenerImpl newListener = finalSetOperationBuilder.getSubListener();
        LeafOngoingSetOperationCTECriteriaBuilderImpl<Y> next = new LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, this.cteName, (Class<Object>)this.cteType.getJavaType(), this.result, (CTEBuilderListener)newListener, (FinalSetOperationCTECriteriaBuilderImpl)finalSetOperationBuilder);
        newListener.onBuilderStarted(next);
        return next;
    }

    protected <T extends AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> StartOngoingSetOperationCTECriteriaBuilderImpl<Y, T> createStartOngoing(BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder, T endSetResult) {
        finalSetOperationBuilder.setEndSetResult(endSetResult);
        CTEBuilderListenerImpl newListener = finalSetOperationBuilder.getSubListener();
        StartOngoingSetOperationCTECriteriaBuilderImpl<Y, T> next = new StartOngoingSetOperationCTECriteriaBuilderImpl<Y, T>(this.mainQuery, this.cteName, this.cteType.getJavaType(), this.result, newListener, (OngoingFinalSetOperationCTECriteriaBuilderImpl)finalSetOperationBuilder, endSetResult);
        newListener.onBuilderStarted(next);
        return next;
    }

    protected <T extends AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> OngoingSetOperationCTECriteriaBuilderImpl<Y, T> createOngoing(BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder, T endSetResult) {
        finalSetOperationBuilder.setEndSetResult(endSetResult);
        CTEBuilderListenerImpl newListener = finalSetOperationBuilder.getSubListener();
        OngoingSetOperationCTECriteriaBuilderImpl<Y, T> next = new OngoingSetOperationCTECriteriaBuilderImpl<Y, T>(this.mainQuery, this.cteName, this.cteType.getJavaType(), this.result, newListener, (OngoingFinalSetOperationCTECriteriaBuilderImpl)finalSetOperationBuilder, endSetResult);
        newListener.onBuilderStarted(next);
        return next;
    }
}

