/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseDeleteCriteriaBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseDeleteCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionDeleteModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.query.ReturningCollectionDeleteModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class AbstractDeleteCollectionCriteriaBuilder<T, X extends BaseDeleteCriteriaBuilder<T, X>, Y>
extends BaseDeleteCriteriaBuilderImpl<T, X, Y> {
    private final String collectionName;

    public AbstractDeleteCollectionCriteriaBuilder(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias, String cteName, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, isMainQuery, clazz, alias, cteName, cteClass, result, listener);
        this.collectionName = collectionName;
        this.joinManager.join(this.entityAlias + "." + collectionName, "_collection", JoinType.LEFT, false, true);
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        if (externalRepresentation) {
            sbSelectFrom.append("DELETE FROM ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append('(').append(this.collectionName).append(") ");
            sbSelectFrom.append(this.entityAlias);
            this.appendWhereClause(sbSelectFrom);
        } else {
            sbSelectFrom.append("SELECT 1 FROM ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append(' ');
            sbSelectFrom.append(this.entityAlias);
            sbSelectFrom.append(" LEFT JOIN ");
            sbSelectFrom.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
            this.appendWhereClause(sbSelectFrom);
        }
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck());
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(baseQuery, isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        String sql = extendedQuerySupport.getSql(this.em, baseQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, this.entityAlias);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, "_collection");
        JoinTable joinTable = this.jpaProvider.getJoinTable(this.entityType, this.collectionName);
        if (joinTable == null) {
            throw new IllegalStateException("Deleting inverse collections is not supported!");
        }
        int joinTableIndex = SqlUtils.indexOfTableName(sql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(sql, joinTableIndex + joinTable.getTableName().length());
        String deleteSql = "delete from " + joinTable.getTableName();
        HashMap<String, String> columnExpressionRemappings = new HashMap<String, String>(joinTable.getIdColumnMappings().size());
        columnExpressionRemappings.put(collectionAlias + ".", joinTable.getTableName() + ".");
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            columnExpressionRemappings.put(ownerAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            columnExpressionRemappings.put(targetAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
        }
        if (returningColumns == null) {
            return new CollectionDeleteModificationQuerySpecification(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getDeleteExampleQuery(), deleteSql, columnExpressionRemappings);
        }
        return new ReturningCollectionDeleteModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getDeleteExampleQuery(), deleteSql, columnExpressionRemappings, objectBuilder);
    }

    protected Query getDeleteExampleQuery() {
        String exampleQueryString = "DELETE FROM " + ValuesEntity.class.getSimpleName();
        return this.em.createQuery(exampleQueryString);
    }
}

