/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.impl.AbstractQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.CriteriaBuilderImpl;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.PaginatedCriteriaBuilderImpl;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public abstract class AbstractFullQueryBuilder<T, X extends FullQueryBuilder<T, X>, Z, W, FinalSetReturn extends BaseFinalSetOperationBuilderImpl<T, ?, ?>>
extends AbstractQueryBuilder<T, X, Z, W, FinalSetReturn>
implements FullQueryBuilder<T, X> {
    private boolean createdPaginatedBuilder = false;
    private String cachedCountQueryString;

    protected AbstractFullQueryBuilder(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> builder) {
        super(builder);
    }

    public AbstractFullQueryBuilder(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias, FinalSetReturn finalSetOperationBuilder) {
        super(mainQuery, isMainQuery, clazz, alias, finalSetOperationBuilder);
    }

    @Override
    protected void prepareForModification() {
        super.prepareForModification();
        this.cachedCountQueryString = null;
    }

    public <Y> FullQueryBuilder<Y, ?> copy(Class<Y> resultClass) {
        this.prepareAndCheck();
        MainQuery mainQuery = this.cbf.createMainQuery(this.getEntityManager());
        CriteriaBuilderImpl<Y> newBuilder = new CriteriaBuilderImpl<Y>(mainQuery, true, resultClass, null);
        newBuilder.fromClassExplicitlySet = true;
        newBuilder.parameterManager.applyFrom(this.parameterManager);
        mainQuery.cteManager.applyFrom(this.mainQuery.cteManager);
        newBuilder.aliasManager.applyFrom(this.aliasManager);
        newBuilder.joinManager.applyFrom(this.joinManager);
        newBuilder.whereManager.applyFrom(this.whereManager);
        newBuilder.havingManager.applyFrom(this.havingManager);
        newBuilder.groupByManager.applyFrom(this.groupByManager);
        newBuilder.orderByManager.applyFrom(this.orderByManager);
        newBuilder.setFirstResult(this.firstResult);
        newBuilder.setMaxResults(this.maxResults);
        newBuilder.selectManager.setDefaultSelect(this.selectManager.getSelectInfos());
        return newBuilder;
    }

    private String getCountQueryStringWithoutCheck() {
        if (this.cachedCountQueryString == null) {
            this.cachedCountQueryString = this.buildPageCountQueryString(false);
        }
        return this.cachedCountQueryString;
    }

    protected String buildPageCountQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildPageCountQueryString(sbSelectFrom, externalRepresentation);
        return sbSelectFrom.toString();
    }

    private String buildPageCountQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Count queries do not support multiple from clause elements!");
        SingularAttribute idAttribute = JpaMetamodelUtils.getIdAttribute(this.mainQuery.metamodel.entity(rootNode.getJavaType()));
        String idName = idAttribute.getName();
        StringBuilder idClause = new StringBuilder(100);
        rootNode.appendDeReference(idClause, idName);
        String countString = this.jpaProvider.getCustomFunctionInvocation("count_tuple", 1) + "'DISTINCT'," + idClause + ")";
        sbSelectFrom.append("SELECT ").append(countString);
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        Set<JoinNode> countNodesToFetch = Collections.emptySet();
        Set<JoinNode> collectionJoinNodes = this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT), null, true, externalRepresentation, whereClauseConjuncts, this.explicitVersionEntities, countNodesToFetch);
        boolean hasCollectionJoinUsages = collectionJoinNodes.size() > 0;
        this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts);
        if (!hasCollectionJoinUsages) {
            int idx = sbSelectFrom.indexOf(countString);
            int endIdx = idx + countString.length() - 1;
            String countStar = this.jpaProvider.supportsCountStar() ? "COUNT(*" : this.jpaProvider.getCustomFunctionInvocation("count_star", 0);
            int i = idx;
            int j = 0;
            while (i < endIdx) {
                if (j < countStar.length()) {
                    sbSelectFrom.setCharAt(i, countStar.charAt(j));
                } else {
                    sbSelectFrom.setCharAt(i, ' ');
                }
                ++i;
                ++j;
            }
        }
        return sbSelectFrom.toString();
    }

    public TypedQuery<Long> getCountQuery() {
        this.prepareAndCheck();
        Set<JoinNode> keyRestrictedLeftJoins = this.joinManager.getKeyRestrictedLeftJoins();
        boolean normalQueryMode = !this.isMainQuery || !this.mainQuery.cteManager.hasCtes() && !this.joinManager.hasEntityFunctions() && keyRestrictedLeftJoins.isEmpty();
        String countQueryString = this.getCountQueryStringWithoutCheck();
        if (normalQueryMode && AbstractFullQueryBuilder.isEmpty(keyRestrictedLeftJoins, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT))) {
            TypedQuery countQuery = this.em.createQuery(countQueryString, Long.class);
            if (this.isCacheable()) {
                this.jpaProvider.setCacheable((Query)countQuery);
            }
            this.parameterManager.parameterizeQuery((Query)countQuery);
            return countQuery;
        }
        TypedQuery baseQuery = this.em.createQuery(countQueryString, Long.class);
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT));
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes((Query)baseQuery, false) : Collections.EMPTY_LIST;
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, this.parameterManager.getParameters(), parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
        CustomSQLTypedQuery<Long> countQuery = new CustomSQLTypedQuery<Long>(querySpecification, (Query)baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(countQuery);
        return countQuery;
    }

    public PaginatedCriteriaBuilder<T> page(int firstRow, int pageSize) {
        this.prepareForModification();
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a GROUP BY query");
        }
        this.createdPaginatedBuilder = true;
        return new PaginatedCriteriaBuilderImpl(this, false, null, firstRow, pageSize);
    }

    public PaginatedCriteriaBuilder<T> page(Object entityId, int pageSize) {
        this.prepareForModification();
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a GROUP BY query");
        }
        this.checkEntityId(entityId);
        this.createdPaginatedBuilder = true;
        return new PaginatedCriteriaBuilderImpl(this, false, entityId, pageSize);
    }

    public PaginatedCriteriaBuilder<T> page(KeysetPage keysetPage, int firstRow, int pageSize) {
        this.prepareForModification();
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a GROUP BY query");
        }
        this.createdPaginatedBuilder = true;
        return new PaginatedCriteriaBuilderImpl(this, true, keysetPage, firstRow, pageSize);
    }

    private void checkEntityId(Object entityId) {
        if (entityId == null) {
            throw new IllegalArgumentException("Invalid null entity id given");
        }
        EntityType<?> entityType = this.mainQuery.metamodel.entity(this.joinManager.getRootNodeOrFail("Paginated queries do not support multiple from clause elements!").getJavaType());
        SingularAttribute idAttribute = JpaMetamodelUtils.getIdAttribute(entityType);
        Class idType = JpaMetamodelUtils.resolveFieldClass((Class)entityType.getJavaType(), (Attribute)idAttribute);
        if (!idType.isInstance(entityId)) {
            throw new IllegalArgumentException("The type of the given entity id '" + entityId.getClass().getName() + "' is not an instance of the expected id type '" + idType.getName() + "' of the entity class '" + entityType.getJavaType().getName() + "'");
        }
    }

    public <Y> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(Class<Y> clazz) {
        this.prepareForModification();
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectNew(this, clazz);
    }

    public <Y> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(Constructor<Y> constructor) {
        this.prepareForModification();
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectNew(this, constructor);
    }

    public <Y> FullQueryBuilder<Y, ?> selectNew(ObjectBuilder<Y> objectBuilder) {
        this.prepareForModification();
        if (objectBuilder == null) {
            throw new NullPointerException("objectBuilder");
        }
        this.verifyBuilderEnded();
        this.selectManager.selectNew(this, objectBuilder);
        return this;
    }

    public X fetch(String path) {
        this.prepareForModification();
        this.verifyBuilderEnded();
        this.joinManager.implicitJoin((Expression)this.expressionFactory.createPathExpression(path), true, null, null, null, false, false, true, false, true);
        return (X)this;
    }

    public X fetch(String ... paths) {
        this.prepareForModification();
        this.verifyBuilderEnded();
        for (String path : paths) {
            this.joinManager.implicitJoin((Expression)this.expressionFactory.createPathExpression(path), true, null, null, null, false, false, true, false, true);
        }
        return (X)this;
    }

    public X innerJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.INNER, true);
    }

    public X innerJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.INNER, true);
    }

    public X leftJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.LEFT, true);
    }

    public X leftJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.LEFT, true);
    }

    public X rightJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.RIGHT, true);
    }

    public X rightJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.RIGHT, true);
    }

    public X join(String path, String alias, JoinType type, boolean fetch) {
        return this.join(path, alias, type, fetch, false);
    }

    public X joinDefault(String path, String alias, JoinType type, boolean fetch) {
        return this.join(path, alias, type, fetch, true);
    }

    private X join(String path, String alias, JoinType type, boolean fetch, boolean defaultJoin) {
        this.prepareForModification();
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (alias.isEmpty()) {
            throw new IllegalArgumentException("Empty alias");
        }
        this.verifyBuilderEnded();
        this.joinManager.join(path, alias, type, fetch, defaultJoin);
        return (X)this;
    }

    @Override
    public X groupBy(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.groupBy(expression));
    }

    @Override
    public X groupBy(String ... paths) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.groupBy(paths));
    }

    @Override
    public X distinct() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling distinct() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.distinct());
    }
}

