/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseInsertCriteriaBuilder;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseInsertCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionInsertModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.query.ReturningCollectionInsertModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.AttributePath;
import com.blazebit.persistence.parser.QualifiedAttribute;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class AbstractInsertCollectionCriteriaBuilder<T, X extends BaseInsertCriteriaBuilder<T, X>, Y>
extends BaseInsertCriteriaBuilderImpl<T, X, Y> {
    private static final String COLLECTION_BASE_QUERY_ALIAS = "_collection";
    private final String collectionName;

    public AbstractInsertCollectionCriteriaBuilder(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String cteName, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, isMainQuery, clazz, cteName, cteClass, result, listener);
        this.collectionName = collectionName;
    }

    @Override
    protected void appendInsertIntoFragment(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        super.appendInsertIntoFragment(sbSelectFrom, externalRepresentation);
        if (externalRepresentation) {
            sbSelectFrom.append('.').append(this.collectionName);
        }
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        if (externalRepresentation) {
            super.buildBaseQueryString(sbSelectFrom, externalRepresentation);
        } else {
            this.buildSelectBaseQueryString(sbSelectFrom, externalRepresentation);
        }
    }

    @Override
    protected void addBind(String attributeName) {
        AttributePath attributePath = JpaMetamodelUtils.getJoinTableCollectionAttributePath((Metamodel)this.getMetamodel(), (EntityType)this.entityType, (String)attributeName, (String)this.collectionName);
        StringBuilder sb = new StringBuilder();
        List attributes = attributePath.getAttributes();
        Attribute attribute = (Attribute)attributes.get(0);
        if (attribute instanceof QualifiedAttribute) {
            sb.append(((QualifiedAttribute)attribute).getQualificationExpression());
            sb.append('(');
            sb.append(COLLECTION_BASE_QUERY_ALIAS);
            sb.append(')');
        } else if (this.collectionName.equals(attribute.getName())) {
            sb.append(COLLECTION_BASE_QUERY_ALIAS);
        } else {
            sb.append(this.entityAlias).append('.');
            sb.append(attribute.getName());
        }
        for (int i = 1; i < attributes.size(); ++i) {
            attribute = (Attribute)attributes.get(i);
            sb.append('.');
            sb.append(attribute.getName());
        }
        attributeName = sb.toString();
        Integer attributeBindIndex = (Integer)this.bindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.bindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck());
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        baseQuery.setFirstResult(this.firstResult);
        baseQuery.setMaxResults(this.maxResults);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        baseQuery.setFirstResult(this.firstResult);
        baseQuery.setMaxResults(this.maxResults);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        Set<JoinNode> keyRestrictedLeftJoins = this.joinManager.getKeyRestrictedLeftJoins();
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases(baseQuery, keyRestrictedLeftJoins, Collections.EMPTY_SET);
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(baseQuery);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(baseQuery, isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        Query insertExampleQuery = this.getInsertExampleQuery();
        String insertExampleSql = extendedQuerySupport.getSql(this.em, insertExampleQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, insertExampleQuery, this.entityAlias);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, insertExampleQuery, COLLECTION_BASE_QUERY_ALIAS);
        JoinTable joinTable = this.jpaProvider.getJoinTable(this.entityType, this.collectionName);
        int joinTableIndex = SqlUtils.indexOfTableName(insertExampleSql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(insertExampleSql, joinTableIndex + joinTable.getTableName().length());
        String[] selectItemExpressions = SqlUtils.getSelectItemExpressions(insertExampleSql, SqlUtils.indexOfSelect(insertExampleSql));
        HashMap columnExpressionRemappings = new HashMap(selectItemExpressions.length);
        if (joinTable.getKeyColumnMappings() != null) {
            for (Map.Entry entry : joinTable.getKeyColumnMappings().entrySet()) {
                columnExpressionRemappings.put(collectionAlias + "." + (String)entry.getValue(), entry.getKey());
            }
        }
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            columnExpressionRemappings.put(ownerAlias + "." + (String)entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            columnExpressionRemappings.put(targetAlias + "." + (String)entry.getValue(), entry.getKey());
        }
        StringBuilder insertSqlSb = new StringBuilder();
        insertSqlSb.append("insert into ").append(joinTable.getTableName()).append("(");
        for (String selectItemExpression : selectItemExpressions) {
            insertSqlSb.append((String)columnExpressionRemappings.get(selectItemExpression.trim())).append(',');
        }
        insertSqlSb.setCharAt(insertSqlSb.length() - 1, ')');
        if (returningColumns == null) {
            return new CollectionInsertModificationQuerySpecification(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getInsertExecutorQuery(), insertSqlSb.toString());
        }
        return new ReturningCollectionInsertModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getInsertExecutorQuery(), insertSqlSb.toString(), objectBuilder);
    }

    protected Query getInsertExampleQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (Map.Entry entry : this.bindingMap.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("FROM ");
        sb.append(this.entityType.getName());
        sb.append(' ');
        sb.append(this.entityAlias);
        sb.append(" LEFT JOIN ");
        sb.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append(COLLECTION_BASE_QUERY_ALIAS);
        return this.em.createQuery(sb.toString());
    }

    protected Query getInsertExecutorQuery() {
        String exampleQueryString = "UPDATE " + ValuesEntity.class.getSimpleName() + " SET value = NULL";
        return this.em.createQuery(exampleQueryString);
    }
}

