/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseUpdateCriteriaBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.BaseUpdateCriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CollectionUpdateModificationQuerySpecification;
import com.blazebit.persistence.impl.query.CustomReturningSQLTypedQuery;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.query.ReturningCollectionUpdateModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.AttributePath;
import com.blazebit.persistence.parser.QualifiedAttribute;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class AbstractUpdateCollectionCriteriaBuilder<T, X extends BaseUpdateCriteriaBuilder<T, X>, Y>
extends BaseUpdateCriteriaBuilderImpl<T, X, Y> {
    private final String collectionName;
    private List<String> cachedBaseQueryStrings;

    public AbstractUpdateCollectionCriteriaBuilder(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias, String cteName, Class<?> cteClass, Y result, CTEBuilderListener listener, String collectionName) {
        super(mainQuery, isMainQuery, clazz, alias, cteName, cteClass, result, listener);
        this.collectionName = collectionName;
        this.joinManager.join(this.entityAlias + "." + collectionName, "_collection", JoinType.LEFT, false, true);
    }

    @Override
    protected String checkAttribute(String attributeName) {
        AttributePath attributePath = JpaMetamodelUtils.getJoinTableCollectionAttributePath((Metamodel)this.getMetamodel(), (EntityType)this.entityType, (String)attributeName, (String)this.collectionName);
        StringBuilder sb = new StringBuilder();
        for (Attribute attribute : attributePath.getAttributes()) {
            if (attribute instanceof QualifiedAttribute) {
                sb.append(((QualifiedAttribute)attribute).getQualificationExpression());
                sb.append('(');
                sb.append("_collection");
                sb.append(')');
            } else if (this.collectionName.equals(attribute.getName())) {
                sb.append("_collection");
            } else {
                sb.append(attribute.getName());
            }
            sb.append('.');
        }
        attributeName = sb.substring(0, sb.length() - 1);
        Expression attributeExpression = (Expression)this.setAttributes.get(attributeName);
        if (attributeExpression != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        return attributeName;
    }

    @Override
    protected void prepareForModification() {
        super.prepareForModification();
        this.cachedBaseQueryStrings = null;
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        if (externalRepresentation) {
            sbSelectFrom.append("UPDATE ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append('(').append(this.collectionName).append(") ");
            sbSelectFrom.append(this.entityAlias);
            this.appendSetClause(sbSelectFrom);
            this.appendWhereClause(sbSelectFrom);
        } else {
            sbSelectFrom.append("SELECT 1 FROM ");
            sbSelectFrom.append(this.entityType.getName());
            sbSelectFrom.append(' ');
            sbSelectFrom.append(this.entityAlias);
            sbSelectFrom.append(" LEFT JOIN ");
            sbSelectFrom.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
            this.appendWhereClause(sbSelectFrom);
            this.cachedBaseQueryStrings = new ArrayList<String>();
            StringBuilder sbSetExpressionQuery = new StringBuilder();
            for (Map.Entry attributeEntry : this.setAttributes.entrySet()) {
                this.fillCachedBaseQueryStrings(sbSetExpressionQuery, (String)attributeEntry.getKey(), (Expression)attributeEntry.getValue());
            }
        }
    }

    private void fillCachedBaseQueryStrings(StringBuilder sbSetExpressionQuery, String attributePath, Expression value) {
        sbSetExpressionQuery.setLength(0);
        StringBuilder oldBuffer = this.queryGenerator.getQueryBuffer();
        this.queryGenerator.setClauseType(ClauseType.SET);
        this.queryGenerator.setQueryBuffer(sbSetExpressionQuery);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        sbSetExpressionQuery.append("SELECT 1 FROM ");
        sbSetExpressionQuery.append(this.entityType.getName());
        sbSetExpressionQuery.append(' ');
        sbSetExpressionQuery.append(this.entityAlias);
        sbSetExpressionQuery.append(" LEFT JOIN ");
        sbSetExpressionQuery.append(this.entityAlias).append('.').append(this.collectionName).append(' ').append("_collection");
        sbSetExpressionQuery.append(" WHERE ");
        sbSetExpressionQuery.append(attributePath).append('=');
        value.accept((Expression.Visitor)this.queryGenerator);
        this.cachedBaseQueryStrings.add(sbSetExpressionQuery.toString());
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
        this.queryGenerator.setQueryBuffer(oldBuffer);
    }

    @Override
    protected boolean appendSetElementEntityPrefix(String trimmedPath) {
        return !trimmedPath.startsWith("_collection") && super.appendSetElementEntityPrefix(trimmedPath);
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        Query baseQuery = this.em.createQuery(this.getBaseQueryStringWithCheck());
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, this.getCountExampleQuery(), this.getReturningColumns(), null, includedModificationStates);
        CustomSQLQuery query = new CustomSQLQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    @Override
    protected <R> TypedQuery<ReturningResult<R>> getExecuteWithReturningQuery(TypedQuery<Object[]> exampleQuery, Query baseQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder) {
        QuerySpecification querySpecification = this.getQuerySpecification(baseQuery, (Query)exampleQuery, returningColumns, objectBuilder, null);
        CustomReturningSQLTypedQuery query = new CustomReturningSQLTypedQuery(querySpecification, exampleQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query);
        return query;
    }

    private <R> QuerySpecification getQuerySpecification(Query baseQuery, Query exampleQuery, String[] returningColumns, ReturningObjectBuilder<R> objectBuilder, Map<DbmsModificationState, String> includedModificationStates) {
        Set<String> parameterListNames = this.parameterManager.getParameterListNames(baseQuery);
        boolean isEmbedded = this instanceof ReturningBuilder;
        boolean shouldRenderCteNodes = this.renderCteNodes(isEmbedded);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(baseQuery, isEmbedded) : Collections.EMPTY_LIST;
        ExtendedQuerySupport extendedQuerySupport = this.getService(ExtendedQuerySupport.class);
        String sql = extendedQuerySupport.getSql(this.em, baseQuery);
        String ownerAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, this.entityAlias);
        String targetAlias = extendedQuerySupport.getSqlAlias(this.em, baseQuery, "_collection");
        JoinTable joinTable = this.jpaProvider.getJoinTable(this.entityType, this.collectionName);
        int joinTableIndex = SqlUtils.indexOfTableName(sql, joinTable.getTableName());
        String collectionAlias = SqlUtils.extractAlias(sql, joinTableIndex + joinTable.getTableName().length());
        String updateSql = "update " + joinTable.getTableName() + " set ";
        HashMap<String, String> columnOnlyRemappings = new HashMap<String, String>();
        HashMap<String, String> columnExpressionRemappings = new HashMap<String, String>();
        if (joinTable.getKeyColumnMappings() != null) {
            for (Map.Entry entry : joinTable.getKeyColumnMappings().entrySet()) {
                columnOnlyRemappings.put(collectionAlias + "." + (String)entry.getValue(), (String)entry.getKey());
                columnExpressionRemappings.put(collectionAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
            }
        }
        for (Map.Entry entry : joinTable.getIdColumnMappings().entrySet()) {
            columnOnlyRemappings.put(ownerAlias + "." + (String)entry.getValue(), (String)entry.getKey());
            columnExpressionRemappings.put(ownerAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
        }
        for (Map.Entry entry : joinTable.getTargetColumnMappings().entrySet()) {
            columnOnlyRemappings.put(targetAlias + "." + (String)entry.getValue(), (String)entry.getKey());
            columnExpressionRemappings.put(targetAlias + "." + (String)entry.getValue(), joinTable.getTableName() + "." + (String)entry.getKey());
        }
        ArrayList<Query> setExpressionContainingUpdateQueries = new ArrayList<Query>();
        for (String cachedBaseQueryString : this.cachedBaseQueryStrings) {
            Query setExpressionQuery = this.em.createQuery(cachedBaseQueryString);
            parameterListNames.addAll(this.parameterManager.getParameterListNames(baseQuery));
            setExpressionContainingUpdateQueries.add(setExpressionQuery);
        }
        if (returningColumns == null) {
            return new CollectionUpdateModificationQuerySpecification(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getUpdateExampleQuery(), updateSql, setExpressionContainingUpdateQueries, columnOnlyRemappings, columnExpressionRemappings);
        }
        return new ReturningCollectionUpdateModificationQuerySpecification<R>(this, baseQuery, exampleQuery, this.parameterManager.getParameters(), parameterListNames, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, this.returningAttributeBindingMap, this.getUpdateExampleQuery(), updateSql, setExpressionContainingUpdateQueries, columnOnlyRemappings, columnExpressionRemappings, objectBuilder);
    }

    protected Query getUpdateExampleQuery() {
        String exampleQueryString = "UPDATE " + ValuesEntity.class.getSimpleName() + " SET value = NULL";
        return this.em.createQuery(exampleQueryString);
    }
}

