/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.SelectInfo;
import java.util.HashMap;
import java.util.Map;

public class AliasManager {
    private static final int DEFAULT_IMPLICIT_ALIAS_START_IDX = 0;
    private final AliasManager parent;
    private final Map<String, AliasInfo> aliasMap = new HashMap<String, AliasInfo>();
    private final Map<String, Integer> aliasCounterMap = new HashMap<String, Integer>();

    public AliasManager() {
        this.parent = null;
    }

    public AliasManager(AliasManager parent) {
        this.parent = parent;
    }

    public AliasManager getParent() {
        return this.parent;
    }

    public AliasInfo getAliasInfo(String alias) {
        return this.getHierarchical(alias);
    }

    public AliasInfo getAliasInfoForBottomLevel(String alias) {
        return this.aliasMap.get(alias);
    }

    public void applyFrom(AliasManager aliasManager) {
        this.aliasCounterMap.putAll(aliasManager.aliasCounterMap);
    }

    public String registerAliasInfo(AliasInfo aliasInfo) {
        String alias = aliasInfo.getAlias();
        if (this.getHierarchical(alias) != null) {
            throw new IllegalArgumentException("Alias '" + alias + "' already exists");
        }
        this.aliasMap.put(alias, aliasInfo);
        this.aliasCounterMap.put(alias, 0);
        return alias;
    }

    public String generateRootAlias(String alias) {
        return this.generatePostfixedAlias(alias, 0);
    }

    public String generateJoinAlias(String alias) {
        return this.generatePostfixedAlias(alias, 1);
    }

    private String generatePostfixedAlias(String alias, int startIdx) {
        String nonPostfixed = alias;
        Integer counter = this.getCounterHierarchical(alias);
        if (counter == null) {
            counter = startIdx;
        } else {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
        alias = alias + "_" + counter;
        this.aliasCounterMap.put(nonPostfixed, counter);
        return alias;
    }

    private AliasInfo getHierarchical(String alias) {
        AliasInfo info = this.aliasMap.get(alias);
        if (info == null && this.parent != null) {
            info = this.parent.getHierarchical(alias);
        }
        return info;
    }

    private Integer getCounterHierarchical(String alias) {
        Integer counter = this.aliasCounterMap.get(alias);
        if (counter == null && this.parent != null) {
            counter = this.parent.getCounterHierarchical(alias);
        }
        return counter;
    }

    public void unregisterAliasInfoForBottomLevel(AliasInfo aliasInfo) {
        String alias = aliasInfo.getAlias();
        if (alias != null) {
            this.aliasMap.remove(alias);
            int counter = this.aliasCounterMap.get(alias);
            if (alias.endsWith("_" + counter)) {
                if (counter == 0) {
                    this.aliasCounterMap.remove(alias);
                } else {
                    this.aliasCounterMap.put(alias, counter - 1);
                }
            }
        }
    }

    public Map<String, AliasInfo> getAliasMapForBottomLevel() {
        return this.aliasMap;
    }

    public boolean isSelectAlias(String alias) {
        AliasInfo info = this.aliasMap.get(alias);
        if (info != null) {
            return info instanceof SelectInfo;
        }
        return false;
    }
}

