/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.BaseOngoingFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.DefaultOrderByElement;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.SetOperationQuerySpecification;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class BaseFinalSetOperationBuilderImpl<T, X extends BaseFinalSetOperationBuilder<T, X>, Y extends BaseFinalSetOperationBuilderImpl<T, X, Y>>
extends AbstractCommonQueryBuilder<T, X, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, Y>
implements BaseFinalSetOperationBuilder<T, X>,
BaseOngoingFinalSetOperationBuilder<T, X> {
    protected T endSetResult;
    protected final SetOperationManager setOperationManager;
    protected final List<DefaultOrderByElement> orderByElements;

    public BaseFinalSetOperationBuilderImpl(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, SetOperationType operator, boolean nested, T endSetResult) {
        super(mainQuery, isMainQuery, DbmsStatementType.SELECT, clazz, null, null, false);
        this.endSetResult = endSetResult;
        this.setOperationManager = new SetOperationManager(operator, nested);
        this.orderByElements = new ArrayList<DefaultOrderByElement>(0);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.setOperationManager.isEmpty();
    }

    private static boolean isNestedAndComplex(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            BaseFinalSetOperationBuilderImpl builder = (BaseFinalSetOperationBuilderImpl)queryBuilder;
            return builder.setOperationManager.isNested() && (builder.setOperationManager.hasSetOperations() || BaseFinalSetOperationBuilderImpl.isNestedAndComplex(builder.setOperationManager.getStartQueryBuilder()));
        }
        return false;
    }

    @Override
    public X orderBy(String expression, boolean ascending, boolean nullFirst) {
        this.prepareAndCheck();
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> leftMostQuery = this.getLeftMost(this.setOperationManager.getStartQueryBuilder());
        AliasInfo aliasInfo = leftMostQuery.aliasManager.getAliasInfo(expression);
        if (aliasInfo != null) {
            int position = this.cbf.getExtendedQuerySupport().getSqlSelectAliasPosition(this.em, leftMostQuery.getTypedQueryForFinalOperationBuilder(), expression);
            this.orderByElements.add(new DefaultOrderByElement(expression, position, ascending, nullFirst));
            return (X)this;
        }
        int position = this.cbf.getExtendedQuerySupport().getSqlSelectAttributePosition(this.em, leftMostQuery.getTypedQueryForFinalOperationBuilder(), expression);
        this.orderByElements.add(new DefaultOrderByElement(expression, position, ascending, nullFirst));
        return (X)this;
    }

    private AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getLeftMost(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            return this.getLeftMost(((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager.getStartQueryBuilder());
        }
        return queryBuilder;
    }

    protected List<? extends OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public T getEndSetResult() {
        return this.endSetResult;
    }

    public void setEndSetResult(T endSetResult) {
        this.endSetResult = endSetResult;
    }

    public T endSet() {
        this.setOperationEnded = true;
        this.prepareAndCheck();
        return this.endSetResult;
    }

    @Override
    protected void prepareAndCheck() {
    }

    public void verifyBuilderEnded(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> currentBuilder) {
        if (!this.setOperationEnded) {
            throw new IllegalStateException("Set operation builder not properly ended!");
        }
        super.verifyBuilderEnded();
        if (currentBuilder == this.setOperationManager.getStartQueryBuilder()) {
            return;
        }
        this.verifySetOperationEnded(this.setOperationManager.getStartQueryBuilder());
        for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
            if (currentBuilder == setOperand) {
                return;
            }
            this.verifySetOperationEnded(setOperand);
        }
    }

    private void verifySetOperationEnded(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        if (builder instanceof BaseFinalSetOperationBuilderImpl) {
            builder.verifyBuilderEnded();
        } else if (!builder.setOperationEnded) {
            throw new IllegalStateException("Set operation builder not properly ended!");
        }
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        boolean nested = BaseFinalSetOperationBuilderImpl.isNestedAndComplex(this.setOperationManager.getStartQueryBuilder());
        if (nested) {
            sbSelectFrom.append('(');
        }
        this.setOperationManager.getStartQueryBuilder().buildBaseQueryString(sbSelectFrom, externalRepresentation);
        if (nested) {
            sbSelectFrom.append(')');
        }
        if (this.setOperationManager.hasSetOperations()) {
            String operator = this.getOperator(this.setOperationManager.getOperator());
            for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
                sbSelectFrom.append("\n");
                sbSelectFrom.append(operator);
                sbSelectFrom.append("\n");
                nested = BaseFinalSetOperationBuilderImpl.isNestedAndComplex(setOperand);
                if (nested) {
                    sbSelectFrom.append('(');
                }
                setOperand.buildBaseQueryString(sbSelectFrom, externalRepresentation);
                if (!nested) continue;
                sbSelectFrom.append(')');
            }
            this.applySetOrderBy(sbSelectFrom);
            this.applyJpaLimit(sbSelectFrom);
        }
    }

    protected void applySetOrderBy(StringBuilder sbSelectFrom) {
        if (this.orderByElements.isEmpty()) {
            return;
        }
        sbSelectFrom.append("\nORDER BY ");
        for (int i = 0; i < this.orderByElements.size(); ++i) {
            if (i != 0) {
                sbSelectFrom.append(", ");
            }
            DefaultOrderByElement elem = this.orderByElements.get(i);
            sbSelectFrom.append(elem.getName());
            if (elem.isAscending()) {
                sbSelectFrom.append(" ASC");
            } else {
                sbSelectFrom.append(" DESC");
            }
            if (elem.isNullsFirst()) {
                sbSelectFrom.append(" NULLS FIRST");
                continue;
            }
            sbSelectFrom.append(" NULLS LAST");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected TypedQuery<T> getTypedQuery() {
        void var6_9;
        Query baseQuery;
        Object customQueryParticipants;
        AbstractCustomQuery customQuery;
        HashSet<String> parameterListNames = new HashSet<String>();
        Query leftMostQuery = this.setOperationManager.getStartQueryBuilder().getTypedQueryForFinalOperationBuilder();
        this.parameterManager.collectParameterListNames(leftMostQuery, parameterListNames);
        if (leftMostQuery instanceof CustomSQLQuery) {
            customQuery = (CustomSQLQuery)leftMostQuery;
            customQueryParticipants = customQuery.getParticipatingQueries();
            baseQuery = customQueryParticipants.get(0);
        } else if (leftMostQuery instanceof CustomSQLTypedQuery) {
            customQuery = (CustomSQLTypedQuery)leftMostQuery;
            customQueryParticipants = customQuery.getParticipatingQueries();
            baseQuery = customQueryParticipants.get(0);
        } else {
            baseQuery = leftMostQuery;
        }
        ArrayList<Query> setOperands = new ArrayList<Query>();
        for (AbstractCommonQueryBuilder abstractCommonQueryBuilder : this.setOperationManager.getSetOperations()) {
            Query q = abstractCommonQueryBuilder.getQuery();
            setOperands.add(q);
            this.parameterManager.collectParameterListNames(q, parameterListNames);
        }
        String limit = null;
        Object var6_7 = null;
        if (!this.isMainQuery) {
            if (this.firstResult != 0) {
                String string = Integer.toString(this.firstResult);
            }
            if (this.maxResults != Integer.MAX_VALUE) {
                limit = Integer.toString(this.maxResults);
            }
        }
        List<String> keyRestrictedLeftJoinAliases = Collections.emptyList();
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(baseQuery, false) : Collections.EMPTY_LIST;
        SetOperationQuerySpecification querySpecification = new SetOperationQuerySpecification(this, leftMostQuery, baseQuery, setOperands, this.setOperationManager.getOperator(), this.getOrderByElements(), this.setOperationManager.isNested(), this.parameterManager.getParameters(), parameterListNames, limit, (String)var6_9, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
        CustomSQLTypedQuery query = new CustomSQLTypedQuery(querySpecification, baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        if (this.isMainQuery) {
            if (this.firstResult != 0) {
                query.setFirstResult(this.firstResult);
            }
            if (this.maxResults != Integer.MAX_VALUE) {
                query.setMaxResults(this.maxResults);
            }
        }
        this.parameterManager.parameterizeQuery(query);
        return this.applyObjectBuilder(query);
    }

    protected String getOperator(SetOperationType type) {
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT ALL";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT ALL";
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public TypedQuery<T> getQuery() {
        return this.getTypedQuery();
    }

    public List<T> getResultList() {
        return this.getTypedQuery().getResultList();
    }

    public T getSingleResult() {
        return (T)this.getTypedQuery().getSingleResult();
    }
}

