/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseUpdateCriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractModificationCriteriaBuilder;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.SubqueryBuilderListener;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsStatementType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;

public class BaseUpdateCriteriaBuilderImpl<T, X extends BaseUpdateCriteriaBuilder<T, X>, Y>
extends AbstractModificationCriteriaBuilder<T, X, Y>
implements BaseUpdateCriteriaBuilder<T, X>,
SubqueryBuilderListener<X>,
ExpressionBuilderEndedListener {
    protected final Map<String, Expression> setAttributes = new LinkedHashMap<String, Expression>();
    private SubqueryInternalBuilder<X> currentSubqueryBuilder;
    private String currentAttribute;

    public BaseUpdateCriteriaBuilderImpl(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias, String cteName, Class<?> cteClass, Y result, CTEBuilderListener listener) {
        super(mainQuery, isMainQuery, DbmsStatementType.UPDATE, clazz, alias, cteName, cteClass, result, listener);
    }

    public X set(String attributeName, Object value) {
        this.verifyBuilderEnded();
        attributeName = this.checkAttribute(attributeName);
        ParameterExpression attributeExpression = this.parameterManager.addParameterExpression(value, ClauseType.SET);
        this.setAttributes.put(attributeName, (Expression)attributeExpression);
        return (X)this;
    }

    public X setExpression(String attributeName, String expression) {
        this.verifyBuilderEnded();
        attributeName = this.checkAttribute(attributeName);
        Expression attributeExpression = this.expressionFactory.createScalarExpression(expression);
        this.parameterManager.collectParameterRegistrations(attributeExpression, ClauseType.SET);
        this.setAttributes.put(attributeName, attributeExpression);
        return (X)this;
    }

    public SubqueryInitiator<X> set(String attribute) {
        this.verifySubqueryBuilderEnded();
        this.currentAttribute = attribute = this.checkAttribute(attribute);
        return this.subqueryInitFactory.createSubqueryInitiator(this, this, false);
    }

    public MultipleSubqueryInitiator<X> setSubqueries(String attribute, String expression) {
        this.verifySubqueryBuilderEnded();
        this.currentAttribute = attribute = this.checkAttribute(attribute);
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        MultipleSubqueryInitiatorImpl<BaseUpdateCriteriaBuilderImpl> initiator = new MultipleSubqueryInitiatorImpl<BaseUpdateCriteriaBuilderImpl>(this, expr, this, this.subqueryInitFactory);
        return initiator;
    }

    public SubqueryBuilder<X> set(String attribute, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        this.currentAttribute = attribute = this.checkAttribute(attribute);
        return this.subqueryInitFactory.createSubqueryBuilder(this, this, false, criteriaBuilder);
    }

    private void verifySubqueryBuilderEnded() {
        if (this.currentAttribute != null) {
            throw new BuilderChainingException("An initiator was not ended properly.");
        }
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("An subquery builder was not ended properly.");
        }
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        if (this.currentAttribute == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        Expression attributeExpression = builder.getExpression();
        this.parameterManager.collectParameterRegistrations(attributeExpression, ClauseType.SET);
        this.setAttributes.put(this.currentAttribute, attributeExpression);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
        if (this.currentAttribute == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        if (this.currentSubqueryBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        SubqueryExpression attributeExpression = new SubqueryExpression(builder);
        this.parameterManager.collectParameterRegistrations((Expression)attributeExpression, ClauseType.SET);
        this.setAttributes.put(this.currentAttribute, (Expression)attributeExpression);
        this.currentAttribute = null;
        this.currentSubqueryBuilder = null;
    }

    @Override
    public void onBuilderStarted(SubqueryInternalBuilder<X> builder) {
        if (this.currentAttribute == null) {
            throw new BuilderChainingException("There was an attempt to start a builder without an originating initiator.");
        }
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentSubqueryBuilder = builder;
    }

    @Override
    public void onReplaceBuilder(SubqueryInternalBuilder<X> oldBuilder, SubqueryInternalBuilder<X> newBuilder) {
        throw new IllegalArgumentException("Replace not valid!");
    }

    @Override
    public void onInitiatorStarted(SubqueryInitiator<?> initiator) {
        throw new IllegalArgumentException("Initiator started not valid!");
    }

    protected String checkAttribute(String attributeName) {
        JpaMetamodelUtils.getBasicAttributePath((Metamodel)this.getMetamodel(), (ManagedType)this.entityType, (String)attributeName);
        Expression attributeExpression = this.setAttributes.get(attributeName);
        if (attributeExpression != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        return attributeName;
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        sbSelectFrom.append("UPDATE ");
        sbSelectFrom.append(this.entityType.getName()).append(' ');
        sbSelectFrom.append(this.entityAlias);
        this.appendSetClause(sbSelectFrom);
        this.appendWhereClause(sbSelectFrom);
    }

    protected void appendSetClause(StringBuilder sbSelectFrom) {
        sbSelectFrom.append(" SET ");
        this.queryGenerator.setClauseType(ClauseType.SET);
        this.queryGenerator.setQueryBuffer(sbSelectFrom);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        Iterator<Map.Entry<String, Expression>> setAttributeIter = this.setAttributes.entrySet().iterator();
        if (setAttributeIter.hasNext()) {
            Map.Entry<String, Expression> attributeEntry = setAttributeIter.next();
            this.appendSetElement(sbSelectFrom, attributeEntry.getKey(), attributeEntry.getValue());
            while (setAttributeIter.hasNext()) {
                attributeEntry = setAttributeIter.next();
                sbSelectFrom.append(',');
                this.appendSetElement(sbSelectFrom, attributeEntry.getKey(), attributeEntry.getValue());
            }
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
    }

    protected final void appendSetElement(StringBuilder sbSelectFrom, String attribute, Expression valueExpression) {
        String trimmedPath = attribute.trim();
        if (this.appendSetElementEntityPrefix(trimmedPath)) {
            sbSelectFrom.append(this.entityAlias).append('.');
        }
        sbSelectFrom.append(attribute);
        sbSelectFrom.append(" = ");
        this.queryGenerator.generate(valueExpression);
    }

    protected boolean appendSetElementEntityPrefix(String trimmedPath) {
        String indexStart = "index(";
        String keyStart = "key(";
        return !trimmedPath.regionMatches(true, 0, indexStart, 0, indexStart.length()) && !trimmedPath.regionMatches(true, 0, keyStart, 0, keyStart.length());
    }
}

