/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.LeafOngoingFinalSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.ReturningModificationCriteriaBuilderFactory;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.StartOngoingSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEBuilderListenerImpl;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import com.blazebit.persistence.impl.FinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.FullSelectCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.RecursiveCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.ReturningModificationCriteraBuilderFactoryImpl;
import com.blazebit.persistence.impl.StartOngoingSetOperationCTECriteriaBuilderImpl;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CTEManager
extends CTEBuilderListenerImpl {
    private final MainQuery mainQuery;
    private final Map<Class<?>, CTEInfo> ctes;
    private boolean recursive = false;

    CTEManager(MainQuery mainQuery) {
        this.mainQuery = mainQuery;
        this.ctes = new LinkedHashMap();
    }

    void applyFrom(CTEManager cteManager) {
        if (cteManager.recursive) {
            this.recursive = true;
        }
        this.ctes.putAll(cteManager.ctes);
    }

    Collection<CTEInfo> getCtes() {
        return this.ctes.values();
    }

    public CTEInfo getCte(Class<?> cteType) {
        return this.ctes.get(cteType);
    }

    public boolean hasCtes() {
        return this.ctes.size() > 0;
    }

    boolean isRecursive() {
        return this.recursive;
    }

    void buildClause(StringBuilder sb) {
        if (this.ctes.isEmpty()) {
            return;
        }
        sb.append("WITH ");
        if (this.recursive) {
            sb.append("RECURSIVE ");
        }
        boolean first = true;
        for (CTEInfo cte : this.ctes.values()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(cte.name);
            sb.append('(');
            List<String> attributes = cte.attributes;
            sb.append(attributes.get(0));
            for (int i = 1; i < attributes.size(); ++i) {
                sb.append(", ");
                sb.append(attributes.get(i));
            }
            sb.append(')');
            sb.append(" AS(\n");
            sb.append(cte.nonRecursiveCriteriaBuilder.getQueryString());
            if (cte.recursive) {
                sb.append("\nUNION ALL\n");
                sb.append(cte.recursiveCriteriaBuilder.getQueryString());
            }
            sb.append("\n)");
        }
        sb.append("\n");
    }

    <Y> StartOngoingSetOperationCTECriteriaBuilder<Y, LeafOngoingFinalSetOperationCTECriteriaBuilder<Y>> withStartSet(Class<?> cteClass, Y result) {
        String cteName = cteClass.getSimpleName();
        FinalSetOperationCTECriteriaBuilderImpl<Object> parentFinalSetOperationBuilder = new FinalSetOperationCTECriteriaBuilderImpl<Object>(this.mainQuery, cteClass, result, null, false, this, null);
        OngoingFinalSetOperationCTECriteriaBuilderImpl<Object> subFinalSetOperationBuilder = new OngoingFinalSetOperationCTECriteriaBuilderImpl<Object>(this.mainQuery, cteClass, null, null, true, parentFinalSetOperationBuilder.getSubListener(), null);
        this.onBuilderStarted(parentFinalSetOperationBuilder);
        LeafOngoingSetOperationCTECriteriaBuilderImpl<Y> leafCb = new LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, cteName, cteClass, result, (CTEBuilderListener)parentFinalSetOperationBuilder.getSubListener(), parentFinalSetOperationBuilder);
        StartOngoingSetOperationCTECriteriaBuilderImpl<Y, LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>> cb = new StartOngoingSetOperationCTECriteriaBuilderImpl<Y, LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>>(this.mainQuery, cteName, cteClass, result, subFinalSetOperationBuilder.getSubListener(), subFinalSetOperationBuilder, leafCb);
        subFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(cb);
        parentFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(subFinalSetOperationBuilder);
        subFinalSetOperationBuilder.getSubListener().onBuilderStarted(cb);
        parentFinalSetOperationBuilder.getSubListener().onBuilderStarted(leafCb);
        return cb;
    }

    <Y> FullSelectCTECriteriaBuilder<Y> with(Class<?> cteClass, Y result) {
        String cteName = cteClass.getSimpleName();
        FullSelectCTECriteriaBuilderImpl<Y> cteBuilder = new FullSelectCTECriteriaBuilderImpl<Y>(this.mainQuery, cteName, cteClass, result, this);
        this.onBuilderStarted(cteBuilder);
        return cteBuilder;
    }

    <Y> SelectRecursiveCTECriteriaBuilder<Y> withRecursive(Class<?> cteClass, Y result) {
        String cteName = cteClass.getSimpleName();
        this.recursive = true;
        RecursiveCTECriteriaBuilderImpl<Y> cteBuilder = new RecursiveCTECriteriaBuilderImpl<Y>(this.mainQuery, cteName, cteClass, result, this);
        this.onBuilderStarted(cteBuilder);
        return cteBuilder;
    }

    <Y> ReturningModificationCriteriaBuilderFactory<Y> withReturning(Class<?> cteClass, Y result) {
        String cteName = cteClass.getSimpleName();
        ReturningModificationCriteraBuilderFactoryImpl<Y> factory = new ReturningModificationCriteraBuilderFactoryImpl<Y>(this.mainQuery, cteName, cteClass, result, this);
        return factory;
    }

    @Override
    public void onBuilderEnded(CTEInfoBuilder builder) {
        super.onBuilderEnded(builder);
        CTEInfo cteInfo = builder.createCTEInfo();
        this.ctes.put(cteInfo.cteType.getJavaType(), cteInfo);
    }
}

