/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.parser.expression.BaseNode;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import java.util.LinkedHashSet;
import java.util.Set;

class CorrelatedExpressionGatheringVisitor
extends VisitorAdapter {
    private final AliasManager aliasManager;
    private final Set<Expression> expressions = new LinkedHashSet<Expression>();

    public CorrelatedExpressionGatheringVisitor(AliasManager aliasManager) {
        this.aliasManager = aliasManager;
    }

    public Set<Expression> getExpressions() {
        return this.expressions;
    }

    public void visit(PathExpression expression) {
        BaseNode baseNode = expression.getBaseNode();
        if (!(baseNode instanceof JoinNode)) {
            throw new IllegalArgumentException("Unexpected base node type: " + baseNode);
        }
        if (this.aliasManager != ((JoinNode)baseNode).getAliasInfo().getAliasOwner()) {
            this.expressions.add((Expression)expression);
        }
    }

    public void visit(TreatExpression expression) {
        Expression subExpression = expression.getExpression();
        boolean beforeContained = this.expressions.contains(subExpression);
        subExpression.accept((Expression.Visitor)this);
        if (this.expressions.contains(subExpression)) {
            if (!beforeContained) {
                this.expressions.remove(subExpression);
            }
            this.expressions.add((Expression)expression);
        }
    }

    public void visit(SubqueryExpression expression) {
        if (!(expression.getSubquery() instanceof SubqueryInternalBuilder)) {
            throw new IllegalArgumentException("Unexpected subquery subtype: " + expression.getSubquery());
        }
        SubqueryInternalBuilder builder = (SubqueryInternalBuilder)expression.getSubquery();
        this.expressions.addAll(builder.getCorrelatedExpressions());
    }
}

