/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.impl.CriteriaBuilderFactoryImpl;
import com.blazebit.persistence.impl.dialect.DB2DbmsDialect;
import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.dialect.H2DbmsDialect;
import com.blazebit.persistence.impl.dialect.MSSQLDbmsDialect;
import com.blazebit.persistence.impl.dialect.MySQLDbmsDialect;
import com.blazebit.persistence.impl.dialect.OracleDbmsDialect;
import com.blazebit.persistence.impl.dialect.PostgreSQLDbmsDialect;
import com.blazebit.persistence.impl.function.cast.CastFunction;
import com.blazebit.persistence.impl.function.count.CountTupleEmulationFunction;
import com.blazebit.persistence.impl.function.count.CountTupleFunction;
import com.blazebit.persistence.impl.function.count.MySQLCountTupleFunction;
import com.blazebit.persistence.impl.function.datediff.day.AccessDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.DB2DayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.DefaultDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.MySQLDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.OracleDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.PostgreSQLDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.AccessHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.DB2HourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.DefaultHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.MySQLHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.OracleHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.PostgreSQLHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.AccessMillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.DB2MillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.DefaultMillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.MySQLMillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.OracleMillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.PostgreSQLMillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.millisecond.SQLServerMillisecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.AccessMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.DB2MinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.DefaultMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.MySQLMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.OracleMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.PostgreSQLMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.AccessMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.DB2MonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.DefaultMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.MySQLMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.OracleMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.PostgreSQLMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.AccessSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.DB2SecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.DefaultSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.MySQLSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.OracleSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.PostgreSQLSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.SQLServerSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.AccessYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.DB2YearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.DefaultYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.MySQLYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.OracleYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.PostgreSQLYearDiffFunction;
import com.blazebit.persistence.impl.function.datetime.day.AccessDayFunction;
import com.blazebit.persistence.impl.function.datetime.day.DB2DayFunction;
import com.blazebit.persistence.impl.function.datetime.day.DayFunction;
import com.blazebit.persistence.impl.function.datetime.day.DerbyDayFunction;
import com.blazebit.persistence.impl.function.datetime.day.SQLServerDayFunction;
import com.blazebit.persistence.impl.function.datetime.day.SybaseDayFunction;
import com.blazebit.persistence.impl.function.datetime.epoch.DB2EpochFunction;
import com.blazebit.persistence.impl.function.datetime.epoch.DefaultEpochFunction;
import com.blazebit.persistence.impl.function.datetime.epoch.MySQLEpochFunction;
import com.blazebit.persistence.impl.function.datetime.epoch.OracleEpochFunction;
import com.blazebit.persistence.impl.function.datetime.epoch.PostgreSQLEpochFunction;
import com.blazebit.persistence.impl.function.datetime.hour.AccessHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.DB2HourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.DerbyHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.HourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.OracleHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.SQLServerHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.SybaseHourFunction;
import com.blazebit.persistence.impl.function.datetime.minute.AccessMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.DB2MinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.DerbyMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.MinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.OracleMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.SQLServerMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.SybaseMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.month.AccessMonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.DB2MonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.DerbyMonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.MonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.SQLServerMonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.SybaseMonthFunction;
import com.blazebit.persistence.impl.function.datetime.second.AccessSecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.DB2SecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.DerbySecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.OracleSecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.SQLServerSecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.SecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.SybaseSecondFunction;
import com.blazebit.persistence.impl.function.datetime.year.AccessYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.DB2YearFunction;
import com.blazebit.persistence.impl.function.datetime.year.DerbyYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.SQLServerYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.SybaseYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.YearFunction;
import com.blazebit.persistence.impl.function.greatest.DefaultGreatestFunction;
import com.blazebit.persistence.impl.function.greatest.MaxGreatestFunction;
import com.blazebit.persistence.impl.function.greatest.SelectMaxUnionGreatestFunction;
import com.blazebit.persistence.impl.function.groupconcat.DB2GroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.H2GroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.MySQLGroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.OracleListaggGroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.PostgreSQLGroupConcatFunction;
import com.blazebit.persistence.impl.function.least.DefaultLeastFunction;
import com.blazebit.persistence.impl.function.least.MinLeastFunction;
import com.blazebit.persistence.impl.function.least.SelectMinUnionLeastFunction;
import com.blazebit.persistence.impl.function.limit.LimitFunction;
import com.blazebit.persistence.impl.function.pageposition.MySQLPagePositionFunction;
import com.blazebit.persistence.impl.function.pageposition.OraclePagePositionFunction;
import com.blazebit.persistence.impl.function.pageposition.PagePositionFunction;
import com.blazebit.persistence.impl.function.pageposition.TransactSQLPagePositionFunction;
import com.blazebit.persistence.impl.function.repeat.DefaultRepeatFunction;
import com.blazebit.persistence.impl.function.repeat.LpadRepeatFunction;
import com.blazebit.persistence.impl.function.repeat.ReplicateRepeatFunction;
import com.blazebit.persistence.impl.function.rowvalue.DB2RowValueComparisonFunction;
import com.blazebit.persistence.impl.function.rowvalue.RowValueComparisonFunction;
import com.blazebit.persistence.impl.function.set.SetFunction;
import com.blazebit.persistence.impl.function.subquery.SubqueryFunction;
import com.blazebit.persistence.impl.function.treat.TreatFunction;
import com.blazebit.persistence.parser.expression.ConcurrentHashMapExpressionCache;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.EntityManagerFactoryIntegrator;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.spi.PackageOpener;
import com.blazebit.persistence.spi.SetOperationType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.persistence.EntityManagerFactory;

public class CriteriaBuilderConfigurationImpl
implements CriteriaBuilderConfiguration {
    private final Map<String, DbmsDialect> dbmsDialects = new HashMap<String, DbmsDialect>();
    private final Map<String, JpqlFunctionGroup> functions = new HashMap<String, JpqlFunctionGroup>();
    private final Map<String, Class<?>> treatTypes = new HashMap();
    private final Map<String, JpqlMacro> macros = new HashMap<String, JpqlMacro>();
    private final List<EntityManagerFactoryIntegrator> entityManagerIntegrators = new ArrayList<EntityManagerFactoryIntegrator>();
    private PackageOpener packageOpener;
    private Properties properties = new Properties();
    private ExtendedQuerySupport extendedQuerySupport;

    public CriteriaBuilderConfigurationImpl(PackageOpener packageOpener) {
        this.packageOpener = packageOpener;
        this.loadDefaultProperties();
        this.loadExtendedQuerySupport();
        this.loadEntityManagerIntegrator();
        this.loadDbmsDialects();
        this.loadFunctions();
    }

    private void loadFunctions() {
        JpqlFunctionGroup jpqlFunctionGroup = new JpqlFunctionGroup("limit", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new LimitFunction(this.dbmsDialects.get(null)));
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("mysql")));
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("oracle")));
        jpqlFunctionGroup.add("db2", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("db2")));
        jpqlFunctionGroup.add("sybase", null);
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("microsoft")));
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("page_position", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new PagePositionFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLPagePositionFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OraclePagePositionFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new TransactSQLPagePositionFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new TransactSQLPagePositionFunction());
        this.registerFunction(jpqlFunctionGroup);
        for (SetOperationType setType : SetOperationType.values()) {
            jpqlFunctionGroup = new JpqlFunctionGroup("set_" + setType.name().toLowerCase(), false);
            for (Map.Entry<String, DbmsDialect> dbmsDialectEntry : this.dbmsDialects.entrySet()) {
                jpqlFunctionGroup.add(dbmsDialectEntry.getKey(), (JpqlFunction)new SetFunction(setType, dbmsDialectEntry.getValue()));
            }
            this.registerFunction(jpqlFunctionGroup);
        }
        this.registerNamedType("Boolean", Boolean.class);
        this.registerNamedType("Byte", Byte.class);
        this.registerNamedType("Short", Short.class);
        this.registerNamedType("Integer", Integer.class);
        this.registerNamedType("Long", Long.class);
        this.registerNamedType("Float", Float.class);
        this.registerNamedType("Double", Double.class);
        this.registerNamedType("Character", Character.class);
        this.registerNamedType("String", String.class);
        this.registerNamedType("BigInteger", BigInteger.class);
        this.registerNamedType("BigDecimal", BigDecimal.class);
        this.registerNamedType("Time", Time.class);
        this.registerNamedType("Date", Date.class);
        this.registerNamedType("Timestamp", Timestamp.class);
        this.registerNamedType("Calendar", Calendar.class);
        this.registerFunction(new JpqlFunctionGroup("cast_boolean"));
        this.registerFunction(new JpqlFunctionGroup("cast_byte"));
        this.registerFunction(new JpqlFunctionGroup("cast_short"));
        this.registerFunction(new JpqlFunctionGroup("cast_integer"));
        this.registerFunction(new JpqlFunctionGroup("cast_long"));
        this.registerFunction(new JpqlFunctionGroup("cast_float"));
        this.registerFunction(new JpqlFunctionGroup("cast_double"));
        this.registerFunction(new JpqlFunctionGroup("cast_character"));
        this.registerFunction(new JpqlFunctionGroup("cast_string"));
        this.registerFunction(new JpqlFunctionGroup("cast_biginteger"));
        this.registerFunction(new JpqlFunctionGroup("cast_bigdecimal"));
        this.registerFunction(new JpqlFunctionGroup("cast_time"));
        this.registerFunction(new JpqlFunctionGroup("cast_date"));
        this.registerFunction(new JpqlFunctionGroup("cast_timestamp"));
        this.registerFunction(new JpqlFunctionGroup("cast_calendar"));
        for (Map.Entry entry : this.dbmsDialects.entrySet()) {
            this.functions.get("cast_boolean").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Boolean.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_byte").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Byte.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_short").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Short.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_integer").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Integer.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_long").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Long.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_float").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Float.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_double").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Double.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_character").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Character.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_string").add((String)entry.getKey(), (JpqlFunction)new CastFunction(String.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_biginteger").add((String)entry.getKey(), (JpqlFunction)new CastFunction(BigInteger.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_bigdecimal").add((String)entry.getKey(), (JpqlFunction)new CastFunction(BigDecimal.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_time").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Time.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_date").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Date.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_timestamp").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Timestamp.class, (DbmsDialect)entry.getValue()));
            this.functions.get("cast_calendar").add((String)entry.getKey(), (JpqlFunction)new CastFunction(Calendar.class, (DbmsDialect)entry.getValue()));
        }
        jpqlFunctionGroup = new JpqlFunctionGroup("group_concat", true);
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2GroupConcatFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleListaggGroupConcatFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new H2GroupConcatFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLGroupConcatFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLGroupConcatFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("year", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new YearFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessYearFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2YearFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyYearFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerYearFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseYearFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("month", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new MonthFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMonthFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MonthFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyMonthFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerMonthFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseMonthFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("day", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DayFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessDayFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2DayFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyDayFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerDayFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseDayFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("hour", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new HourFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessHourFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2HourFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyHourFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerHourFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseHourFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleHourFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("minute", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new MinuteFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMinuteFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MinuteFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyMinuteFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerMinuteFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseMinuteFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleMinuteFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("second", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new SecondFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessSecondFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2SecondFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbySecondFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerSecondFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseSecondFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleSecondFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("epoch", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DefaultEpochFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLEpochFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleEpochFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2EpochFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLEpochFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("year_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessYearDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2YearDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultYearDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultYearDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLYearDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultYearDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLYearDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleYearDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("month_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMonthDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MonthDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultMonthDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultMonthDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLMonthDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultMonthDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLMonthDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleMonthDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("day_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessDayDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2DayDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultDayDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultDayDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLDayDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultDayDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLDayDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleDayDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("hour_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessHourDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2HourDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultHourDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultHourDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLHourDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultHourDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLHourDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleHourDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("minute_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMinuteDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MinuteDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultMinuteDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultMinuteDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLMinuteDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultMinuteDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLMinuteDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleMinuteDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("second_diff", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DefaultSecondDiffFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessSecondDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2SecondDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerSecondDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLSecondDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLSecondDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleSecondDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("millisecond_diff", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DefaultMillisecondDiffFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMillisecondDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MillisecondDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerMillisecondDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLMillisecondDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLMillisecondDiffFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleMillisecondDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("count_tuple", true);
        jpqlFunctionGroup.add(null, (JpqlFunction)new CountTupleFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLCountTupleFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new CountTupleEmulationFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new CountTupleEmulationFunction("+"));
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new CountTupleEmulationFunction());
        jpqlFunctionGroup.add("hsql", (JpqlFunction)new CountTupleEmulationFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("compare_row_value", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new RowValueComparisonFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2RowValueComparisonFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("greatest", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DefaultGreatestFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new MaxGreatestFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SelectMaxUnionGreatestFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("least", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DefaultLeastFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new MinLeastFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SelectMinUnionLeastFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("repeat", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DefaultRepeatFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new LpadRepeatFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new ReplicateRepeatFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("subquery", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new SubqueryFunction());
        this.registerFunction(jpqlFunctionGroup);
    }

    private void loadDbmsDialects() {
        this.registerDialect(null, new DefaultDbmsDialect());
        this.registerDialect("mysql", new MySQLDbmsDialect());
        this.registerDialect("h2", new H2DbmsDialect());
        this.registerDialect("db2", new DB2DbmsDialect());
        this.registerDialect("postgresql", new PostgreSQLDbmsDialect());
        this.registerDialect("oracle", new OracleDbmsDialect());
        this.registerDialect("microsoft", new MSSQLDbmsDialect());
    }

    private void loadDefaultProperties() {
        this.properties.put("com.blazebit.persistence.compatible_mode", "false");
        this.properties.put("com.blazebit.persistence.returning_clause_case_sensitive", "true");
        this.properties.put("com.blazebit.persistence.expression.cache_class", ConcurrentHashMapExpressionCache.class.getName());
        this.properties.put("com.blazebit.persistence.optimized_keyset_predicate_rendering", "true");
    }

    private void loadExtendedQuerySupport() {
        ServiceLoader<ExtendedQuerySupport> serviceLoader = ServiceLoader.load(ExtendedQuerySupport.class);
        Iterator<ExtendedQuerySupport> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            this.extendedQuerySupport = iterator.next();
        }
    }

    private void loadEntityManagerIntegrator() {
        ServiceLoader<EntityManagerFactoryIntegrator> serviceLoader = ServiceLoader.load(EntityManagerFactoryIntegrator.class);
        Iterator<EntityManagerFactoryIntegrator> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            EntityManagerFactoryIntegrator enricher = iterator.next();
            this.entityManagerIntegrators.add(enricher);
        }
    }

    public CriteriaBuilderConfiguration withPackageOpener(PackageOpener packageOpener) {
        this.packageOpener = packageOpener;
        return this;
    }

    PackageOpener getPackageOpener() {
        return this.packageOpener;
    }

    public CriteriaBuilderConfiguration registerFunction(JpqlFunctionGroup jpqlFunctionGroup) {
        String functionName = jpqlFunctionGroup.getName().toLowerCase();
        this.functions.put(functionName, jpqlFunctionGroup);
        return this;
    }

    public CriteriaBuilderConfiguration registerMacro(String macroName, JpqlMacro jpqlMacro) {
        this.macros.put(macroName.toUpperCase(), jpqlMacro);
        return this;
    }

    public Map<String, JpqlFunctionGroup> getFunctions() {
        return this.functions;
    }

    public JpqlFunctionGroup getFunction(String name) {
        return this.functions.get(name.toLowerCase());
    }

    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    public Map<String, JpqlMacro> getMacros() {
        return this.macros;
    }

    public Set<String> getMacroNames() {
        return this.macros.keySet();
    }

    public CriteriaBuilderConfiguration registerNamedType(String name, Class<?> type) {
        this.treatTypes.put(name, type);
        this.registerFunction(new JpqlFunctionGroup("treat_" + name.toLowerCase(), (JpqlFunction)new TreatFunction(type)));
        return this;
    }

    public Map<String, Class<?>> getNamedTypes() {
        return this.treatTypes;
    }

    public CriteriaBuilderConfiguration registerDialect(String dbms, DbmsDialect dialect) {
        this.dbmsDialects.put(dbms, dialect);
        return this;
    }

    public Map<String, DbmsDialect> getDbmsDialects() {
        return this.dbmsDialects;
    }

    public ExtendedQuerySupport getExtendedQuerySupport() {
        return this.extendedQuerySupport;
    }

    public CriteriaBuilderConfiguration registerEntityManagerIntegrator(EntityManagerFactoryIntegrator entityManagerEnricher) {
        this.entityManagerIntegrators.add(entityManagerEnricher);
        return this;
    }

    public List<EntityManagerFactoryIntegrator> getEntityManagerIntegrators() {
        return this.entityManagerIntegrators;
    }

    public CriteriaBuilderFactory createCriteriaBuilderFactory(EntityManagerFactory emf) {
        return new CriteriaBuilderFactoryImpl(this, emf);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public CriteriaBuilderConfiguration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public CriteriaBuilderConfiguration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public CriteriaBuilderConfiguration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public CriteriaBuilderConfiguration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }
}

