/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.CTE;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpaProviderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.BasicType;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class EntityMetamodelImpl
implements EntityMetamodel {
    private final Metamodel delegate;
    private final JpaProvider jpaProvider;
    private final Map<String, EntityType<?>> entityNameMap;
    private final Map<String, Class<?>> entityTypes;
    private final Map<String, Class<Enum<?>>> enumTypes;
    private final Map<Class<?>, Type<?>> classMap;
    private final ConcurrentMap<Class<?>, Type<?>> basicTypeMap = new ConcurrentHashMap();
    private final Map<Class<?>, ManagedType<?>> cteMap;
    private final Map<Object, ExtendedManagedTypeImpl<?>> extendedManagedTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityMetamodelImpl(EntityManagerFactory emf, JpaProviderFactory jpaProviderFactory) {
        TemporaryExtendedManagedType extendedManagedType;
        HashMap attributeMap;
        Set attributes;
        this.delegate = emf.getMetamodel();
        Set managedTypes = this.delegate.getManagedTypes();
        Set originalEntityTypes = this.delegate.getEntities();
        HashMap<String, EntityType> nameToType = new HashMap<String, EntityType>(managedTypes.size());
        HashMap<String, Class> entityTypes = new HashMap<String, Class>(managedTypes.size());
        HashMap enumTypes = new HashMap(managedTypes.size());
        HashMap classToType = new HashMap(managedTypes.size());
        HashMap<Class, EntityType> cteToType = new HashMap<Class, EntityType>(managedTypes.size());
        try (EntityManager em = emf.createEntityManager();){
            this.jpaProvider = jpaProviderFactory.createJpaProvider(em);
        }
        HashSet seenTypesForEnumResolving = new HashSet();
        HashMap<String, TemporaryExtendedManagedType> temporaryExtendedManagedTypes = new HashMap<String, TemporaryExtendedManagedType>();
        for (EntityType e : originalEntityTypes) {
            nameToType.put(e.getName(), e);
            entityTypes.put(e.getName(), e.getJavaType());
            if (e.getJavaType() != null) {
                classToType.put(e.getJavaType(), (Type<?>)e);
                entityTypes.put(e.getJavaType().getName(), e.getJavaType());
                seenTypesForEnumResolving.add(e.getJavaType());
                if (AnnotationUtils.findAnnotation((Class)e.getJavaType(), CTE.class) != null) {
                    cteToType.put(e.getJavaType(), e);
                }
            }
            attributes = e.getAttributes();
            attributeMap = new HashMap(attributes.size());
            extendedManagedType = new TemporaryExtendedManagedType((ManagedType)e, attributeMap);
            temporaryExtendedManagedTypes.put(e.getName(), extendedManagedType);
            for (Attribute attribute : attributes) {
                List<Attribute<?, ?>> parents = Collections.singletonList(attribute);
                Class fieldType = JpaMetamodelUtils.resolveFieldClass((Class)e.getJavaType(), (Attribute)attribute);
                if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                    EmbeddableType embeddableType = fieldType == Map.class ? (EmbeddableType)((SingularAttribute)attribute).getType() : this.delegate.embeddable(fieldType);
                    this.collectColumnNames(e, attributeMap, attribute.getName(), parents, embeddableType, temporaryExtendedManagedTypes);
                } else if (EntityMetamodelImpl.isAssociation(attribute) && !attribute.isCollection() && !this.jpaProvider.isForeignJoinColumn(e, attribute.getName())) {
                    List identifierOrUniqueKeyEmbeddedPropertyNames = this.jpaProvider.getIdentifierOrUniqueKeyEmbeddedPropertyNames(e, attribute.getName());
                    for (String name : identifierOrUniqueKeyEmbeddedPropertyNames) {
                        EntityType fieldEntityType = this.delegate.entity(fieldType);
                        Attribute idAttribute = JpaMetamodelUtils.getAttribute((ManagedType)fieldEntityType, (String)name);
                        Class idType = JpaMetamodelUtils.resolveFieldClass((Class)fieldType, (Attribute)idAttribute);
                        String idPath = attribute.getName() + "." + name;
                        attributeMap.put(idPath, new AttributeEntry(this.jpaProvider, e, idAttribute, idPath, idType, Arrays.asList(attribute, idAttribute)));
                    }
                }
                attributeMap.put(attribute.getName(), new AttributeEntry(this.jpaProvider, e, attribute, attribute.getName(), fieldType, parents));
                this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, e.getJavaType(), attribute);
            }
        }
        for (Object t : managedTypes) {
            if (t instanceof EntityType) continue;
            attributes = t.getAttributes();
            attributeMap = new HashMap(attributes.size());
            extendedManagedType = new TemporaryExtendedManagedType((ManagedType)t, attributeMap);
            temporaryExtendedManagedTypes.put(t.getJavaType().getName(), extendedManagedType);
            if (t.getJavaType() == null) continue;
            classToType.put(t.getJavaType(), (Type<?>)t);
        }
        HashSet cascadingDeleteCycleSet = new HashSet();
        for (EntityType e : originalEntityTypes) {
            Class targetClass = e.getJavaType();
            TemporaryExtendedManagedType targetManagedType = (TemporaryExtendedManagedType)temporaryExtendedManagedTypes.get(e.getName());
            cascadingDeleteCycleSet.add(targetClass);
            for (Map.Entry entry : targetManagedType.attributes.entrySet()) {
                AttributeEntry attribute = (AttributeEntry)entry.getValue();
                this.detectCascadingDeleteCycles(targetManagedType, temporaryExtendedManagedTypes, cascadingDeleteCycleSet, targetClass, attribute, classToType);
                if (!targetManagedType.done || !targetManagedType.cascadingDeleteCycle) continue;
                entry.setValue(attribute.withCascadingDeleteCycle());
            }
            cascadingDeleteCycleSet.remove(targetClass);
            targetManagedType.done = true;
        }
        HashMap extendedManagedTypes = new HashMap(temporaryExtendedManagedTypes.size());
        for (Map.Entry entry : temporaryExtendedManagedTypes.entrySet()) {
            TemporaryExtendedManagedType value = (TemporaryExtendedManagedType)entry.getValue();
            ExtendedManagedTypeImpl extendedManagedType2 = new ExtendedManagedTypeImpl(value.managedType, value.cascadingDeleteCycle, Collections.unmodifiableMap(value.attributes));
            extendedManagedTypes.put(entry.getKey(), extendedManagedType2);
            if (value.managedType.getJavaType() == null) continue;
            extendedManagedTypes.put(value.managedType.getJavaType(), extendedManagedType2);
        }
        this.entityNameMap = Collections.unmodifiableMap(nameToType);
        this.entityTypes = Collections.unmodifiableMap(entityTypes);
        this.enumTypes = Collections.unmodifiableMap(enumTypes);
        this.classMap = Collections.unmodifiableMap(classToType);
        this.cteMap = Collections.unmodifiableMap(cteToType);
        this.extendedManagedTypes = Collections.unmodifiableMap(extendedManagedTypes);
    }

    private void detectCascadingDeleteCycles(TemporaryExtendedManagedType ownerManagedType, Map<String, TemporaryExtendedManagedType> extendedManagedTypes, Set<Class<?>> cascadingDeleteCycleSet, Class<?> ownerClass, AttributeEntry<?, ?> attributeEntry, Map<Class<?>, Type<?>> classToType) {
        TemporaryExtendedManagedType targetManagedType;
        Class<?> targetClass = attributeEntry.getElementClass();
        Type<?> type = classToType.get(targetClass);
        String targetClassName = null;
        if (type != null) {
            if (type instanceof EntityType) {
                targetClassName = ((EntityType)type).getName();
            } else if (type.getJavaType() != null) {
                targetClassName = type.getJavaType().getName();
            }
        }
        if ((targetManagedType = extendedManagedTypes.get(targetClassName)) != null) {
            if (cascadingDeleteCycleSet.add(targetClass)) {
                if (targetManagedType.done) {
                    if (targetManagedType.cascadingDeleteCycle) {
                        ownerManagedType.done = true;
                        ownerManagedType.cascadingDeleteCycle = true;
                    }
                } else {
                    for (Map.Entry entry : targetManagedType.attributes.entrySet()) {
                        AttributeEntry attribute = (AttributeEntry)entry.getValue();
                        this.detectCascadingDeleteCycles(targetManagedType, extendedManagedTypes, cascadingDeleteCycleSet, targetClass, attribute, classToType);
                        if (!targetManagedType.done || !targetManagedType.cascadingDeleteCycle) continue;
                        entry.setValue(attribute.withCascadingDeleteCycle());
                    }
                    targetManagedType.done = true;
                }
                cascadingDeleteCycleSet.remove(targetClass);
            } else {
                ownerManagedType.done = true;
                ownerManagedType.cascadingDeleteCycle = true;
                targetManagedType.done = true;
                targetManagedType.cascadingDeleteCycle = true;
            }
        }
    }

    private void discoverEnumTypes(Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, ManagedType<?> t) {
        if (!(t instanceof EntityType)) {
            return;
        }
        if (!seenTypesForEnumResolving.add(t.getJavaType())) {
            return;
        }
        for (Attribute attribute : t.getAttributes()) {
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, t.getJavaType(), attribute);
        }
    }

    private void discoverEnumTypes(Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Type<?> type) {
        if (type.getPersistenceType() == Type.PersistenceType.BASIC) {
            Class elementType = type.getJavaType();
            if (elementType.isEnum()) {
                enumTypes.put(elementType.getName(), elementType);
            }
        } else {
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, (ManagedType)type);
        }
    }

    private void discoverEnumTypes(Set<Class<?>> seenTypesForEnumResolving, Map<String, Class<Enum<?>>> enumTypes, Class<?> baseType, Attribute<?, ?> attribute) {
        Class fieldType = JpaMetamodelUtils.resolveFieldClass(baseType, attribute);
        if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC) {
            if (fieldType.isEnum()) {
                enumTypes.put(fieldType.getName(), fieldType);
            }
        } else if (attribute.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attribute;
            if (pluralAttribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                MapAttribute mapAttribute = (MapAttribute)pluralAttribute;
                this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, mapAttribute.getKeyType());
            }
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, pluralAttribute.getElementType());
        } else if (!seenTypesForEnumResolving.contains(fieldType)) {
            this.discoverEnumTypes(seenTypesForEnumResolving, enumTypes, this.delegate.managedType(fieldType));
        }
    }

    private void collectColumnNames(EntityType<?> e, Map<String, AttributeEntry<?, ?>> attributeMap, String parent, List<Attribute<?, ?>> parents, EmbeddableType<?> type, Map<String, TemporaryExtendedManagedType> temporaryExtendedManagedTypes) {
        Set attributes = type.getAttributes();
        TemporaryExtendedManagedType extendedManagedType = temporaryExtendedManagedTypes.get(type.getJavaType().getName());
        if (extendedManagedType == null) {
            extendedManagedType = new TemporaryExtendedManagedType((ManagedType)type, new HashMap());
            temporaryExtendedManagedTypes.put(type.getJavaType().getName(), extendedManagedType);
        }
        for (Attribute attribute : attributes) {
            ArrayList newParents = new ArrayList(parents.size() + 1);
            newParents.addAll(parents);
            newParents.add(attribute);
            String attributeName = parent + "." + attribute.getName();
            Class fieldType = JpaMetamodelUtils.resolveFieldClass((Class)type.getJavaType(), (Attribute)attribute);
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                this.collectColumnNames(e, attributeMap, attributeName, newParents, this.delegate.embeddable(fieldType), temporaryExtendedManagedTypes);
            } else if (EntityMetamodelImpl.isAssociation(attribute) && !attribute.isCollection() && !this.jpaProvider.isForeignJoinColumn(e, attributeName)) {
                List identifierOrUniqueKeyEmbeddedPropertyNames = this.jpaProvider.getIdentifierOrUniqueKeyEmbeddedPropertyNames(e, attributeName);
                for (String name : identifierOrUniqueKeyEmbeddedPropertyNames) {
                    EntityType fieldEntityType = this.delegate.entity(fieldType);
                    Attribute idAttribute = JpaMetamodelUtils.getAttribute((ManagedType)fieldEntityType, (String)name);
                    Class idType = JpaMetamodelUtils.resolveFieldClass((Class)fieldType, (Attribute)idAttribute);
                    String idPath = attributeName + "." + name;
                    ArrayList idParents = new ArrayList(newParents.size() + 1);
                    idParents.addAll(newParents);
                    idParents.add(idAttribute);
                    attributeMap.put(idPath, new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, idAttribute, idPath, idType, idParents));
                }
            }
            AttributeEntry attributeEntry = new AttributeEntry(this.jpaProvider, (ManagedType<?>)e, attribute, attributeName, fieldType, newParents);
            attributeMap.put(attributeName, attributeEntry);
            extendedManagedType.attributes.put(attribute.getName(), attributeEntry);
        }
    }

    private static boolean isAssociation(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public JpaProvider getJpaProvider() {
        return this.jpaProvider;
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        return this.delegate.entity(cls);
    }

    public EntityType<?> entity(String name) {
        EntityType<?> type = this.entityNameMap.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Invalid entity type: " + name);
        }
        return type;
    }

    public EntityType<?> getEntity(String name) {
        return this.entityNameMap.get(name);
    }

    public ManagedType<?> getManagedType(String name) {
        return (ManagedType)this.entityNameMap.get(name);
    }

    public Map<String, Class<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public Map<String, Class<Enum<?>>> getEnumTypes() {
        return this.enumTypes;
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        return this.delegate.managedType(cls);
    }

    public <X> Type<X> type(Class<X> cls) {
        Object type = this.classMap.get(cls);
        if (type != null) {
            return type;
        }
        type = new BasicTypeImpl<X>(cls);
        Type<?> oldType = this.basicTypeMap.putIfAbsent(cls, (Type<?>)type);
        if (oldType != null) {
            type = oldType;
        }
        return type;
    }

    public ManagedType<?> managedType(String name) {
        ManagedType t = (ManagedType)this.entityNameMap.get(name);
        if (t == null) {
            throw new IllegalStateException("Managed type with name '" + name + "' does not exist!");
        }
        return t;
    }

    public <X> ManagedType<X> getManagedType(Class<X> cls) {
        return (ManagedType)this.classMap.get(cls);
    }

    public <X> EntityType<X> getEntity(Class<X> cls) {
        Type<?> type = this.classMap.get(cls);
        if (type == null || !(type instanceof EntityType)) {
            return null;
        }
        return (EntityType)type;
    }

    public <X> ManagedType<X> getCte(Class<X> cls) {
        return this.cteMap.get(cls);
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        return this.delegate.embeddable(cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return this.delegate.getManagedTypes();
    }

    public Set<EntityType<?>> getEntities() {
        return this.delegate.getEntities();
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.delegate.getEmbeddables();
    }

    public <T> T getManagedType(Class<T> cls, Class<?> managedType) {
        ExtendedManagedType<?> extendedManagedType = this.getEntry(managedType);
        if (cls == ExtendedManagedType.class) {
            return (T)extendedManagedType;
        }
        return null;
    }

    public <T> T getManagedType(Class<T> cls, String managedTypeName) {
        ExtendedManagedType<?> extendedManagedType = this.getEntry(managedTypeName);
        if (cls == ExtendedManagedType.class) {
            return (T)extendedManagedType;
        }
        return null;
    }

    private ExtendedManagedType<?> getEntry(Class<?> ownerType) {
        ExtendedManagedType extendedManagedType = this.extendedManagedTypes.get(ownerType);
        if (extendedManagedType == null) {
            throw new IllegalArgumentException("Unknown managed type '" + ownerType.getName() + "'");
        }
        return extendedManagedType;
    }

    private ExtendedManagedType<?> getEntry(String managedTypeName) {
        ExtendedManagedType extendedManagedType = this.extendedManagedTypes.get(managedTypeName);
        if (extendedManagedType == null) {
            throw new IllegalArgumentException("Unknown managed type '" + managedTypeName + "'");
        }
        return extendedManagedType;
    }

    private static class BasicTypeImpl<T>
    implements BasicType<T> {
        private final Class<T> cls;

        public BasicTypeImpl(Class<T> cls) {
            this.cls = cls;
        }

        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.BASIC;
        }

        public Class<T> getJavaType() {
            return this.cls;
        }
    }

    private static final class AttributeEntry<X, Y>
    implements ExtendedAttribute<X, Y> {
        private static final Map<String, String> NO_MAPPINGS = new HashMap<String, String>();
        private final JpaProvider jpaProvider;
        private final ManagedType<?> ownerType;
        private final Attribute<X, Y> attribute;
        private final List<Attribute<?, ?>> attributePath;
        private final Class<Y> elementClass;
        private final boolean hasCascadeDeleteCycle;
        private final boolean isForeignJoinColumn;
        private final boolean isColumnShared;
        private final boolean isBag;
        private final boolean isOrphanRemoval;
        private final boolean isDeleteCascaded;
        private final JpaProvider.ConstraintType[] joinTypeIndexedRequiresTreatFilter;
        private final String mappedBy;
        private final JoinTable joinTable;
        private final String[] columnNames;
        private final String[] columnTypes;
        private final ConcurrentMap<EntityType<?>, Map<String, String>> inverseAttributeCache = new ConcurrentHashMap();

        public AttributeEntry(JpaProvider jpaProvider, ManagedType<X> ownerType, Attribute<X, Y> attribute, String attributeName, Class<Y> fieldType, List<Attribute<?, ?>> parents) {
            this.jpaProvider = jpaProvider;
            this.ownerType = ownerType;
            this.attribute = attribute;
            this.attributePath = Collections.unmodifiableList(parents);
            this.elementClass = fieldType;
            this.isOrphanRemoval = jpaProvider.isOrphanRemoval(ownerType, attributeName);
            this.isDeleteCascaded = jpaProvider.isDeleteCascaded(ownerType, attributeName);
            this.hasCascadeDeleteCycle = false;
            JoinType[] joinTypes = JoinType.values();
            JpaProvider.ConstraintType[] requiresTreatFilter = new JpaProvider.ConstraintType[joinTypes.length];
            if (ownerType instanceof EntityType) {
                EntityType entityType = (EntityType)ownerType;
                this.isForeignJoinColumn = jpaProvider.isForeignJoinColumn(entityType, attributeName);
                this.isColumnShared = jpaProvider.isColumnShared(entityType, attributeName);
                this.isBag = jpaProvider.isBag(entityType, attributeName);
                this.mappedBy = jpaProvider.getMappedBy(entityType, attributeName);
                this.joinTable = jpaProvider.getJoinTable(entityType, attributeName);
                this.columnNames = jpaProvider.getColumnNames(entityType, attributeName);
                this.columnTypes = jpaProvider.getColumnTypes(entityType, attributeName);
                for (JoinType joinType : joinTypes) {
                    requiresTreatFilter[joinType.ordinal()] = jpaProvider.requiresTreatFilter(entityType, attributeName, joinType);
                }
            } else {
                this.isForeignJoinColumn = false;
                this.isColumnShared = false;
                this.isBag = false;
                this.mappedBy = null;
                this.joinTable = null;
                this.columnNames = null;
                this.columnTypes = null;
            }
            this.joinTypeIndexedRequiresTreatFilter = requiresTreatFilter;
        }

        private AttributeEntry(AttributeEntry<X, Y> original, boolean hasCascadeDeleteCycle) {
            this.jpaProvider = original.jpaProvider;
            this.ownerType = original.ownerType;
            this.attribute = original.attribute;
            this.attributePath = original.attributePath;
            this.elementClass = original.elementClass;
            this.hasCascadeDeleteCycle = hasCascadeDeleteCycle;
            this.isForeignJoinColumn = original.isForeignJoinColumn;
            this.isColumnShared = original.isColumnShared;
            this.isBag = original.isBag;
            this.isOrphanRemoval = original.isOrphanRemoval;
            this.isDeleteCascaded = original.isDeleteCascaded;
            this.joinTypeIndexedRequiresTreatFilter = original.joinTypeIndexedRequiresTreatFilter;
            this.mappedBy = original.mappedBy;
            this.joinTable = original.joinTable;
            this.columnNames = original.columnNames;
            this.columnTypes = original.columnTypes;
        }

        public Map<String, String> getWritableMappedByMappings(EntityType<?> inverseType) {
            Map mappings = (Map)this.inverseAttributeCache.get(inverseType);
            if (mappings == null) {
                mappings = this.jpaProvider.getWritableMappedByMappings(inverseType, (EntityType)this.ownerType, this.attribute.getName());
                if (mappings == null) {
                    this.inverseAttributeCache.putIfAbsent(inverseType, NO_MAPPINGS);
                } else {
                    mappings = Collections.unmodifiableMap(mappings);
                    this.inverseAttributeCache.putIfAbsent(inverseType, mappings);
                }
            } else if (mappings == NO_MAPPINGS) {
                return null;
            }
            return mappings;
        }

        public Attribute<X, Y> getAttribute() {
            return this.attribute;
        }

        public List<Attribute<?, ?>> getAttributePath() {
            return this.attributePath;
        }

        public Class<Y> getElementClass() {
            return this.elementClass;
        }

        public boolean hasCascadingDeleteCycle() {
            return this.hasCascadeDeleteCycle;
        }

        public boolean isForeignJoinColumn() {
            return this.isForeignJoinColumn;
        }

        public boolean isColumnShared() {
            return this.isColumnShared;
        }

        public boolean isBag() {
            return this.isBag;
        }

        public boolean isOrphanRemoval() {
            return this.isOrphanRemoval;
        }

        public boolean isDeleteCascaded() {
            return this.isDeleteCascaded;
        }

        public JpaProvider.ConstraintType getJoinTypeIndexedRequiresTreatFilter(JoinType joinType) {
            return this.joinTypeIndexedRequiresTreatFilter[joinType.ordinal()];
        }

        public String getMappedBy() {
            return this.mappedBy;
        }

        public JoinTable getJoinTable() {
            return this.joinTable;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public String[] getColumnTypes() {
            return this.columnTypes;
        }

        public AttributeEntry<X, Y> withCascadingDeleteCycle() {
            if (this.hasCascadeDeleteCycle) {
                return this;
            }
            return new AttributeEntry<X, Y>(this, true);
        }
    }

    private static final class ExtendedManagedTypeImpl<X>
    implements ExtendedManagedType<X> {
        private final ManagedType<X> managedType;
        private final boolean hasCascadingDeleteCycle;
        private final SingularAttribute<X, ?> idAttribute;
        private final Map<String, AttributeEntry<?, ?>> attributes;

        private ExtendedManagedTypeImpl(ManagedType<X> managedType, boolean hasCascadingDeleteCycle, Map<String, AttributeEntry<?, ?>> attributes) {
            this.managedType = managedType;
            this.idAttribute = managedType instanceof EntityType ? JpaMetamodelUtils.getIdAttribute((IdentifiableType)((IdentifiableType)managedType)) : null;
            this.hasCascadingDeleteCycle = hasCascadingDeleteCycle;
            this.attributes = attributes;
        }

        public ManagedType<X> getType() {
            return this.managedType;
        }

        public boolean hasCascadingDeleteCycle() {
            return this.hasCascadingDeleteCycle;
        }

        public SingularAttribute<X, ?> getIdAttribute() {
            return this.idAttribute;
        }

        public Map<String, ExtendedAttribute<X, ?>> getAttributes() {
            return this.attributes;
        }

        public ExtendedAttribute<X, ?> getAttribute(String attributeName) {
            AttributeEntry<?, ?> entry = this.attributes.get(attributeName);
            if (entry == null) {
                throw new IllegalArgumentException("Could not find attribute '" + attributeName + "' on managed type '" + this.managedType.getJavaType().getName() + "'");
            }
            return entry;
        }
    }

    private static final class TemporaryExtendedManagedType {
        private final ManagedType<?> managedType;
        private final Map<String, AttributeEntry<?, ?>> attributes;
        private boolean done;
        private boolean cascadingDeleteCycle;

        private TemporaryExtendedManagedType(ManagedType<?> managedType, Map<String, AttributeEntry<?, ?>> attributes) {
            this.managedType = managedType;
            this.attributes = attributes;
        }
    }
}

