/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.FetchType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;

public class EntitySelectResolveVisitor
extends VisitorAdapter {
    private final EntityMetamodel m;
    private final Set<PathExpression> pathExpressions;

    public EntitySelectResolveVisitor(EntityMetamodel m, Set<PathExpression> pathExpressions) {
        this.m = m;
        this.pathExpressions = pathExpressions;
    }

    public void visit(FunctionExpression expression) {
    }

    public void visit(PathExpression expression) {
        if (expression.getField() == null) {
            JoinNode baseNode = (JoinNode)expression.getBaseNode();
            EntityType entityType = this.m.getEntity(baseNode.getJavaType());
            if (entityType == null) {
                return;
            }
            Class entityClass = entityType.getJavaType();
            TreeSet sortedAttributes = new TreeSet(new Comparator<Attribute<?, ?>>(){

                @Override
                public int compare(Attribute<?, ?> o1, Attribute<?, ?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            sortedAttributes.addAll(entityType.getAttributes());
            for (Attribute attr : sortedAttributes) {
                boolean resolve = false;
                if (ExpressionUtils.isAssociation(attr) && !attr.isCollection()) {
                    resolve = true;
                } else if (ExpressionUtils.getFetchType(attr) == FetchType.EAGER) {
                    if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                        throw new UnsupportedOperationException("Eager element collections are not supported");
                    }
                    resolve = true;
                }
                if (!resolve) continue;
                PathExpression attrPath = new PathExpression(new ArrayList(expression.getExpressions()));
                attrPath.setPathReference((PathReference)new SimplePathReference(baseNode, attr.getName(), this.m.type(JpaMetamodelUtils.resolveFieldClass((Class)entityClass, (Attribute)attr))));
                this.pathExpressions.add(attrPath);
            }
        }
    }

    public void visit(ListIndexExpression expression) {
    }

    public void visit(MapEntryExpression expression) {
    }

    public void visit(MapKeyExpression expression) {
    }

    public void visit(MapValueExpression expression) {
    }
}

