/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.parser.AliasReplacementVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.AbortableVisitorAdapter;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TemporalLiteral;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;

public class ExpressionUtils {
    private static final AbortableVisitorAdapter SUBQUERY_EXPRESSION_DETECTOR = new AbortableVisitorAdapter(){

        public Boolean visit(SubqueryExpression expression) {
            return true;
        }
    };
    private static final AbortableVisitorAdapter SIZE_EXPRESSION_DETECTOR = new AbortableVisitorAdapter(){

        public Boolean visit(FunctionExpression expression) {
            if (com.blazebit.persistence.parser.util.ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
                return true;
            }
            return super.visit(expression);
        }
    };

    private ExpressionUtils() {
    }

    public static boolean isUnique(EntityMetamodel metamodel, Expression expr) {
        if (expr instanceof FunctionExpression) {
            return ExpressionUtils.isUnique(metamodel, (FunctionExpression)expr);
        }
        if (expr instanceof PathExpression) {
            return ExpressionUtils.isUnique(metamodel, (PathExpression)expr);
        }
        if (expr instanceof SubqueryExpression) {
            return false;
        }
        if (expr instanceof ParameterExpression) {
            return false;
        }
        if (expr instanceof GeneralCaseExpression) {
            return ExpressionUtils.isUnique(metamodel, (GeneralCaseExpression)expr);
        }
        if (expr instanceof ListIndexExpression) {
            return false;
        }
        if (expr instanceof MapKeyExpression) {
            return false;
        }
        if (expr instanceof MapEntryExpression) {
            return false;
        }
        if (expr instanceof MapValueExpression) {
            return false;
        }
        if (expr instanceof EntityLiteral) {
            return false;
        }
        if (expr instanceof EnumLiteral) {
            return false;
        }
        if (expr instanceof NumericLiteral) {
            return false;
        }
        if (expr instanceof BooleanLiteral) {
            return false;
        }
        if (expr instanceof StringLiteral) {
            return false;
        }
        if (expr instanceof TemporalLiteral) {
            return false;
        }
        if (expr instanceof ArithmeticFactor) {
            return ExpressionUtils.isUnique(metamodel, ((ArithmeticFactor)expr).getExpression());
        }
        if (expr instanceof ArithmeticExpression) {
            return false;
        }
        if (expr instanceof NullExpression) {
            return true;
        }
        throw new IllegalArgumentException("The expression of type '" + expr.getClass().getName() + "' can not be analyzed for uniqueness!");
    }

    private static boolean isUnique(EntityMetamodel metamodel, FunctionExpression expr) {
        return false;
    }

    private static boolean isUnique(EntityMetamodel metamodel, GeneralCaseExpression expr) {
        if (expr.getDefaultExpr() != null && !ExpressionUtils.isUnique(metamodel, expr.getDefaultExpr())) {
            return false;
        }
        List expressions = expr.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (ExpressionUtils.isUnique(metamodel, ((WhenClauseExpression)expressions.get(i)).getResult())) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnique(EntityMetamodel metamodel, PathExpression expr) {
        Attribute<?, ?> attr;
        JoinNode baseNode = (JoinNode)expr.getBaseNode();
        if (expr.getField() != null && !ExpressionUtils.isUnique(attr = JpaUtils.getAttributeForJoining(metamodel, expr).getAttribute())) {
            return false;
        }
        while (baseNode.getParent() != null) {
            if (baseNode.getParentTreeNode() == null) {
                return false;
            }
            attr = baseNode.getParentTreeNode().getAttribute();
            if (!ExpressionUtils.isUnique(attr)) {
                return false;
            }
            baseNode = baseNode.getParent();
        }
        return true;
    }

    private static boolean isUnique(Attribute<?, ?> attr) {
        if (attr.isCollection()) {
            return false;
        }
        return ((SingularAttribute)attr).isId();
    }

    public static String unwrapStringLiteral(String stringLiteral) {
        if (stringLiteral.length() >= 2 && stringLiteral.startsWith("'") && stringLiteral.endsWith("'")) {
            return stringLiteral.substring(1, stringLiteral.length() - 1);
        }
        return stringLiteral;
    }

    public static boolean isFunctionFunctionExpression(FunctionExpression func) {
        return "FUNCTION".equalsIgnoreCase(func.getFunctionName());
    }

    public static boolean isNullable(EntityMetamodel metamodel, Expression expr) {
        if (expr instanceof FunctionExpression) {
            return ExpressionUtils.isNullable(metamodel, (FunctionExpression)expr);
        }
        if (expr instanceof PathExpression) {
            return ExpressionUtils.isNullable(metamodel, (PathExpression)expr);
        }
        if (expr instanceof SubqueryExpression) {
            return true;
        }
        if (expr instanceof ParameterExpression) {
            return true;
        }
        if (expr instanceof GeneralCaseExpression) {
            return ExpressionUtils.isNullable(metamodel, (GeneralCaseExpression)expr);
        }
        if (expr instanceof ListIndexExpression) {
            return false;
        }
        if (expr instanceof MapKeyExpression) {
            return false;
        }
        if (expr instanceof MapEntryExpression) {
            return false;
        }
        if (expr instanceof MapValueExpression) {
            return false;
        }
        if (expr instanceof EntityLiteral) {
            return false;
        }
        if (expr instanceof EnumLiteral) {
            return false;
        }
        if (expr instanceof NullExpression) {
            return true;
        }
        if (expr instanceof NumericLiteral) {
            return false;
        }
        if (expr instanceof BooleanLiteral) {
            return false;
        }
        if (expr instanceof StringLiteral) {
            return false;
        }
        if (expr instanceof TemporalLiteral) {
            return false;
        }
        if (expr instanceof ArithmeticFactor) {
            return ExpressionUtils.isNullable(metamodel, ((ArithmeticFactor)expr).getExpression());
        }
        if (expr instanceof ArithmeticExpression) {
            return ExpressionUtils.isNullable(metamodel, (ArithmeticExpression)expr);
        }
        throw new IllegalArgumentException("The expression of type '" + expr.getClass().getName() + "' can not be analyzed for nullability!");
    }

    private static boolean isNullable(EntityMetamodel metamodel, ArithmeticExpression arithmeticExpression) {
        return ExpressionUtils.isNullable(metamodel, arithmeticExpression.getLeft()) || ExpressionUtils.isNullable(metamodel, arithmeticExpression.getRight());
    }

    private static boolean isNullable(EntityMetamodel metamodel, GeneralCaseExpression expr) {
        if (expr.getDefaultExpr() != null && ExpressionUtils.isNullable(metamodel, expr.getDefaultExpr())) {
            return true;
        }
        List expressions = expr.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!ExpressionUtils.isNullable(metamodel, ((WhenClauseExpression)expressions.get(i)).getResult())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(EntityMetamodel metamodel, FunctionExpression expr) {
        if ("NULLIF".equalsIgnoreCase(expr.getFunctionName())) {
            return true;
        }
        if ("COALESCE".equalsIgnoreCase(expr.getFunctionName())) {
            List expressions = expr.getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                boolean nullable = ExpressionUtils.isNullable(metamodel, (Expression)expressions.get(i));
                if (nullable) continue;
                return false;
            }
            return true;
        }
        List expressions = expr.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            boolean nullable = ExpressionUtils.isNullable(metamodel, (Expression)expressions.get(i));
            if (!nullable) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(EntityMetamodel metamodel, PathExpression expr) {
        Attribute<?, ?> attr;
        JoinNode baseNode = (JoinNode)expr.getBaseNode();
        if (expr.getField() != null && ExpressionUtils.isNullable(attr = JpaUtils.getAttributeForJoining(metamodel, expr).getAttribute())) {
            return true;
        }
        while (baseNode.getParent() != null) {
            if (baseNode.getParentTreeNode() == null) {
                if (baseNode.getParent().getJoinType() != JoinType.LEFT) {
                    attr = JpaUtils.getAttributeForJoining(metamodel, expr).getAttribute();
                    return ExpressionUtils.isNullable(attr);
                }
                return false;
            }
            attr = baseNode.getParentTreeNode().getAttribute();
            if (ExpressionUtils.isNullable(attr)) {
                return true;
            }
            baseNode = baseNode.getParent();
        }
        return false;
    }

    private static boolean isNullable(Attribute<?, ?> attr) {
        if (attr.isCollection()) {
            return true;
        }
        return ((SingularAttribute)attr).isOptional() && !((SingularAttribute)attr).isId();
    }

    public static FetchType getFetchType(Attribute<?, ?> attr) {
        Class<Basic> annotationType;
        HashSet annotations;
        Member m = attr.getJavaMember();
        if (m instanceof Method) {
            annotations = AnnotationUtils.getAllAnnotations((Method)((Method)m));
        } else if (m instanceof Field) {
            annotations = new HashSet();
            Collections.addAll(annotations, ((Field)m).getAnnotations());
        } else {
            throw new IllegalStateException("Attribute member [" + attr.getName() + "] is neither field nor method");
        }
        switch (attr.getPersistentAttributeType()) {
            case BASIC: {
                annotationType = Basic.class;
                break;
            }
            case ELEMENT_COLLECTION: {
                annotationType = ElementCollection.class;
                break;
            }
            case EMBEDDED: {
                return FetchType.EAGER;
            }
            case MANY_TO_MANY: {
                annotationType = ManyToMany.class;
                break;
            }
            case MANY_TO_ONE: {
                annotationType = ManyToOne.class;
                break;
            }
            case ONE_TO_MANY: {
                annotationType = OneToMany.class;
                break;
            }
            case ONE_TO_ONE: {
                annotationType = OneToOne.class;
                break;
            }
            default: {
                return FetchType.EAGER;
            }
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(annotationType)) continue;
            try {
                return (FetchType)annotation.annotationType().getMethod("fetch", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return FetchType.EAGER;
    }

    public static boolean isAssociation(Attribute<?, ?> attr) {
        return attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public static boolean containsSubqueryExpression(Expression e) {
        return (Boolean)e.accept((Expression.ResultVisitor)SUBQUERY_EXPRESSION_DETECTOR);
    }

    public static boolean containsSizeExpression(Expression e) {
        return (Boolean)e.accept((Expression.ResultVisitor)SIZE_EXPRESSION_DETECTOR);
    }

    public static Expression replaceSubexpression(Expression superExpression, String placeholder, Expression substitute) {
        return (Expression)superExpression.accept((Expression.ResultVisitor)new AliasReplacementVisitor(substitute, placeholder));
    }
}

