/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.NodeInfo;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GroupByManager
extends AbstractManager<ExpressionModifier> {
    private final List<NodeInfo> groupByInfos = new ArrayList<NodeInfo>();

    GroupByManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
    }

    void applyFrom(GroupByManager groupByManager) {
        for (NodeInfo info : groupByManager.groupByInfos) {
            this.groupBy(this.subqueryInitFactory.reattachSubqueries(info.getExpression().clone(true)));
        }
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.GROUP_BY;
    }

    public void groupBy(Expression expr) {
        this.groupByInfos.add(new NodeInfo(expr));
        this.registerParameterExpressions(expr);
    }

    boolean existsGroupBy(Expression expr) {
        return this.groupByInfos.contains(new NodeInfo(expr));
    }

    void buildGroupByClauses(Set<String> clauses) {
        if (this.groupByInfos.isEmpty()) {
            return;
        }
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        StringBuilder sb = new StringBuilder();
        this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
        this.queryGenerator.setQueryBuffer(sb);
        for (NodeInfo info : this.groupByInfos) {
            sb.setLength(0);
            this.queryGenerator.generate(info.getExpression());
            clauses.add(sb.toString());
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
    }

    void buildGroupBy(StringBuilder sb, Set<String> clauses) {
        if (!clauses.isEmpty()) {
            sb.append(" GROUP BY ");
            this.build(sb, clauses);
        }
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        List<NodeInfo> infos = this.groupByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            NodeInfo groupBy = infos.get(i);
            visitor.visit(groupBy, ClauseType.GROUP_BY);
        }
    }

    void acceptVisitor(Expression.Visitor v) {
        for (NodeInfo groupBy : this.groupByInfos) {
            groupBy.getExpression().accept(v);
        }
    }

    public boolean hasGroupBys() {
        return this.groupByInfos.size() > 0;
    }

    boolean isEmpty() {
        return this.groupByInfos.isEmpty();
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.groupByInfos != null ? this.groupByInfos.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupByManager other = (GroupByManager)obj;
        return this.groupByInfos == other.groupByInfos || this.groupByInfos != null && this.groupByInfos.equals(other.groupByInfos);
    }
}

