/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractQueryConfiguration;
import com.blazebit.persistence.impl.util.PropertyUtils;
import java.util.HashMap;
import java.util.Map;

public class ImmutableQueryConfiguration
extends AbstractQueryConfiguration {
    private final boolean compatibleModeEnabled;
    private final boolean expressionOptimizationEnabled;
    private final String expressionCacheClass;
    private final boolean returningClauseCaseSensitive;
    private final boolean sizeToCountTransformationEnabled;
    private final boolean implicitGroupByFromSelectEnabled;
    private final boolean implicitGroupByFromHavingEnabled;
    private final boolean implicitGroupByFromOrderByEnabled;
    private final boolean valuesClauseFilterNullsEnabled;
    private final boolean parameterAsLiteralRenderingEnabled;
    private final boolean optimizedKeysetPredicateRenderingEnabled;

    public ImmutableQueryConfiguration(Map<String, String> properties) {
        this.compatibleModeEnabled = PropertyUtils.getAsBooleanProperty(properties, "com.blazebit.persistence.compatible_mode", false);
        this.expressionOptimizationEnabled = PropertyUtils.getAsBooleanProperty(properties, "com.blazebit.persistence.expression_optimization", true);
        this.expressionCacheClass = properties.get("com.blazebit.persistence.expression.cache_class");
        this.returningClauseCaseSensitive = this.getBooleanProperty(properties, "com.blazebit.persistence.returning_clause_case_sensitive", "false");
        this.sizeToCountTransformationEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.size_to_count_transformation", "true");
        this.implicitGroupByFromSelectEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.implicit_group_by_from_select", "true");
        this.implicitGroupByFromHavingEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.implicit_group_by_from_having", "true");
        this.implicitGroupByFromOrderByEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.implicit_group_by_from_order_by", "true");
        this.valuesClauseFilterNullsEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.values.filter_nulls", "true");
        this.parameterAsLiteralRenderingEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.parameter_literal_rendering", "true");
        this.optimizedKeysetPredicateRenderingEnabled = this.getBooleanProperty(properties, "com.blazebit.persistence.optimized_keyset_predicate_rendering", "true");
    }

    @Override
    public boolean isCompatibleModeEnabled() {
        return this.compatibleModeEnabled;
    }

    @Override
    public boolean isReturningClauseCaseSensitive() {
        return this.returningClauseCaseSensitive;
    }

    @Override
    public boolean isExpressionOptimizationEnabled() {
        return this.expressionOptimizationEnabled;
    }

    @Override
    public String getExpressionCacheClass() {
        return this.expressionCacheClass;
    }

    @Override
    public boolean isCountTransformationEnabled() {
        return this.sizeToCountTransformationEnabled;
    }

    @Override
    public boolean isImplicitGroupByFromSelectEnabled() {
        return this.implicitGroupByFromSelectEnabled;
    }

    @Override
    public boolean isImplicitGroupByFromHavingEnabled() {
        return this.implicitGroupByFromHavingEnabled;
    }

    @Override
    public boolean isImplicitGroupByFromOrderByEnabled() {
        return this.implicitGroupByFromOrderByEnabled;
    }

    @Override
    public boolean isValuesClauseFilterNullsEnabled() {
        return this.valuesClauseFilterNullsEnabled;
    }

    @Override
    public boolean isParameterAsLiteralRenderingEnabled() {
        return this.parameterAsLiteralRenderingEnabled;
    }

    @Override
    public boolean isOptimizedKeysetPredicateRenderingEnabled() {
        return this.optimizedKeysetPredicateRenderingEnabled;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        throw new UnsupportedOperationException("Can't set cacheable on immutable query configuration!");
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public String getProperty(String name) {
        switch (name) {
            case "com.blazebit.persistence.compatible_mode": {
                return Boolean.toString(this.compatibleModeEnabled);
            }
            case "com.blazebit.persistence.returning_clause_case_sensitive": {
                return Boolean.toString(this.returningClauseCaseSensitive);
            }
            case "com.blazebit.persistence.size_to_count_transformation": {
                return Boolean.toString(this.sizeToCountTransformationEnabled);
            }
            case "com.blazebit.persistence.implicit_group_by_from_select": {
                return Boolean.toString(this.implicitGroupByFromSelectEnabled);
            }
            case "com.blazebit.persistence.implicit_group_by_from_having": {
                return Boolean.toString(this.implicitGroupByFromHavingEnabled);
            }
            case "com.blazebit.persistence.implicit_group_by_from_order_by": {
                return Boolean.toString(this.implicitGroupByFromOrderByEnabled);
            }
            case "com.blazebit.persistence.expression_optimization": {
                return Boolean.toString(this.expressionOptimizationEnabled);
            }
            case "com.blazebit.persistence.expression.cache_class": {
                return this.expressionCacheClass;
            }
            case "com.blazebit.persistence.values.filter_nulls": {
                return Boolean.toString(this.valuesClauseFilterNullsEnabled);
            }
            case "com.blazebit.persistence.parameter_literal_rendering": {
                return Boolean.toString(this.parameterAsLiteralRenderingEnabled);
            }
            case "com.blazebit.persistence.optimized_keyset_predicate_rendering": {
                return Boolean.toString(this.optimizedKeysetPredicateRenderingEnabled);
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(20);
        properties.put("com.blazebit.persistence.compatible_mode", Boolean.toString(this.compatibleModeEnabled));
        properties.put("com.blazebit.persistence.returning_clause_case_sensitive", Boolean.toString(this.returningClauseCaseSensitive));
        properties.put("com.blazebit.persistence.size_to_count_transformation", Boolean.toString(this.sizeToCountTransformationEnabled));
        properties.put("com.blazebit.persistence.implicit_group_by_from_select", Boolean.toString(this.implicitGroupByFromSelectEnabled));
        properties.put("com.blazebit.persistence.implicit_group_by_from_having", Boolean.toString(this.implicitGroupByFromHavingEnabled));
        properties.put("com.blazebit.persistence.implicit_group_by_from_order_by", Boolean.toString(this.implicitGroupByFromOrderByEnabled));
        properties.put("com.blazebit.persistence.expression_optimization", Boolean.toString(this.expressionOptimizationEnabled));
        properties.put("com.blazebit.persistence.expression.cache_class", this.expressionCacheClass);
        properties.put("com.blazebit.persistence.values.filter_nulls", Boolean.toString(this.valuesClauseFilterNullsEnabled));
        properties.put("com.blazebit.persistence.parameter_literal_rendering", Boolean.toString(this.parameterAsLiteralRenderingEnabled));
        properties.put("com.blazebit.persistence.optimized_keyset_predicate_rendering", Boolean.toString(this.optimizedKeysetPredicateRenderingEnabled));
        return properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        throw new IllegalArgumentException("Can't set a property on factory level!");
    }

    private boolean getBooleanProperty(Map<String, String> properties, String propertyName, String defaultValue) {
        return Boolean.parseBoolean(this.getProperty(properties, propertyName, defaultValue));
    }

    private String getProperty(Map<String, String> properties, String propertyName, String defaultValue) {
        String value = properties.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

