/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.lang.StringUtils;
import com.blazebit.lang.ValueRetriever;
import com.blazebit.persistence.From;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.Path;
import com.blazebit.persistence.impl.AbortableOnClauseJoinNodeVisitor;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AttributeHolder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.ExternalAliasDereferencingException;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.impl.builder.predicate.JoinOnBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.ListIndexAttribute;
import com.blazebit.persistence.parser.MapEntryAttribute;
import com.blazebit.persistence.parser.MapKeyAttribute;
import com.blazebit.persistence.parser.QualifiedAttribute;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.QualifiedExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.ValuesStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class JoinManager
extends AbstractManager<ExpressionModifier> {
    private static final Logger LOG = Logger.getLogger(JoinManager.class.getName());
    private final List<JoinNode> rootNodes = new ArrayList<JoinNode>(1);
    private final Set<JoinNode> entityFunctionNodes = new LinkedHashSet<JoinNode>();
    private final String joinRestrictionKeyword;
    private final MainQuery mainQuery;
    private final AliasManager aliasManager;
    private final EntityMetamodelImpl metamodel;
    private final JoinManager parent;
    private final JoinOnBuilderEndedListener joinOnBuilderListener;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final Set<JoinNode> collectionJoinNodes = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<JoinNode> renderedJoins = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<JoinNode> markedJoinNodes = Collections.newSetFromMap(new IdentityHashMap());
    private boolean emulateJoins;

    JoinManager(MainQuery mainQuery, ResolvingQueryGenerator queryGenerator, AliasManager aliasManager, JoinManager parent, ExpressionFactory expressionFactory) {
        super(queryGenerator, mainQuery.parameterManager, null);
        this.mainQuery = mainQuery;
        this.aliasManager = aliasManager;
        this.metamodel = mainQuery.metamodel;
        this.parent = parent;
        this.joinRestrictionKeyword = " " + mainQuery.jpaProvider.getOnClause() + " ";
        this.joinOnBuilderListener = new JoinOnBuilderEndedListener();
        this.subqueryInitFactory = new SubqueryInitiatorFactory(mainQuery, aliasManager, this);
        this.expressionFactory = expressionFactory;
    }

    void applyFrom(JoinManager joinManager) {
        for (JoinNode node : joinManager.rootNodes) {
            JoinNode rootNode = this.applyFrom(node);
            if (node.getValueQuery() == null) continue;
            ParameterManager.ParameterImpl<?> param = joinManager.parameterManager.getParameter(node.getAlias());
            ValuesParameterBinder binder = ((ParameterManager.ValuesParameterWrapper)param.getParameterValue()).getBinder();
            this.parameterManager.registerValuesParameter(rootNode.getAlias(), null, binder.getParameterNames(), binder.getPathExpressions());
            this.entityFunctionNodes.add(rootNode);
        }
    }

    private JoinNode applyFrom(JoinNode node) {
        String rootAlias = node.getAlias();
        boolean implicit = node.getAliasInfo().isImplicit();
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, implicit, true, this.aliasManager);
        if (node.getCorrelationParent() != null) {
            throw new UnsupportedOperationException("Cloning subqueries not yet implemented!");
        }
        JoinNode rootNode = node.cloneRootNode(rootAliasInfo);
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        for (JoinTreeNode treeNode : node.getNodes().values()) {
            this.applyFrom(rootNode, treeNode);
        }
        if (!node.getTreatedJoinNodes().isEmpty()) {
            throw new UnsupportedOperationException("Cloning joins with treat joins is not yet implemented!");
        }
        return rootNode;
    }

    private void applyFrom(JoinNode parent, JoinTreeNode treeNode) {
        JoinTreeNode newTreeNode = parent.getOrCreateTreeNode(treeNode.getRelationName(), treeNode.getAttribute());
        for (Map.Entry nodeEntry : treeNode.getJoinNodes().entrySet()) {
            JoinNode newNode = this.applyFrom(parent, newTreeNode, (String)nodeEntry.getKey(), (JoinNode)nodeEntry.getValue());
            newTreeNode.addJoinNode(newNode, nodeEntry.getValue() == treeNode.getDefaultNode());
        }
    }

    private JoinNode applyFrom(JoinNode parent, JoinTreeNode treeNode, String alias, JoinNode oldNode) {
        boolean implicit = oldNode.getAliasInfo().isImplicit();
        String currentJoinPath = parent.getAliasInfo().getAbsolutePath() + "." + treeNode.getRelationName();
        JoinAliasInfo newAliasInfo = new JoinAliasInfo(alias, currentJoinPath, implicit, false, this.aliasManager);
        this.aliasManager.registerAliasInfo(newAliasInfo);
        JoinNode node = oldNode.cloneJoinNode(parent, treeNode, newAliasInfo);
        newAliasInfo.setJoinNode(node);
        if (oldNode.getOnPredicate() != null) {
            node.setOnPredicate(this.subqueryInitFactory.reattachSubqueries(oldNode.getOnPredicate().clone(true)));
        }
        for (JoinTreeNode oldTreeNode : oldNode.getNodes().values()) {
            this.applyFrom(node, oldTreeNode);
        }
        if (!oldNode.getTreatedJoinNodes().isEmpty()) {
            throw new UnsupportedOperationException("Cloning joins with treat joins is not yet implemented!");
        }
        return node;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.JOIN;
    }

    Set<JoinNode> getKeyRestrictedLeftJoins() {
        if (!this.mainQuery.jpaProvider.needsJoinSubqueryRewrite()) {
            return Collections.emptySet();
        }
        HashSet<JoinNode> keyRestrictedLeftJoins = new HashSet<JoinNode>();
        this.acceptVisitor(new KeyRestrictedLeftJoinCollectingVisitor(this.mainQuery.jpaProvider, keyRestrictedLeftJoins));
        return keyRestrictedLeftJoins;
    }

    String addRootValues(Class<?> clazz, Class<?> valueClazz, String rootAlias, int valueCount, String typeName, String castedParameter, boolean identifiableReference) {
        Set<Object> attributeSet;
        if (rootAlias == null) {
            throw new IllegalArgumentException("Illegal empty alias for the VALUES clause: " + clazz.getName());
        }
        ValuesStrategy strategy = this.mainQuery.dbmsDialect.getValuesStrategy();
        String dummyTable = this.mainQuery.dbmsDialect.getDummyTable();
        ManagedType<?> managedType = this.mainQuery.metamodel.getManagedType(clazz);
        String idAttributeName = null;
        if (identifiableReference) {
            SingularAttribute idAttribute = JpaMetamodelUtils.getIdAttribute((IdentifiableType)((EntityType)managedType));
            idAttributeName = idAttribute.getName();
            attributeSet = Collections.singleton(idAttribute);
        } else {
            Set originalAttributeSet = managedType.getAttributes();
            attributeSet = new LinkedHashSet(originalAttributeSet.size());
            for (Attribute attr : originalAttributeSet) {
                if (attr.isCollection()) continue;
                attributeSet.add(attr);
            }
        }
        String[][] parameterNames = new String[valueCount][attributeSet.size()];
        ValueRetriever[] pathExpressions = new ValueRetriever[attributeSet.size()];
        StringBuilder valuesSb = new StringBuilder(20 + valueCount * attributeSet.size() * 3);
        Query valuesExampleQuery = this.getValuesExampleQuery(clazz, identifiableReference, rootAlias, typeName, castedParameter, attributeSet, parameterNames, pathExpressions, valuesSb, strategy, dummyTable);
        this.parameterManager.registerValuesParameter(rootAlias, valueClazz, parameterNames, pathExpressions);
        String exampleQuerySql = this.mainQuery.cbf.getExtendedQuerySupport().getSql(this.mainQuery.em, valuesExampleQuery);
        String exampleQuerySqlAlias = this.mainQuery.cbf.getExtendedQuerySupport().getSqlAlias(this.mainQuery.em, valuesExampleQuery, "e");
        StringBuilder whereClauseSb = new StringBuilder(exampleQuerySql.length());
        String filterNullsTableAlias = "fltr_nulls_tbl_als_";
        String valuesAliases = this.getValuesAliases(exampleQuerySqlAlias, attributeSet.size(), exampleQuerySql, whereClauseSb, filterNullsTableAlias, strategy, dummyTable);
        if (strategy == ValuesStrategy.SELECT_VALUES) {
            valuesSb.insert(0, valuesAliases);
            valuesSb.append(')');
            valuesAliases = null;
        } else if (strategy == ValuesStrategy.SELECT_UNION) {
            valuesSb.insert(0, valuesAliases);
            this.mainQuery.dbmsDialect.appendExtendedSql(valuesSb, DbmsStatementType.SELECT, true, true, null, Integer.toString(valueCount + 1), "1", null, null);
            valuesSb.append(')');
            valuesAliases = null;
        }
        boolean filterNulls = this.mainQuery.getQueryConfiguration().isValuesClauseFilterNullsEnabled();
        if (filterNulls) {
            valuesSb.insert(0, "(select * from ");
            valuesSb.append(' ');
            valuesSb.append(filterNullsTableAlias);
            if (valuesAliases != null) {
                valuesSb.append(valuesAliases);
                valuesAliases = null;
            }
            valuesSb.append((CharSequence)whereClauseSb);
            valuesSb.append(')');
        }
        String valuesClause = valuesSb.toString();
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, true, true, this.aliasManager);
        JoinNode rootNode = JoinNode.createValuesRootNode(managedType, typeName, valueCount, idAttributeName, valuesExampleQuery, valuesClause, valuesAliases, rootAliasInfo);
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        this.entityFunctionNodes.add(rootNode);
        return rootAlias;
    }

    private String getValuesAliases(String tableAlias, int attributeCount, String exampleQuerySql, StringBuilder whereClauseSb, String filterNullsTableAlias, ValuesStrategy strategy, String dummyTable) {
        StringBuilder sb;
        int startIndex = SqlUtils.indexOfSelect(exampleQuerySql);
        int endIndex = exampleQuerySql.indexOf(" from ");
        if (strategy == ValuesStrategy.VALUES) {
            sb = new StringBuilder(endIndex - startIndex - (tableAlias.length() + 3) * attributeCount);
            sb.append('(');
        } else if (strategy == ValuesStrategy.SELECT_VALUES) {
            sb = new StringBuilder(endIndex - startIndex);
            sb.append("(select ");
        } else if (strategy == ValuesStrategy.SELECT_UNION) {
            sb = new StringBuilder(endIndex - startIndex - (tableAlias.length() + 3) * attributeCount);
            sb.append("(select ");
        } else {
            throw new IllegalArgumentException("Unsupported values strategy: " + strategy);
        }
        whereClauseSb.append(" where");
        String[] columnNames = SqlUtils.getSelectItemColumns(exampleQuerySql, startIndex);
        for (int i = 0; i < columnNames.length; ++i) {
            whereClauseSb.append(' ');
            if (i > 0) {
                whereClauseSb.append("or ");
            }
            whereClauseSb.append(filterNullsTableAlias);
            whereClauseSb.append('.');
            whereClauseSb.append(columnNames[i]);
            whereClauseSb.append(" is not null");
            if (strategy == ValuesStrategy.SELECT_VALUES) {
                sb.append('c');
                sb.append(i + 1);
                sb.append(' ');
            } else if (strategy == ValuesStrategy.SELECT_UNION) {
                sb.append("null as ");
            }
            sb.append(columnNames[i]);
            sb.append(',');
        }
        if (strategy == ValuesStrategy.VALUES) {
            sb.setCharAt(sb.length() - 1, ')');
        } else if (strategy == ValuesStrategy.SELECT_VALUES) {
            sb.setCharAt(sb.length() - 1, ' ');
            sb.append(" from ");
        } else if (strategy == ValuesStrategy.SELECT_UNION) {
            sb.setCharAt(sb.length() - 1, ' ');
            if (dummyTable != null) {
                sb.append(" from ");
                sb.append(dummyTable);
            }
        }
        return sb.toString();
    }

    private static String getCastedParameters(StringBuilder sb, DbmsDialect dbmsDialect, String[] types) {
        sb.setLength(0);
        if (dbmsDialect.needsCastParameters()) {
            for (int i = 0; i < types.length; ++i) {
                sb.append(dbmsDialect.cast("?", types[i]));
                sb.append(',');
            }
        } else {
            for (int i = 0; i < types.length; ++i) {
                sb.append("?,");
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Query getValuesExampleQuery(Class<?> clazz, boolean identifiableReference, String prefix, String typeName, String castedParameter, Set<Attribute<?, ?>> attributeSet, String[][] parameterNames, ValueRetriever<?, ?>[] pathExpressions, StringBuilder valuesSb, ValuesStrategy strategy, String dummyTable) {
        int valueCount = parameterNames.length;
        String[] attributes = new String[attributeSet.size()];
        String[] attributeParameter = new String[attributeSet.size()];
        StringBuilder sb = new StringBuilder(50 + valueCount * prefix.length() * attributeSet.size() * 50);
        sb.append("SELECT ");
        if (clazz == ValuesEntity.class) {
            sb.append("e.");
            attributes[0] = attributeSet.iterator().next().getName();
            attributeParameter[0] = this.mainQuery.dbmsDialect.needsCastParameters() ? castedParameter : "?";
            pathExpressions[0] = new SimpleValueRetriever();
            sb.append(attributes[0]);
            sb.append(',');
        } else if (identifiableReference) {
            sb.append("e.");
            Attribute<?, ?> attribute = attributeSet.iterator().next();
            attributes[0] = attribute.getName();
            String[] columnTypes = this.metamodel.getManagedType(ExtendedManagedType.class, clazz).getAttribute(attribute.getName()).getColumnTypes();
            attributeParameter[0] = JoinManager.getCastedParameters(new StringBuilder(), this.mainQuery.dbmsDialect, columnTypes);
            pathExpressions[0] = com.blazebit.reflection.ExpressionUtils.getExpression(clazz, (String)attributes[0]);
            sb.append(attributes[0]);
            sb.append(',');
        } else {
            Iterator<Attribute<?, ?>> iter = attributeSet.iterator();
            Map mapping = this.metamodel.getManagedType(ExtendedManagedType.class, clazz).getAttributes();
            StringBuilder paramBuilder = new StringBuilder();
            for (int i = 0; i < attributes.length; ++i) {
                sb.append("e.");
                Attribute<?, ?> attribute = iter.next();
                attributes[i] = attribute.getName();
                ExtendedAttribute entry = (ExtendedAttribute)mapping.get(attribute.getName());
                String[] columnTypes = entry.getColumnTypes();
                attributeParameter[i] = JoinManager.getCastedParameters(paramBuilder, this.mainQuery.dbmsDialect, columnTypes);
                pathExpressions[i] = com.blazebit.reflection.ExpressionUtils.getExpression(clazz, (String)attributes[i]);
                sb.append(attributes[i]);
                if (attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC && attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.EMBEDDED) {
                    ManagedType managedAttributeType = this.metamodel.managedType(entry.getElementClass());
                    SingularAttribute attributeTypeIdAttribute = JpaMetamodelUtils.getIdAttribute((IdentifiableType)((IdentifiableType)managedAttributeType));
                    sb.append('.');
                    sb.append(attributeTypeIdAttribute.getName());
                }
                sb.append(',');
            }
        }
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append("FROM ");
        sb.append(clazz.getName());
        sb.append(" e WHERE 1=1");
        if (strategy == ValuesStrategy.SELECT_VALUES || strategy == ValuesStrategy.VALUES) {
            valuesSb.append("(VALUES ");
        } else if (strategy != ValuesStrategy.SELECT_UNION) {
            throw new IllegalArgumentException("Unsupported values strategy: " + strategy);
        }
        for (int i = 0; i < valueCount; ++i) {
            if (strategy == ValuesStrategy.SELECT_UNION) {
                valuesSb.append(" union all select ");
            } else {
                valuesSb.append('(');
            }
            for (int j = 0; j < attributes.length; ++j) {
                String paramName;
                sb.append(" OR ");
                if (typeName != null) {
                    sb.append("TREAT_");
                    sb.append(typeName.toUpperCase());
                    sb.append('(');
                    sb.append("e.");
                    sb.append(attributes[j]);
                    sb.append(')');
                } else {
                    sb.append("e.");
                    sb.append(attributes[j]);
                }
                sb.append(" = ");
                sb.append(':');
                int start = sb.length();
                sb.append(prefix);
                sb.append('_');
                sb.append(attributes[j]);
                sb.append('_').append(i);
                parameterNames[i][j] = paramName = sb.substring(start, sb.length());
                valuesSb.append(attributeParameter[j]);
                valuesSb.append(',');
            }
            if (strategy == ValuesStrategy.SELECT_UNION) {
                valuesSb.setCharAt(valuesSb.length() - 1, ' ');
                if (dummyTable == null) continue;
                valuesSb.append("from ");
                valuesSb.append(dummyTable);
                valuesSb.append(' ');
                continue;
            }
            valuesSb.setCharAt(valuesSb.length() - 1, ')');
            valuesSb.append(',');
        }
        if (strategy == ValuesStrategy.SELECT_UNION) {
            valuesSb.setCharAt(valuesSb.length() - 1, ' ');
        } else {
            valuesSb.setCharAt(valuesSb.length() - 1, ')');
        }
        String exampleQueryString = sb.toString();
        Query q = this.mainQuery.em.createQuery(exampleQueryString);
        return q;
    }

    String addRoot(EntityType<?> entityType, String rootAlias) {
        if (rootAlias == null) {
            String entityTypeName = entityType.getName();
            int dotIdx = entityTypeName.lastIndexOf(46);
            if (dotIdx != -1) {
                entityTypeName = entityTypeName.substring(dotIdx + 1);
            }
            StringBuilder sb = new StringBuilder(entityTypeName);
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String alias = sb.toString();
            rootAlias = this.aliasManager.getAliasInfo(alias) == null ? alias : this.aliasManager.generateRootAlias(alias);
        }
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, true, true, this.aliasManager);
        JoinNode rootNode = JoinNode.createRootNode(entityType, rootAliasInfo);
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        return rootAlias;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String addRoot(String correlationPath, String rootAlias) {
        PathElementExpression correlatedAttributeExpr;
        String correlatedAttribute;
        JoinResult result;
        PathElementExpression elementExpr;
        Expression expr = this.expressionFactory.createJoinPathExpression(correlationPath);
        EntityType<?> treatEntityType = null;
        JoinNode correlationParent = null;
        if (expr instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expr;
            if (this.isJoinableSelectAlias(pathExpression, false, false)) {
                throw new IllegalArgumentException("No select alias allowed in join path");
            }
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            if (pathElements.size() > 1) {
                result = this.implicitJoin(null, pathExpression, null, null, 0, pathElements.size() - 1, true);
                correlationParent = result.baseNode;
            } else {
                result = new JoinResult(null, null, null);
            }
        } else if (expr instanceof TreatExpression) {
            TreatExpression treatExpression = (TreatExpression)expr;
            Expression expression = treatExpression.getExpression();
            if (!(expression instanceof PathExpression)) throw new IllegalArgumentException("Unexpected expression type[" + expression.getClass().getSimpleName() + "] in treat expression: " + treatExpression);
            PathExpression pathExpression = (PathExpression)expression;
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(null, pathExpression, null, null, 0, pathElements.size() - 1, true);
            correlationParent = result.baseNode;
            treatEntityType = this.metamodel.entity(treatExpression.getType());
        } else {
            if (!(expr instanceof FunctionExpression) || !ExpressionUtils.isOuterFunction((FunctionExpression)((FunctionExpression)expr))) throw new IllegalArgumentException("Correlation join path [" + correlationPath + "] is not a valid join path");
            FunctionExpression outerFunctionExpr = (FunctionExpression)expr;
            PathExpression pathExpression = (PathExpression)outerFunctionExpr.getExpressions().get(0);
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(this.parent.getRootNodeOrFail("Can't use OUTER when parent query has multiple roots!"), pathExpression, null, null, 0, pathElements.size() - 1, true);
            correlationParent = result.baseNode;
        }
        if (elementExpr instanceof ArrayExpression) {
            throw new IllegalArgumentException("Array expressions are not allowed!");
        }
        if (correlationParent == null) {
            correlationParent = this.getRootNodeOrFail("Could not join correlation path [", correlationPath, "] because it did not use an absolute path but multiple root nodes are available!");
        }
        if (correlationParent.getAliasInfo().getAliasOwner() == this.aliasManager) {
            throw new IllegalArgumentException("The correlation path '" + correlationPath + "' does not seem to be part of a parent query!");
        }
        if (result.hasField()) {
            correlatedAttribute = result.joinFields(elementExpr.toString());
            correlatedAttributeExpr = this.expressionFactory.createSimpleExpression(correlatedAttribute, false);
        } else {
            correlatedAttribute = elementExpr.toString();
            correlatedAttributeExpr = elementExpr;
        }
        AttributeHolder joinResult = JpaUtils.getAttributeForJoining(this.metamodel, correlationParent.getNodeType(), (Expression)correlatedAttributeExpr, null);
        Type<?> type = joinResult.getAttributeType();
        if (rootAlias == null) {
            StringBuilder sb = new StringBuilder(JpaMetamodelUtils.getSimpleTypeName(type));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String alias = sb.toString();
            rootAlias = this.aliasManager.getAliasInfo(alias) == null ? alias : this.aliasManager.generateRootAlias(alias);
        }
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, true, true, this.aliasManager);
        JoinNode rootNode = JoinNode.createCorrelationRootNode(correlationParent, correlatedAttribute, type, treatEntityType, rootAliasInfo);
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        return rootAlias;
    }

    void removeRoot() {
        JoinNode rootNode = this.rootNodes.remove(0);
        this.aliasManager.unregisterAliasInfoForBottomLevel(rootNode.getAliasInfo());
    }

    JoinNode getRootNodeOrFail(String string) {
        return this.getRootNodeOrFail(string, "", "");
    }

    JoinNode getRootNodeOrFail(String prefix, Object middle, String suffix) {
        if (this.rootNodes.size() > 1) {
            throw new IllegalArgumentException(prefix + middle + suffix);
        }
        return this.rootNodes.get(0);
    }

    JoinNode getRootNode(Expression expression) {
        if (!(expression instanceof PropertyExpression)) {
            return null;
        }
        String alias = expression.toString();
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode node = nodes.get(i);
            if (!alias.equals(node.getAliasInfo().getAlias())) continue;
            return node;
        }
        return null;
    }

    public List<JoinNode> getRoots() {
        return this.rootNodes;
    }

    boolean hasCollections() {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (!nodes.get(i).hasCollections()) continue;
            return true;
        }
        return false;
    }

    boolean hasNonEmulatableJoins() {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode n = nodes.get(i);
            if (!n.getNodes().isEmpty()) {
                return true;
            }
            for (JoinNode joinNode : n.getEntityJoinNodes()) {
                if (joinNode.getJoinType() == JoinType.INNER) continue;
                return true;
            }
            if (n.getTreatedJoinNodes().isEmpty()) continue;
            for (JoinNode treatedNode : n.getTreatedJoinNodes().values()) {
                if (treatedNode.getNodes().isEmpty() && treatedNode.getEntityJoinNodes().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasEntityFunctions() {
        return this.entityFunctionNodes.size() > 0;
    }

    public Set<JoinNode> getCollectionJoins() {
        if (this.rootNodes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set<JoinNode> collectionJoins = this.rootNodes.get(0).getCollectionJoins();
        for (int i = 1; i < this.rootNodes.size(); ++i) {
            collectionJoins.addAll(this.rootNodes.get(i).getCollectionJoins());
        }
        return collectionJoins;
    }

    Set<JoinNode> getEntityFunctionNodes() {
        return this.entityFunctionNodes;
    }

    public JoinManager getParent() {
        return this.parent;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public SubqueryInitiatorFactory getSubqueryInitFactory() {
        return this.subqueryInitFactory;
    }

    Set<JoinNode> buildClause(StringBuilder sb, Set<ClauseType> clauseExclusions, String aliasPrefix, boolean collectCollectionJoinNodes, boolean externalRepresenation, List<String> whereConjuncts, Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities, Set<JoinNode> nodesToFetch) {
        boolean renderFetches = !clauseExclusions.contains((Object)ClauseType.SELECT);
        StringBuilder tempSb = null;
        this.collectionJoinNodes.clear();
        this.renderedJoins.clear();
        sb.append(" FROM ");
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            JoinNode rootNode = nodes.get(i);
            JoinNode correlationParent = rootNode.getCorrelationParent();
            if (externalRepresenation && rootNode.getValueCount() > 0) {
                ManagedType<?> type = rootNode.getManagedType();
                if (type.getJavaType() == ValuesEntity.class) {
                    sb.append(rootNode.getValuesTypeName());
                } else if (type instanceof EntityType) {
                    sb.append(((EntityType)type).getName());
                    if (rootNode.getValuesIdName() != null) {
                        sb.append('.').append(rootNode.getValuesIdName());
                    }
                } else {
                    sb.append(rootNode.getValuesTypeName());
                }
                sb.append("(");
                sb.append(rootNode.getValueCount());
                sb.append(" VALUES)");
            } else if (externalRepresenation && explicitVersionEntities.get(rootNode.getJavaType()) != null) {
                DbmsModificationState state = explicitVersionEntities.get(rootNode.getJavaType()).get(rootNode.getAlias());
                EntityType<?> type = rootNode.getEntityType();
                if (state == DbmsModificationState.NEW) {
                    sb.append("NEW(");
                } else {
                    sb.append("OLD(");
                }
                sb.append(type.getName());
                sb.append(')');
            } else if (correlationParent != null) {
                this.renderCorrelationJoinPath(sb, correlationParent.getAliasInfo(), rootNode);
            } else {
                EntityType<?> type = rootNode.getEntityType();
                sb.append(type.getName());
            }
            sb.append(' ');
            if (aliasPrefix != null) {
                sb.append(aliasPrefix);
            }
            sb.append(rootNode.getAliasInfo().getAlias());
            this.renderedJoins.add(rootNode);
            rootNode.registerDependencies();
            this.applyJoins(sb, rootNode.getAliasInfo(), rootNode.getNodes(), clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
            for (JoinNode treatedNode : rootNode.getTreatedJoinNodes().values()) {
                this.applyJoins(sb, treatedNode.getAliasInfo(), treatedNode.getNodes(), clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
            }
            if (rootNode.getEntityJoinNodes().isEmpty()) continue;
            boolean isCollection = true;
            if (this.mainQuery.jpaProvider.supportsEntityJoin() && !this.emulateJoins) {
                this.applyJoins(sb, rootNode.getAliasInfo(), new ArrayList<JoinNode>(rootNode.getEntityJoinNodes()), isCollection, clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
                continue;
            }
            Set<JoinNode> entityNodes = rootNode.getEntityJoinNodes();
            for (JoinNode entityNode : entityNodes) {
                if (entityNode.getJoinType() != JoinType.INNER) {
                    throw new IllegalArgumentException("Can't emulate outer join for entity join node: " + entityNode);
                }
                if (collectCollectionJoinNodes && isCollection) {
                    this.collectionJoinNodes.add(entityNode);
                }
                sb.append(", ");
                EntityType<?> type = entityNode.getEntityType();
                sb.append(type.getName());
                sb.append(' ');
                if (aliasPrefix != null) {
                    sb.append(aliasPrefix);
                }
                sb.append(entityNode.getAliasInfo().getAlias());
                entityNode.registerDependencies();
                if (entityNode.getOnPredicate() != null && !entityNode.getOnPredicate().getChildren().isEmpty()) {
                    if (tempSb == null) {
                        tempSb = new StringBuilder();
                    } else {
                        tempSb.setLength(0);
                    }
                    this.queryGenerator.setClauseType(ClauseType.JOIN);
                    this.queryGenerator.setQueryBuffer(tempSb);
                    SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
                    this.queryGenerator.generate((Expression)entityNode.getOnPredicate());
                    this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
                    this.queryGenerator.setClauseType(null);
                    whereConjuncts.add(tempSb.toString());
                }
                this.renderedJoins.add(entityNode);
                this.applyJoins(sb, entityNode.getAliasInfo(), entityNode.getNodes(), clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
                for (JoinNode treatedNode : entityNode.getTreatedJoinNodes().values()) {
                    this.applyJoins(sb, treatedNode.getAliasInfo(), treatedNode.getNodes(), clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
                }
            }
        }
        return this.collectionJoinNodes;
    }

    void verifyBuilderEnded() {
        this.joinOnBuilderListener.verifyBuilderEnded();
    }

    void acceptVisitor(JoinNodeVisitor v) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            nodes.get(i).accept(v);
        }
    }

    void setEmulateJoins(boolean emulateJoins) {
        this.emulateJoins = emulateJoins;
    }

    public boolean acceptVisitor(Expression.ResultVisitor<Boolean> aggregateDetector, boolean stopValue) {
        Boolean stop = stopValue;
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (!stop.equals(nodes.get(i).accept(new AbortableOnClauseJoinNodeVisitor(aggregateDetector, stopValue)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            nodes.get(i).accept(visitor);
        }
    }

    private void renderJoinNode(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node, String aliasPrefix, boolean renderFetches, Set<JoinNode> nodesToFetch, List<String> whereConjuncts) {
        if (!this.renderedJoins.contains(node)) {
            boolean fetch;
            boolean bl = fetch = nodesToFetch.contains(node) && renderFetches;
            if (node.isQualifiedJoin() && !fetch) {
                this.renderedJoins.add(node);
                return;
            }
            if (node.isTreatedJoinNode()) {
                this.renderedJoins.add(node);
                return;
            }
            switch (node.getJoinType()) {
                case INNER: {
                    sb.append(" JOIN ");
                    break;
                }
                case LEFT: {
                    sb.append(" LEFT JOIN ");
                    break;
                }
                case RIGHT: {
                    sb.append(" RIGHT JOIN ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown join type: " + node.getJoinType());
                }
            }
            if (fetch) {
                sb.append("FETCH ");
            }
            if (aliasPrefix != null) {
                sb.append(aliasPrefix);
            }
            String onCondition = this.renderJoinPath(sb, joinBase, node, whereConjuncts);
            sb.append(' ');
            if (aliasPrefix != null) {
                sb.append(aliasPrefix);
            }
            sb.append(node.getAliasInfo().getAlias());
            this.renderedJoins.add(node);
            if (node.getOnPredicate() != null && !node.getOnPredicate().getChildren().isEmpty()) {
                sb.append(this.joinRestrictionKeyword);
                sb.append('(');
                if (onCondition != null) {
                    sb.append(onCondition).append(" AND ");
                }
                this.queryGenerator.setClauseType(ClauseType.JOIN);
                this.queryGenerator.setQueryBuffer(sb);
                SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
                this.queryGenerator.setRenderedJoinNodes(this.renderedJoins);
                this.queryGenerator.generate((Expression)node.getOnPredicate());
                this.queryGenerator.setRenderedJoinNodes(null);
                this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
                this.queryGenerator.setClauseType(null);
                sb.append(')');
            } else if (onCondition != null) {
                sb.append(this.joinRestrictionKeyword);
                sb.append('(');
                sb.append(onCondition);
                sb.append(')');
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderCorrelationJoinPath(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node) {
        if (node.getTreatType() != null) {
            boolean renderTreat;
            boolean bl = renderTreat = this.mainQuery.jpaProvider.supportsTreatJoin() && (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving() || node.getJoinType() == JoinType.INNER);
            if (renderTreat) {
                sb.append("TREAT(");
                this.renderAlias(sb, joinBase.getJoinNode(), this.mainQuery.jpaProvider.supportsRootTreat());
                sb.append('.');
                sb.append(node.getCorrelationPath());
                sb.append(" AS ");
                sb.append(node.getTreatType().getName());
                sb.append(')');
                return;
            } else {
                if (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
                sb.append(joinBase.getAlias()).append('.').append(node.getCorrelationPath());
            }
            return;
        } else {
            JoinNode baseNode = joinBase.getJoinNode();
            if (baseNode.getTreatType() != null) {
                if (this.mainQuery.jpaProvider.supportsRootTreatJoin()) {
                    baseNode.appendAlias(sb, true);
                } else {
                    if (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
                    baseNode.appendAlias(sb, false);
                }
            } else {
                baseNode.appendAlias(sb, false);
            }
            sb.append('.').append(node.getCorrelationPath());
        }
    }

    private String renderJoinPath(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node, List<String> whereConjuncts) {
        if (node.getTreatType() != null) {
            String onCondition;
            boolean renderTreat = this.mainQuery.jpaProvider.supportsTreatJoin() && (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving() || node.getJoinType() == JoinType.INNER);
            JoinNode baseNode = joinBase.getJoinNode();
            String treatType = node.getTreatType().getName();
            String relationName = node.getParentTreeNode().getRelationName();
            JpaProvider.ConstraintType constraintType = this.mainQuery.jpaProvider.requiresTreatFilter(baseNode.getEntityType(), relationName, node.getJoinType());
            if (constraintType != JpaProvider.ConstraintType.NONE) {
                String constraint = "TYPE(" + node.getAlias() + ") = " + treatType;
                if (constraintType == JpaProvider.ConstraintType.WHERE) {
                    whereConjuncts.add(constraint);
                    onCondition = null;
                } else {
                    onCondition = constraint;
                }
            } else {
                onCondition = null;
            }
            if (renderTreat) {
                sb.append("TREAT(");
                this.renderAlias(sb, baseNode, this.mainQuery.jpaProvider.supportsRootTreatTreatJoin());
                sb.append('.');
                sb.append(relationName);
                sb.append(" AS ");
                sb.append(treatType);
                sb.append(')');
            } else if (this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) {
                sb.append(joinBase.getAlias()).append('.').append(node.getParentTreeNode().getRelationName());
            } else {
                throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
            }
            return onCondition;
        }
        if (node.getCorrelationPath() == null && node.getAliasInfo().isRootNode()) {
            sb.append(node.getEntityType().getName());
        } else if (node.isQualifiedJoin()) {
            sb.append(node.getQualificationExpression());
            sb.append('(');
            sb.append(joinBase.getJoinNode().getAlias());
            sb.append(')');
        } else {
            this.renderAlias(sb, joinBase.getJoinNode(), this.mainQuery.jpaProvider.supportsRootTreatJoin());
            sb.append('.').append(node.getParentTreeNode().getRelationName());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderAlias(StringBuilder sb, JoinNode baseNode, boolean supportsTreat) {
        if (baseNode.getTreatType() != null) {
            if (supportsTreat) {
                baseNode.appendAlias(sb, true);
                return;
            } else {
                if (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
                baseNode.appendAlias(sb, false);
            }
            return;
        } else {
            baseNode.appendAlias(sb, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderReverseDependency(StringBuilder sb, JoinNode dependency, String aliasPrefix, boolean renderFetches, Set<JoinNode> nodesToFetch, List<String> whereConjuncts) {
        if (dependency.getParent() != null) {
            this.renderReverseDependency(sb, dependency.getParent(), aliasPrefix, renderFetches, nodesToFetch, whereConjuncts);
            if (!dependency.getDependencies().isEmpty()) {
                this.markedJoinNodes.add(dependency);
                try {
                    for (JoinNode dep : dependency.getDependencies()) {
                        if (this.markedJoinNodes.contains(dep)) {
                            StringBuilder errorSb = new StringBuilder();
                            errorSb.append("Cyclic join dependency between nodes: [");
                            for (JoinNode seenNode : this.markedJoinNodes) {
                                errorSb.append(seenNode.getAliasInfo().getAlias());
                                if (seenNode.getAliasInfo().isImplicit()) {
                                    errorSb.append('(').append(seenNode.getAliasInfo().getAbsolutePath()).append(')');
                                }
                                errorSb.append(", ");
                            }
                            errorSb.setLength(errorSb.length() - 2);
                            errorSb.append(']');
                            throw new IllegalStateException(errorSb.toString());
                        }
                        this.renderReverseDependency(sb, dep, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts);
                    }
                }
                finally {
                    this.markedJoinNodes.remove(dependency);
                }
            }
            this.renderJoinNode(sb, dependency.getParent().getAliasInfo(), dependency, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts);
        }
    }

    private void applyJoins(StringBuilder sb, JoinAliasInfo joinBase, Map<String, JoinTreeNode> nodes, Set<ClauseType> clauseExclusions, String aliasPrefix, boolean collectCollectionJoinNodes, boolean renderFetches, Set<JoinNode> nodesToFetch, List<String> whereConjuncts) {
        for (Map.Entry<String, JoinTreeNode> nodeEntry : nodes.entrySet()) {
            JoinTreeNode treeNode = nodeEntry.getValue();
            ArrayList<JoinNode> stack = new ArrayList<JoinNode>();
            stack.addAll(treeNode.getJoinNodes().descendingMap().values());
            this.applyJoins(sb, joinBase, stack, treeNode.isCollection(), clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
        }
    }

    private void applyJoins(StringBuilder sb, JoinAliasInfo joinBase, List<JoinNode> stack, boolean isCollection, Set<ClauseType> clauseExclusions, String aliasPrefix, boolean collectCollectionJoinNodes, boolean renderFetches, Set<JoinNode> nodesToFetch, List<String> whereConjuncts) {
        while (!stack.isEmpty()) {
            JoinNode node = stack.remove(stack.size() - 1);
            if (!clauseExclusions.isEmpty() && clauseExclusions.containsAll(node.getClauseDependencies()) && !node.isCardinalityMandatory()) continue;
            stack.addAll(node.getEntityJoinNodes());
            stack.addAll(node.getTreatedJoinNodes().values());
            if (!node.getDependencies().isEmpty()) {
                this.renderReverseDependency(sb, node, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts);
            }
            if (collectCollectionJoinNodes && isCollection) {
                this.collectionJoinNodes.add(node);
            }
            this.renderJoinNode(sb, joinBase, node, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts);
            if (node.getNodes().isEmpty()) continue;
            this.applyJoins(sb, node.getAliasInfo(), node.getNodes(), clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, nodesToFetch, whereConjuncts);
        }
    }

    private boolean isExternal(PathExpression path) {
        PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
        return this.isExternal(path, firstElem);
    }

    private boolean isExternal(TreatExpression treatExpression) {
        Expression expression = treatExpression.getExpression();
        if (expression instanceof PathExpression) {
            PathExpression path = (PathExpression)expression;
            PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
            return this.isExternal(path, firstElem);
        }
        if (expression instanceof FunctionExpression) {
            PathExpression path = (PathExpression)((FunctionExpression)expression).getExpressions().get(0);
            PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
            return this.isExternal(path, firstElem);
        }
        throw new IllegalArgumentException("Unexpected expression type[" + expression.getClass().getSimpleName() + "] in treat expression: " + treatExpression);
    }

    private boolean isExternal(PathExpression path, PathElementExpression firstElem) {
        String startAlias;
        if (firstElem instanceof ArrayExpression) {
            startAlias = ((ArrayExpression)firstElem).getBase().toString();
        } else if (firstElem instanceof TreatExpression) {
            Expression treatedExpression = ((TreatExpression)firstElem).getExpression();
            if (treatedExpression instanceof PathExpression) {
                treatedExpression = (Expression)((PathExpression)treatedExpression).getExpressions().get(0);
            }
            startAlias = treatedExpression instanceof ArrayExpression ? ((ArrayExpression)treatedExpression).getBase().toString() : (treatedExpression instanceof TreatExpression ? ((TreatExpression)treatedExpression).getExpression().toString() : treatedExpression.toString());
        } else {
            startAlias = firstElem.toString();
        }
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(startAlias);
        if (aliasInfo == null) {
            return false;
        }
        if (this.parent != null && aliasInfo.getAliasOwner() != this.aliasManager) {
            if (path.getExpressions().size() > 1 && aliasInfo instanceof SelectInfo) {
                throw new ExternalAliasDereferencingException("Start alias [" + startAlias + "] of path [" + path.toString() + "] is external and must not be dereferenced");
            }
            return true;
        }
        if (aliasInfo.getAliasOwner() == this.aliasManager) {
            return false;
        }
        throw new IllegalStateException("Alias [" + aliasInfo.getAlias() + "] originates from an unknown query");
    }

    public boolean isJoinableSelectAlias(PathExpression pathExpr, boolean fromSelect, boolean fromSubquery) {
        return this.getJoinableSelectAlias(pathExpr, fromSelect, fromSubquery) != null;
    }

    public Expression getJoinableSelectAlias(PathExpression pathExpr, boolean fromSelect, boolean fromSubquery) {
        if (!(pathExpr.getExpressions().get(0) instanceof PropertyExpression)) {
            return null;
        }
        boolean singlePathElement = pathExpr.getExpressions().size() == 1;
        String startAlias = ((PathElementExpression)pathExpr.getExpressions().get(0)).toString();
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(startAlias);
        if (aliasInfo == null) {
            return null;
        }
        if (aliasInfo instanceof SelectInfo && !fromSelect && !fromSubquery) {
            if (!singlePathElement) {
                throw new IllegalStateException("Path starting with select alias not allowed");
            }
            Expression expression = ((SelectInfo)aliasInfo).getExpression();
            if (expression == pathExpr) {
                return null;
            }
            return expression;
        }
        return null;
    }

    <X> JoinOnBuilder<X> joinOn(X result, String base, Class<?> clazz, String alias, JoinType type) {
        return this.joinOn(result, base, this.metamodel.entity(clazz), alias, type);
    }

    <X> JoinOnBuilder<X> joinOn(X result, String base, EntityType<?> entityType, String alias, JoinType type) {
        JoinNode baseNode;
        AliasInfo aliasInfo;
        PathExpression basePath = this.expressionFactory.createPathExpression(base);
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty alias!");
        }
        if (type != JoinType.INNER && !this.mainQuery.jpaProvider.supportsEntityJoin()) {
            throw new IllegalArgumentException("The JPA provider does not support entity joins and an emulation for non-inner entity joins is not implemented!");
        }
        List propertyExpressions = basePath.getExpressions();
        if (propertyExpressions.size() > 1) {
            aliasInfo = this.aliasManager.getAliasInfo(((PathElementExpression)propertyExpressions.get(0)).toString());
            if (aliasInfo == null || !(aliasInfo instanceof JoinAliasInfo)) {
                throw new IllegalArgumentException("The base '" + base + "' is not a valid join alias!");
            }
            baseNode = ((JoinAliasInfo)aliasInfo).getJoinNode();
            for (int i = 1; i < propertyExpressions.size(); ++i) {
                String relationName = ((PathElementExpression)propertyExpressions.get(i)).toString();
                JoinTreeNode treeNode = baseNode.getNodes().get(relationName);
                if (treeNode == null || (baseNode = treeNode.getDefaultNode()) == null) break;
            }
            if (baseNode == null) {
                throw new IllegalArgumentException("The base '" + base + "' is not a valid join alias!");
            }
        } else {
            aliasInfo = this.aliasManager.getAliasInfo(base);
            if (aliasInfo == null || !(aliasInfo instanceof JoinAliasInfo)) {
                throw new IllegalArgumentException("The base '" + base + "' is not a valid join alias!");
            }
            baseNode = ((JoinAliasInfo)aliasInfo).getJoinNode();
        }
        JoinAliasInfo joinAliasInfo = new JoinAliasInfo(alias, null, false, true, this.aliasManager);
        JoinNode entityJoinNode = JoinNode.createEntityJoinNode(baseNode, type, entityType, joinAliasInfo);
        joinAliasInfo.setJoinNode(entityJoinNode);
        baseNode.addEntityJoin(entityJoinNode);
        this.aliasManager.registerAliasInfo(joinAliasInfo);
        this.joinOnBuilderListener.joinNode = entityJoinNode;
        return this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }

    <X> JoinOnBuilder<X> joinOn(X result, String path, String alias, JoinType type, boolean defaultJoin) {
        this.joinOnBuilderListener.joinNode = this.join(path, alias, type, false, defaultJoin);
        return this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JoinNode join(String path, String alias, JoinType type, boolean fetch, boolean defaultJoin) {
        JoinNode current;
        JoinResult result;
        PathElementExpression elementExpr;
        Expression expr = this.expressionFactory.createJoinPathExpression(path);
        String treatType = null;
        if (expr instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expr;
            if (this.isExternal(pathExpression) || this.isJoinableSelectAlias(pathExpression, false, false)) {
                throw new IllegalArgumentException("No external path or select alias allowed in join path");
            }
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(null, pathExpression, null, null, 0, pathElements.size() - 1, false);
            current = result.baseNode;
        } else {
            if (!(expr instanceof TreatExpression)) throw new IllegalArgumentException("Join path [" + path + "] is not a path");
            TreatExpression treatExpression = (TreatExpression)expr;
            if (this.isExternal(treatExpression)) {
                throw new IllegalArgumentException("No external path or select alias allowed in join path");
            }
            Expression expression = treatExpression.getExpression();
            if (!(expression instanceof PathExpression)) throw new IllegalArgumentException("Unexpected expression type[" + expression.getClass().getSimpleName() + "] in treat expression: " + treatExpression);
            PathExpression pathExpression = (PathExpression)expression;
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(null, pathExpression, null, null, 0, pathElements.size() - 1, false);
            current = result.baseNode;
            treatType = treatExpression.getType();
        }
        if (elementExpr instanceof ArrayExpression) {
            throw new IllegalArgumentException("Array expressions are not allowed!");
        }
        if (elementExpr instanceof MapKeyExpression) {
            MapKeyExpression mapKeyExpression = (MapKeyExpression)elementExpr;
            boolean fromSubquery = false;
            boolean fromSelectAlias = false;
            boolean joinRequired = true;
            current = this.joinMapKey(mapKeyExpression, alias, null, null, fromSubquery, fromSelectAlias, joinRequired, fetch, false, defaultJoin);
            result = new JoinResult(current, null, current.getNodeType());
        } else {
            List joinRelationAttributes = result.addToList(new ArrayList());
            joinRelationAttributes.add(elementExpr.toString());
            current = current == null ? this.getRootNodeOrFail("Could not join path [", path, "] because it did not use an absolute path but multiple root nodes are available!") : current;
            result = this.createOrUpdateNode(current, joinRelationAttributes, treatType, alias, type, false, defaultJoin);
        }
        if (!fetch) return result.baseNode;
        this.fetchPath(result.baseNode);
        return result.baseNode;
    }

    public void implicitJoin(Expression expression, boolean objectLeafAllowed, String targetType, ClauseType fromClause, String selectAlias, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean idRemovable) {
        this.implicitJoin(expression, objectLeafAllowed, targetType, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, idRemovable, false);
    }

    public void implicitJoin(Expression expression, boolean objectLeafAllowed, String targetTypeName, ClauseType fromClause, String selectAlias, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean idRemovable, boolean fetch) {
        if (expression instanceof PathExpression) {
            JoinResult result;
            AliasInfo aliasInfo;
            JoinResult currentResult;
            JoinNode possibleRoot;
            PathExpression pathExpression = (PathExpression)expression;
            Expression aliasedExpression = this.getJoinableSelectAlias(pathExpression, fromClause == ClauseType.SELECT, fromSubquery);
            if (aliasedExpression != null) {
                if (!fromSelectAlias) {
                    this.implicitJoin(aliasedExpression, true, null, fromClause, selectAlias, fromSubquery, true, joinRequired, false);
                }
                return;
            }
            if (this.isExternal(pathExpression)) {
                this.parent.implicitJoin((Expression)pathExpression, true, targetTypeName, fromClause, selectAlias, true, fromSelectAlias, joinRequired, false);
                return;
            }
            List pathElements = pathExpression.getExpressions();
            int pathElementSize = pathElements.size();
            for (int i = 0; i < pathElementSize; ++i) {
                PathElementExpression pathElem = (PathElementExpression)pathElements.get(i);
                if (!(pathElem instanceof ArrayExpression)) continue;
                this.implicitJoin(((ArrayExpression)pathElem).getIndex(), false, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false);
            }
            PathElementExpression elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            boolean singleValuedAssociationIdExpression = false;
            JoinNode current = null;
            ArrayList<String> resultFields = new ArrayList();
            int startIndex = 0;
            if (pathElements.size() > 1 && (possibleRoot = this.getRootNode((Expression)pathElements.get(0))) != null) {
                startIndex = 1;
                current = possibleRoot;
            }
            if (pathElements.size() > startIndex + 1) {
                int maybeSingularAssociationIndex = pathElements.size() - 2;
                int maybeSingularAssociationIdIndex = pathElements.size() - 1;
                currentResult = this.implicitJoin(current, pathExpression, fromClause, selectAlias, startIndex, maybeSingularAssociationIndex, false);
                current = currentResult.baseNode;
                resultFields = currentResult.addToList(resultFields);
                singleValuedAssociationIdExpression = this.isSingleValuedAssociationId(currentResult, pathElements, idRemovable);
                if (singleValuedAssociationIdExpression) {
                    if (!this.mainQuery.jpaProvider.supportsSingleValuedAssociationIdExpressions()) {
                        if (idRemovable) {
                            elementExpr = null;
                            if (current == null) {
                                AliasInfo a = this.aliasManager.getAliasInfo(((PathElementExpression)pathElements.get(maybeSingularAssociationIndex)).toString());
                                current = ((JoinAliasInfo)a).getJoinNode();
                                resultFields = Collections.emptyList();
                            }
                        } else {
                            currentResult = this.implicitJoin(current, pathExpression, fromClause, selectAlias, maybeSingularAssociationIndex, pathElements.size() - 1, false);
                            current = currentResult.baseNode;
                            resultFields = currentResult.addToList(resultFields);
                            singleValuedAssociationIdExpression = false;
                        }
                    }
                } else {
                    if (currentResult.hasField()) {
                        currentResult = this.implicitJoin(current, pathExpression, fromClause, selectAlias, maybeSingularAssociationIndex - currentResult.fields.size(), maybeSingularAssociationIdIndex, false);
                        if (currentResult.fields != resultFields) {
                            resultFields.clear();
                        }
                    } else {
                        currentResult = this.implicitJoin(current, pathExpression, fromClause, selectAlias, maybeSingularAssociationIndex, maybeSingularAssociationIdIndex, false);
                    }
                    current = currentResult.baseNode;
                    resultFields = currentResult.addToList(resultFields);
                }
            } else {
                currentResult = this.implicitJoin(current, pathExpression, fromClause, selectAlias, startIndex, pathElements.size() - 1, false);
                current = currentResult.baseNode;
                resultFields = currentResult.addToList(resultFields);
                if (idRemovable) {
                    if (current != null) {
                        if (this.isId(current.getNodeType(), (Expression)elementExpr)) {
                            elementExpr = null;
                            singleValuedAssociationIdExpression = true;
                        }
                    } else {
                        String elementExpressionString = elementExpr instanceof ArrayExpression ? ((ArrayExpression)elementExpr).getBase().toString() : elementExpr.toString();
                        AliasInfo a = this.aliasManager.getAliasInfo(elementExpressionString);
                        if (a == null && this.isId((current = this.getRootNodeOrFail("Could not join path [", expression, "] because it did not use an absolute path but multiple root nodes are available!")).getNodeType(), (Expression)elementExpr)) {
                            elementExpr = new PropertyExpression(current.getAlias());
                        }
                    }
                }
            }
            if (!(pathElements.size() != 1 || fromSelectAlias || (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(elementExpr.toString())) == null || selectAlias != null && selectAlias.equals(elementExpr.toString()))) {
                if (aliasInfo instanceof SelectInfo) {
                    if (targetTypeName != null) {
                        throw new IllegalArgumentException("The select alias '" + aliasInfo.getAlias() + "' can not be used for a treat expression!.");
                    }
                    Expression selectExpr = ((SelectInfo)aliasInfo).getExpression();
                    if (!(selectExpr instanceof PathExpression)) {
                        throw new RuntimeException("The select expression '" + selectExpr.toString() + "' is not a simple path expression! No idea how to implicit join that.");
                    }
                    if (((PathExpression)selectExpr).getBaseNode() == null) {
                        this.implicitJoin(selectExpr, objectLeafAllowed, null, fromClause, selectAlias, fromSubquery, true, joinRequired, false);
                    }
                    PathExpression selectPathExpr = (PathExpression)selectExpr;
                    PathReference reference = selectPathExpr.getPathReference();
                    result = new JoinResult((JoinNode)selectPathExpr.getBaseNode(), Arrays.asList(selectPathExpr.getField()), reference.getType());
                } else {
                    JoinNode pathJoinNode = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    if (targetTypeName != null) {
                        ManagedType<?> targetType = this.metamodel.managedType(targetTypeName);
                        result = new JoinResult(pathJoinNode, null, (Type<?>)targetType);
                    } else {
                        result = new JoinResult(pathJoinNode, null, pathJoinNode.getNodeType());
                    }
                }
            } else if (pathElements.size() == 1 && elementExpr instanceof QualifiedExpression) {
                JoinNode baseNode;
                QualifiedExpression qualifiedExpression = (QualifiedExpression)elementExpr;
                if (elementExpr instanceof MapKeyExpression) {
                    baseNode = this.joinMapKey((MapKeyExpression)elementExpr, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, true, fetch, true, true);
                } else if (elementExpr instanceof ListIndexExpression) {
                    baseNode = this.joinListIndex((ListIndexExpression)elementExpr, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, true, fetch, true, true);
                } else if (elementExpr instanceof MapEntryExpression) {
                    baseNode = this.joinMapEntry((MapEntryExpression)elementExpr, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, true, fetch, true, true);
                } else if (elementExpr instanceof MapValueExpression) {
                    this.implicitJoin((Expression)qualifiedExpression.getPath(), objectLeafAllowed, targetTypeName, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false, fetch);
                    baseNode = (JoinNode)qualifiedExpression.getPath().getBaseNode();
                } else {
                    throw new IllegalArgumentException("Unknown qualified expression type: " + elementExpr);
                }
                result = new JoinResult(baseNode, null, baseNode.getNodeType());
            } else {
                String attributeName;
                if (current == null) {
                    current = this.getRootNodeOrFail("Could not join path [", expression, "] because it did not use an absolute path but multiple root nodes are available!");
                }
                if (singleValuedAssociationIdExpression) {
                    String associationName = ((PathElementExpression)pathElements.get(pathElements.size() - 2)).toString();
                    AliasInfo singleValuedAssociationRootAliasInfo = null;
                    if (currentResult.hasField()) {
                        associationName = currentResult.joinFields(associationName);
                    } else if (pathElements.size() == 2) {
                        singleValuedAssociationRootAliasInfo = this.aliasManager.getAliasInfoForBottomLevel(associationName);
                    }
                    if (singleValuedAssociationRootAliasInfo != null) {
                        JoinNode singleValuedAssociationRoot = ((JoinAliasInfo)singleValuedAssociationRootAliasInfo).getJoinNode();
                        if (elementExpr != null) {
                            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, singleValuedAssociationRoot.getNodeType(), (Expression)elementExpr, singleValuedAssociationRoot.getAlias());
                            Type<?> type = attributeHolder.getAttributeType();
                            result = new JoinResult(singleValuedAssociationRoot, Arrays.asList(elementExpr.toString()), type);
                        } else {
                            result = new JoinResult(singleValuedAssociationRoot, null, singleValuedAssociationRoot.getNodeType());
                        }
                    } else {
                        JoinTreeNode treeNode = current.getNodes().get(associationName);
                        if (treeNode != null && treeNode.getDefaultNode() != null) {
                            if (elementExpr != null) {
                                AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, treeNode.getDefaultNode().getNodeType(), (Expression)elementExpr, treeNode.getDefaultNode().getAlias());
                                Type<?> type = attributeHolder.getAttributeType();
                                result = new JoinResult(treeNode.getDefaultNode(), Arrays.asList(elementExpr.toString()), type);
                            } else {
                                result = new JoinResult(treeNode.getDefaultNode(), null, treeNode.getDefaultNode().getNodeType());
                            }
                        } else if (elementExpr != null) {
                            String elementString = elementExpr.toString();
                            Expression resultExpr = this.expressionFactory.createSimpleExpression(associationName + '.' + elementString, false);
                            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, current.getNodeType(), resultExpr, current.getAlias());
                            Type<?> type = attributeHolder.getAttributeType();
                            result = new JoinResult(current, Arrays.asList(associationName, elementString), type);
                        } else {
                            Expression resultExpr = this.expressionFactory.createSimpleExpression(associationName, false);
                            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, current.getNodeType(), resultExpr, current.getAlias());
                            Type<?> type = attributeHolder.getAttributeType();
                            result = new JoinResult(current, Arrays.asList(associationName), type);
                        }
                    }
                } else if (elementExpr instanceof ArrayExpression) {
                    ArrayExpression arrayExpr = (ArrayExpression)elementExpr;
                    String joinRelationName = arrayExpr.getBase().toString();
                    if (pathElements.size() == 1 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(joinRelationName)) != null) {
                        if (aliasInfo instanceof SelectInfo) {
                            throw new IllegalArgumentException("Illegal reference to the select alias '" + joinRelationName + "'");
                        }
                        current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                        this.generateAndApplyOnPredicate(current, arrayExpr);
                    } else {
                        JoinNode matchingNode = this.findNode(current, joinRelationName, arrayExpr);
                        if (matchingNode != null) {
                            current = matchingNode;
                        } else {
                            String joinAlias = this.getJoinAlias(arrayExpr);
                            resultFields.add(joinRelationName);
                            currentResult = this.createOrUpdateNode(current, resultFields, null, joinAlias, null, true, false);
                            current = currentResult.baseNode;
                            if (currentResult.hasField()) {
                                throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + currentResult.joinFields() + "]");
                            }
                            this.generateAndApplyOnPredicate(current, arrayExpr);
                        }
                    }
                    result = new JoinResult(current, null, current.getNodeType());
                } else if (!pathExpression.isUsedInCollectionFunction()) {
                    if (resultFields.isEmpty()) {
                        result = this.implicitJoinSingle(current, elementExpr.toString(), objectLeafAllowed, joinRequired);
                    } else {
                        resultFields.add(elementExpr.toString());
                        attributeName = StringUtils.join((CharSequence)".", resultFields);
                        this.getPathType(current.getNodeType(), attributeName, pathExpression);
                        result = this.implicitJoinSingle(current, attributeName, objectLeafAllowed, joinRequired);
                    }
                } else if (resultFields.isEmpty()) {
                    attributeName = elementExpr.toString();
                    Type<?> type = this.getPathType(current.getNodeType(), attributeName, pathExpression);
                    result = new JoinResult(current, Arrays.asList(attributeName), type);
                } else {
                    resultFields.add(elementExpr.toString());
                    attributeName = StringUtils.join((CharSequence)".", resultFields);
                    Type<?> type = this.getPathType(current.getNodeType(), attributeName, pathExpression);
                    result = new JoinResult(current, resultFields, type);
                }
            }
            if (fetch) {
                this.fetchPath(result.baseNode);
            }
            if (fromClause != null) {
                try {
                    this.updateClauseDependencies(result.baseNode, fromClause, new LinkedHashSet<JoinNode>());
                }
                catch (IllegalStateException ex) {
                    throw new IllegalArgumentException("Implicit join in expression '" + expression + "' introduces cyclic join dependency!", ex);
                }
            }
            if (result.isLazy()) {
                pathExpression.setPathReference((PathReference)new LazyPathReference(result.baseNode, result.joinFields(), result.type));
            } else {
                pathExpression.setPathReference((PathReference)new SimplePathReference(result.baseNode, result.joinFields(), result.type));
            }
        } else if (expression instanceof FunctionExpression) {
            List expressions = ((FunctionExpression)expression).getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                this.implicitJoin((Expression)expressions.get(i), objectLeafAllowed, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false);
            }
        } else if (expression instanceof MapKeyExpression) {
            MapKeyExpression mapKeyExpression = (MapKeyExpression)expression;
            this.joinMapKey(mapKeyExpression, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, fetch, true, true);
        } else if (expression instanceof QualifiedExpression) {
            this.implicitJoin((Expression)((QualifiedExpression)expression).getPath(), objectLeafAllowed, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false);
        } else if (expression instanceof ArrayExpression || expression instanceof GeneralCaseExpression || expression instanceof TreatExpression) {
            throw new IllegalArgumentException("Unsupported expression for implicit joining found: " + expression);
        }
    }

    private JoinNode getFetchOwner(JoinNode node) {
        while (node.isFetch()) {
            node = node.getParent();
        }
        return node;
    }

    private Type<?> getPathType(Type<?> baseType, String expression, PathExpression pathExpression) {
        try {
            return JpaUtils.getAttributeForJoining(this.metamodel, baseType, (Expression)this.expressionFactory.createPathExpression(expression), null).getAttributeType();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + expression + "]");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSingleValuedAssociationId(JoinResult joinResult, List<PathElementExpression> pathElements, boolean idRemovable) {
        AttributeHolder maybeSingularAssociationJoinResult;
        Type<?> baseType;
        String maybeSingularAssociationName;
        int maybeSingularAssociationIdIndex;
        JoinNode parent;
        block18: {
            parent = joinResult.baseNode;
            int maybeSingularAssociationIndex = pathElements.size() - 2;
            maybeSingularAssociationIdIndex = pathElements.size() - 1;
            PathElementExpression maybeSingularAssociationNameExpression = pathElements.get(maybeSingularAssociationIndex);
            maybeSingularAssociationName = this.getSimpleName(maybeSingularAssociationNameExpression);
            if (parent == null) {
                if (maybeSingularAssociationNameExpression instanceof TreatExpression) {
                    return false;
                }
                AliasInfo a = this.aliasManager.getAliasInfo(maybeSingularAssociationName);
                if (a == null) {
                    parent = this.getRootNodeOrFail("Ambiguous join path [", maybeSingularAssociationName, "] because of multiple root nodes!");
                    baseType = parent.getManagedType();
                    maybeSingularAssociationJoinResult = JpaUtils.getAttributeForJoining(this.metamodel, baseType, (Expression)maybeSingularAssociationNameExpression, parent.getAlias());
                    break block18;
                } else {
                    if (!(a instanceof JoinAliasInfo)) {
                        throw new IllegalArgumentException("Can't dereference select alias in the expression!");
                    }
                    if (!idRemovable) {
                        return false;
                    }
                    JoinNode joinNode = ((JoinAliasInfo)a).getJoinNode();
                    PathElementExpression maybeSingularAssociationIdExpression = pathElements.get(maybeSingularAssociationIdIndex);
                    if (this.isId(joinNode.getNodeType(), (Expression)maybeSingularAssociationIdExpression)) {
                        return true;
                    }
                    parent = joinNode.getParent();
                    if (joinNode.getParentTreeNode() == null) {
                        return false;
                    }
                    maybeSingularAssociationName = joinNode.getParentTreeNode().getRelationName();
                    ExtendedManagedType managedType = this.metamodel.getManagedType(ExtendedManagedType.class, parent.getJavaType());
                    return managedType.getAttributes().containsKey(maybeSingularAssociationName + "." + maybeSingularAssociationIdExpression);
                }
            }
            if (joinResult.hasField()) {
                PathExpression fieldExpression = this.expressionFactory.createPathExpression(joinResult.joinFields());
                AttributeHolder result = JpaUtils.getAttributeForJoining(this.metamodel, parent.getNodeType(), (Expression)fieldExpression, parent.getAlias());
                baseType = result.getAttributeType();
            } else {
                baseType = parent.getNodeType();
            }
            maybeSingularAssociationJoinResult = JpaUtils.getAttributeForJoining(this.metamodel, baseType, (Expression)maybeSingularAssociationNameExpression, null);
        }
        Attribute<?, ?> maybeSingularAssociation = maybeSingularAssociationJoinResult.getAttribute();
        if (maybeSingularAssociation == null) {
            return false;
        }
        if (maybeSingularAssociation.getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE && maybeSingularAssociation.getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE) {
            return false;
        }
        if (!(maybeSingularAssociation instanceof MapKeyAttribute)) {
            if (!(baseType instanceof EmbeddableType)) {
                if (this.mainQuery.jpaProvider.isForeignJoinColumn((EntityType)baseType, maybeSingularAssociation.getName())) {
                    return false;
                }
            } else {
                String attributePath = joinResult.joinFields(maybeSingularAssociationName);
                JoinNode node = parent;
                baseType = node.getNodeType();
                while (baseType instanceof EmbeddableType && node.getParentTreeNode() != null) {
                    attributePath = node.getParentTreeNode().getRelationName() + "." + attributePath;
                    node = node.getParent();
                    baseType = node.getNodeType();
                }
                if (this.mainQuery.jpaProvider.isForeignJoinColumn((EntityType)baseType, attributePath)) {
                    return false;
                }
            }
        }
        PathElementExpression maybeSingularAssociationIdExpression = pathElements.get(maybeSingularAssociationIdIndex);
        ExtendedManagedType managedType = this.metamodel.getManagedType(ExtendedManagedType.class, parent.getJavaType());
        String field = maybeSingularAssociationName + "." + maybeSingularAssociationIdExpression;
        return managedType.getAttributes().containsKey(joinResult.joinFields(field));
    }

    private boolean isId(Type<?> type, Expression idExpression) {
        AttributeHolder maybeSingularAssociationIdJoinResult = JpaUtils.getAttributeForJoining(this.metamodel, type, idExpression, null);
        Attribute<?, ?> maybeSingularAssociationId = maybeSingularAssociationIdJoinResult.getAttribute();
        if (!(maybeSingularAssociationId instanceof SingularAttribute)) {
            return false;
        }
        return ((SingularAttribute)maybeSingularAssociationId).isId();
    }

    private String getSimpleName(PathElementExpression element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ArrayExpression) {
            return ((ArrayExpression)element).getBase().getProperty();
        }
        return element.toString();
    }

    private String getJoinAlias(ArrayExpression expr) {
        StringBuilder sb = new StringBuilder(expr.getBase().toString());
        Expression indexExpr = expr.getIndex();
        if (indexExpr instanceof ParameterExpression) {
            ParameterExpression indexParamExpr = (ParameterExpression)indexExpr;
            sb.append('_');
            sb.append(indexParamExpr.getName());
        } else if (indexExpr instanceof PathExpression) {
            PathExpression indexPathExpr = (PathExpression)indexExpr;
            sb.append('_');
            sb.append(((JoinNode)indexPathExpr.getBaseNode()).getAliasInfo().getAlias());
            if (indexPathExpr.getField() != null) {
                sb.append('_');
                sb.append(indexPathExpr.getField().replaceAll("\\.", "_"));
            }
        } else if (indexExpr instanceof NumericLiteral) {
            sb.append('_');
            sb.append(((NumericLiteral)indexExpr).getValue());
        } else if (indexExpr instanceof StringLiteral) {
            sb.append('_');
            sb.append(((StringLiteral)indexExpr).getValue());
        } else {
            throw new IllegalStateException("Invalid array index expression " + indexExpr.toString());
        }
        return sb.toString();
    }

    private EqPredicate getArrayExpressionPredicate(JoinNode joinNode, ArrayExpression arrayExpr) {
        PathExpression keyPath = new PathExpression(new ArrayList(), true);
        keyPath.getExpressions().add(new PropertyExpression(joinNode.getAliasInfo().getAlias()));
        keyPath.setPathReference((PathReference)new SimplePathReference(joinNode, null, joinNode.getNodeType()));
        Attribute<?, ?> arrayBaseAttribute = joinNode.getParentTreeNode().getAttribute();
        Object keyExpression = arrayBaseAttribute instanceof ListAttribute ? new ListIndexExpression(keyPath) : new MapKeyExpression(keyPath);
        return new EqPredicate((Expression)keyExpression, arrayExpr.getIndex());
    }

    private void registerDependencies(final JoinNode joinNode, CompoundPredicate onExpression) {
        onExpression.accept((Expression.Visitor)new VisitorAdapter(){

            public void visit(PathExpression pathExpr) {
                if (pathExpr.getBaseNode() != joinNode) {
                    joinNode.getDependencies().add((JoinNode)pathExpr.getBaseNode());
                }
            }
        });
    }

    private void generateAndApplyOnPredicate(JoinNode joinNode, ArrayExpression arrayExpr) {
        EqPredicate valueKeyFilterPredicate = this.getArrayExpressionPredicate(joinNode, arrayExpr);
        if (joinNode.getOnPredicate() != null) {
            CompoundPredicate currentPred = joinNode.getOnPredicate();
            if (!this.findPredicate(currentPred, (Predicate)valueKeyFilterPredicate)) {
                currentPred.getChildren().add(valueKeyFilterPredicate);
                this.registerDependencies(joinNode, currentPred);
            }
        } else {
            CompoundPredicate onAndPredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND);
            onAndPredicate.getChildren().add(valueKeyFilterPredicate);
            joinNode.setOnPredicate(onAndPredicate);
            this.registerDependencies(joinNode, onAndPredicate);
        }
    }

    private JoinResult implicitJoin(JoinNode current, PathExpression pathExpression, ClauseType fromClause, String selectAlias, int start, int end, boolean allowParentAliases) {
        List pathElements = pathExpression.getExpressions();
        List<String> resultFields = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            AliasInfo aliasInfo;
            PathElementExpression elementExpr = (PathElementExpression)pathElements.get(i);
            if (elementExpr instanceof ArrayExpression) {
                String joinRelationName;
                List<String> joinRelationAttributes;
                ArrayExpression arrayExpr = (ArrayExpression)elementExpr;
                if (!resultFields.isEmpty()) {
                    resultFields.add(arrayExpr.getBase().toString());
                    joinRelationAttributes = resultFields;
                    resultFields = new ArrayList();
                    joinRelationName = StringUtils.join((CharSequence)".", joinRelationAttributes);
                } else {
                    joinRelationName = arrayExpr.getBase().toString();
                    joinRelationAttributes = Arrays.asList(joinRelationName);
                }
                current = current == null ? this.getRootNodeOrFail("Ambiguous join path [", joinRelationName, "] because of multiple root nodes!") : current;
                JoinNode matchingNode = this.findNode(current, joinRelationName, arrayExpr);
                if (matchingNode != null) {
                    current = matchingNode;
                    continue;
                }
                if (i == 0 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(joinRelationName)) != null) {
                    if (aliasInfo instanceof SelectInfo) {
                        throw new IllegalArgumentException("Illegal reference to the select alias '" + joinRelationName + "'");
                    }
                    current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    this.generateAndApplyOnPredicate(current, arrayExpr);
                    continue;
                }
                String joinAlias = this.getJoinAlias(arrayExpr);
                JoinResult result = this.createOrUpdateNode(current, joinRelationAttributes, null, joinAlias, null, true, false);
                current = result.baseNode;
                resultFields = result.addToList(resultFields);
                this.generateAndApplyOnPredicate(current, arrayExpr);
                continue;
            }
            if (elementExpr instanceof TreatExpression) {
                if (i != 0 || current != null) {
                    throw new IllegalArgumentException("A treat expression should be the first element in a path!");
                }
                TreatExpression treatExpression = (TreatExpression)elementExpr;
                boolean fromSubquery = false;
                boolean fromSelectAlias = false;
                boolean joinRequired = false;
                boolean fetch = false;
                if (treatExpression.getExpression() instanceof PathExpression) {
                    PathExpression treatedPathExpression = (PathExpression)treatExpression.getExpression();
                    this.implicitJoin((Expression)treatedPathExpression, true, treatExpression.getType(), fromClause, selectAlias, fromSubquery, fromSelectAlias, true, false, fetch);
                    JoinNode treatedJoinNode = (JoinNode)treatedPathExpression.getBaseNode();
                    EntityType<?> treatType = this.metamodel.getEntity(treatExpression.getType());
                    current = treatedJoinNode.getTreatedJoinNode(treatType);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported treated expression type: " + treatExpression.getExpression().getClass());
            }
            if (elementExpr instanceof MapKeyExpression) {
                MapKeyExpression mapKeyExpression = (MapKeyExpression)elementExpr;
                boolean fromSubquery = false;
                boolean fromSelectAlias = false;
                boolean joinRequired = true;
                boolean fetch = false;
                current = this.joinMapKey(mapKeyExpression, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, fetch, true, true);
                continue;
            }
            if (elementExpr instanceof MapValueExpression) {
                MapValueExpression mapValueExpression = (MapValueExpression)elementExpr;
                boolean fromSubquery = false;
                boolean fromSelectAlias = false;
                boolean joinRequired = true;
                boolean fetch = false;
                this.implicitJoin((Expression)mapValueExpression.getPath(), true, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, fetch);
                current = (JoinNode)mapValueExpression.getPath().getBaseNode();
                continue;
            }
            if (pathElements.size() == 1 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(elementExpr.toString())) != null) {
                if (aliasInfo instanceof SelectInfo) {
                    throw new IllegalArgumentException("Can't dereference a select alias");
                }
                current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                continue;
            }
            if (resultFields.isEmpty()) {
                JoinResult result = this.implicitJoinSingle(current, elementExpr.toString(), allowParentAliases);
                if (current != result.baseNode) {
                    current = result.baseNode;
                }
                resultFields = result.addToList(resultFields);
                continue;
            }
            resultFields.add(elementExpr.toString());
            JoinResult currentResult = this.createOrUpdateNode(current, resultFields, null, null, null, true, true);
            current = currentResult.baseNode;
            if (currentResult.hasField()) continue;
            resultFields.clear();
        }
        if (resultFields.isEmpty()) {
            return new JoinResult(current, null, current == null ? null : current.getNodeType());
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)resultFields.get(0));
        for (int i = 1; i < resultFields.size(); ++i) {
            sb.append('.');
            sb.append((String)resultFields.get(i));
        }
        Expression expression = this.expressionFactory.createSimpleExpression(sb.toString(), false);
        Type<?> type = JpaUtils.getAttributeForJoining(this.metamodel, current.getNodeType(), expression, current.getAlias()).getAttributeType();
        return new JoinResult(current, resultFields, type);
    }

    private JoinNode joinMapKey(MapKeyExpression mapKeyExpression, String alias, ClauseType fromClause, String selectAlias, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch, boolean implicit, boolean defaultJoin) {
        this.implicitJoin((Expression)mapKeyExpression.getPath(), true, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false, fetch);
        JoinNode current = (JoinNode)mapKeyExpression.getPath().getBaseNode();
        String joinRelationName = "KEY(" + current.getParentTreeNode().getRelationName() + ")";
        MapAttribute mapAttribute = (MapAttribute)current.getParentTreeNode().getAttribute();
        MapKeyAttribute keyAttribute = new MapKeyAttribute(mapAttribute);
        String aliasToUse = alias == null ? current.getParentTreeNode().getRelationName().replaceAll("\\.", "_") + "_key" : alias;
        Type joinRelationType = this.metamodel.type(mapAttribute.getKeyJavaType());
        current = this.getOrCreate(current, joinRelationName, joinRelationType, null, aliasToUse, JoinType.LEFT, "Ambiguous implicit join", implicit, true, (Attribute<?, ?>)keyAttribute);
        return current;
    }

    private JoinNode joinMapEntry(MapEntryExpression mapEntryExpression, String alias, ClauseType fromClause, String selectAlias, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch, boolean implicit, boolean defaultJoin) {
        this.implicitJoin((Expression)mapEntryExpression.getPath(), true, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false, fetch);
        JoinNode current = (JoinNode)mapEntryExpression.getPath().getBaseNode();
        String joinRelationName = "ENTRY(" + current.getParentTreeNode().getRelationName() + ")";
        MapAttribute mapAttribute = (MapAttribute)current.getParentTreeNode().getAttribute();
        MapEntryAttribute entryAttribute = new MapEntryAttribute(mapAttribute);
        String aliasToUse = alias == null ? current.getParentTreeNode().getRelationName().replaceAll("\\.", "_") + "_entry" : alias;
        Type<Map.Entry> joinRelationType = this.metamodel.type(Map.Entry.class);
        current = this.getOrCreate(current, joinRelationName, joinRelationType, null, aliasToUse, JoinType.LEFT, "Ambiguous implicit join", implicit, true, (Attribute<?, ?>)entryAttribute);
        return current;
    }

    private JoinNode joinListIndex(ListIndexExpression listIndexExpression, String alias, ClauseType fromClause, String selectAlias, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch, boolean implicit, boolean defaultJoin) {
        this.implicitJoin((Expression)listIndexExpression.getPath(), true, null, fromClause, selectAlias, fromSubquery, fromSelectAlias, joinRequired, false, fetch);
        JoinNode current = (JoinNode)listIndexExpression.getPath().getBaseNode();
        String joinRelationName = "INDEX(" + current.getParentTreeNode().getRelationName() + ")";
        ListAttribute listAttribute = (ListAttribute)current.getParentTreeNode().getAttribute();
        ListIndexAttribute indexAttribute = new ListIndexAttribute(listAttribute);
        String aliasToUse = alias == null ? current.getParentTreeNode().getRelationName().replaceAll("\\.", "_") + "_index" : alias;
        Type<Integer> joinRelationType = this.metamodel.type(Integer.class);
        current = this.getOrCreate(current, joinRelationName, joinRelationType, null, aliasToUse, JoinType.LEFT, "Ambiguous implicit join", implicit, true, (Attribute<?, ?>)indexAttribute);
        return current;
    }

    private JoinResult implicitJoinSingle(JoinNode baseNode, String attributeName, boolean allowParentAliases) {
        if (baseNode == null) {
            AliasInfo aliasInfo;
            AliasInfo aliasInfo2 = aliasInfo = allowParentAliases ? this.aliasManager.getAliasInfo(attributeName) : this.aliasManager.getAliasInfoForBottomLevel(attributeName);
            if (aliasInfo != null && aliasInfo instanceof JoinAliasInfo) {
                JoinNode node = ((JoinAliasInfo)aliasInfo).getJoinNode();
                return new JoinResult(node, null, node.getNodeType());
            }
        }
        if (baseNode == null) {
            baseNode = this.getRootNodeOrFail("Ambiguous join path [", attributeName, "] because of multiple root nodes!");
        }
        return this.createOrUpdateNode(baseNode, Arrays.asList(attributeName), null, null, null, true, true);
    }

    private JoinResult implicitJoinSingle(JoinNode baseNode, String attributeName, boolean objectLeafAllowed, boolean joinRequired) {
        Type<?> type;
        String field;
        JoinNode newBaseNode;
        boolean lazy = false;
        Type<?> baseNodeType = baseNode.getNodeType();
        if (objectLeafAllowed) {
            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, baseNodeType, this.expressionFactory.createJoinPathExpression(attributeName), baseNode.getAlias());
            Attribute<?, ?> attr = attributeHolder.getAttribute();
            if (attr == null) {
                throw new IllegalArgumentException("Field with name '" + attributeName + "' was not found within managed type " + JpaMetamodelUtils.getTypeName(baseNodeType));
            }
            if (joinRequired || attr.isCollection()) {
                JoinResult newBaseNodeResult = this.implicitJoinSingle(baseNode, attributeName, false);
                newBaseNode = newBaseNodeResult.baseNode;
                if (newBaseNode != baseNode) {
                    field = null;
                    type = newBaseNode.getNodeType();
                } else {
                    field = attributeName;
                    type = attributeHolder.getAttributeType();
                }
            } else {
                newBaseNode = baseNode;
                field = attributeName;
                type = attributeHolder.getAttributeType();
                lazy = true;
            }
        } else {
            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, baseNodeType, this.expressionFactory.createJoinPathExpression(attributeName), baseNode.getAlias());
            Attribute<?, ?> attr = attributeHolder.getAttribute();
            if (attr == null) {
                throw new IllegalArgumentException("Field with name " + attributeName + " was not found within class " + JpaMetamodelUtils.getTypeName(baseNodeType));
            }
            if (JpaMetamodelUtils.isJoinable(attr)) {
                throw new IllegalArgumentException("No object leaf allowed but " + attributeName + " is an object leaf");
            }
            newBaseNode = baseNode;
            field = attributeName;
            type = attributeHolder.getAttributeType();
        }
        return new JoinResult(newBaseNode, field == null ? null : Arrays.asList(field), type, lazy);
    }

    private void updateClauseDependencies(JoinNode baseNode, ClauseType clauseDependency, Set<JoinNode> seenNodes) {
        if (!seenNodes.add(baseNode)) {
            StringBuilder errorSb = new StringBuilder();
            errorSb.append("Cyclic join dependency between nodes: ");
            for (JoinNode seenNode : seenNodes) {
                errorSb.append(seenNode.getAliasInfo().getAlias());
                if (seenNode.getAliasInfo().isImplicit()) {
                    errorSb.append('(').append(seenNode.getAliasInfo().getAbsolutePath()).append(')');
                }
                errorSb.append(" -> ");
            }
            errorSb.setLength(errorSb.length() - 4);
            throw new IllegalStateException(errorSb.toString());
        }
        for (JoinNode current = baseNode; current != null; current = current.getParent()) {
            for (JoinNode dependency : current.getDependencies()) {
                this.updateClauseDependencies(dependency, clauseDependency, seenNodes);
            }
            current.getClauseDependencies().add(clauseDependency);
            if (current.getDependencies().contains(current.getParent())) break;
        }
        seenNodes.remove(baseNode);
    }

    private JoinType getModelAwareType(JoinNode baseNode, Attribute<?, ?> attr) {
        if (baseNode.getJoinType() == JoinType.LEFT) {
            return JoinType.LEFT;
        }
        if (!(attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE && attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE || ((SingularAttribute)attr).isOptional())) {
            return JoinType.INNER;
        }
        return JoinType.LEFT;
    }

    private JoinResult createOrUpdateNode(JoinNode baseNode, List<String> joinRelationAttributes, String treatType, String alias, JoinType joinType, boolean implicit, boolean defaultJoin) {
        String joinRelationName;
        Type<?> baseNodeType = baseNode.getNodeType();
        AttributeHolder attrJoinResult = JpaUtils.getAttributeForJoining(this.metamodel, baseNodeType, this.expressionFactory.createJoinPathExpression(joinRelationName = StringUtils.join((CharSequence)".", joinRelationAttributes)), baseNode.getAlias());
        Attribute<?, ?> attr = attrJoinResult.getAttribute();
        if (attr == null) {
            throw new IllegalArgumentException("Field with name " + joinRelationName + " was not found within class " + JpaMetamodelUtils.getTypeName(baseNodeType));
        }
        if (!JpaMetamodelUtils.isJoinable(attr)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Field with name " + joinRelationName + " of class " + JpaMetamodelUtils.getTypeName(baseNodeType) + " is parseable and therefore it has not to be fetched explicitly.");
            }
            return new JoinResult(baseNode, joinRelationAttributes, attrJoinResult.getAttributeType());
        }
        if (implicit) {
            String aliasToUse = alias == null ? attr.getName() : alias;
            alias = this.aliasManager.generateJoinAlias(aliasToUse);
        }
        if (joinType == null) {
            joinType = this.getModelAwareType(baseNode, attr);
        }
        Type<?> joinRelationType = attrJoinResult.getAttributeType();
        JoinNode newNode = this.getOrCreate(baseNode, joinRelationName, joinRelationType, treatType, alias, joinType, "Ambiguous implicit join", implicit, defaultJoin, attr);
        return new JoinResult(newNode, null, newNode.getNodeType());
    }

    private void checkAliasIsAvailable(String alias, String currentJoinPath, String errorMessage) {
        AliasInfo oldAliasInfo = this.aliasManager.getAliasInfoForBottomLevel(alias);
        if (oldAliasInfo instanceof SelectInfo) {
            throw new IllegalStateException("Alias [" + oldAliasInfo.getAlias() + "] already used as select alias");
        }
        JoinAliasInfo oldJoinAliasInfo = (JoinAliasInfo)oldAliasInfo;
        if (oldJoinAliasInfo != null) {
            if (!oldJoinAliasInfo.getAbsolutePath().equals(currentJoinPath)) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new RuntimeException("Probably a programming error if this happens. An alias[" + alias + "] for the same join path[" + currentJoinPath + "] is available but the join node is not!");
        }
    }

    private JoinNode getOrCreate(JoinNode baseNode, String joinRelationName, Type<?> joinRelationType, String treatType, String alias, JoinType type, String errorMessage, boolean implicit, boolean defaultJoin, Attribute<?, ?> attribute) {
        String currentJoinPath;
        EntityType<?> treatJoinType;
        String qualifiedJoinPath;
        JoinTreeNode treeNode = baseNode.getOrCreateTreeNode(joinRelationName, attribute);
        JoinNode node = treeNode.getJoinNode(alias, defaultJoin);
        String qualificationExpression = null;
        if (attribute instanceof QualifiedAttribute) {
            QualifiedAttribute qualifiedAttribute = (QualifiedAttribute)attribute;
            qualificationExpression = qualifiedAttribute.getQualificationExpression();
            qualifiedJoinPath = joinRelationName.substring(0, qualificationExpression.length() + 1) + baseNode.getAliasInfo().getAbsolutePath() + "." + joinRelationName.substring(qualificationExpression.length() + 1);
        } else {
            qualifiedJoinPath = baseNode.getAliasInfo().getAbsolutePath() + "." + joinRelationName;
        }
        if (treatType != null) {
            treatJoinType = this.metamodel.getEntity(treatType);
            currentJoinPath = "TREAT(" + qualifiedJoinPath + " AS " + treatJoinType.getName() + ")";
        } else {
            treatJoinType = null;
            currentJoinPath = qualifiedJoinPath;
        }
        if (node == null) {
            this.checkAliasIsAvailable(alias, currentJoinPath, errorMessage);
            if (implicit && this.aliasManager.getAliasInfo(alias) != null) {
                alias = this.aliasManager.generateJoinAlias(alias);
            }
            JoinAliasInfo newAliasInfo = new JoinAliasInfo(alias, currentJoinPath, implicit, false, this.aliasManager);
            this.aliasManager.registerAliasInfo(newAliasInfo);
            node = JoinNode.createAssociationJoinNode(baseNode, treeNode, type, joinRelationType, treatJoinType, qualificationExpression, newAliasInfo);
            newAliasInfo.setJoinNode(node);
            treeNode.addJoinNode(node, defaultJoin);
        } else {
            JoinAliasInfo nodeAliasInfo = node.getAliasInfo();
            if (!alias.equals(nodeAliasInfo.getAlias())) {
                if (nodeAliasInfo.isImplicit() && !implicit) {
                    this.aliasManager.unregisterAliasInfoForBottomLevel(nodeAliasInfo);
                    nodeAliasInfo.setAlias(alias);
                    nodeAliasInfo.setImplicit(false);
                    node.setJoinType(type);
                    this.aliasManager.registerAliasInfo(nodeAliasInfo);
                } else if (!nodeAliasInfo.isImplicit() && !implicit) {
                    throw new IllegalArgumentException("Alias conflict [" + nodeAliasInfo.getAlias() + "=" + nodeAliasInfo.getAbsolutePath() + ", " + alias + "=" + currentJoinPath + "]");
                }
            }
            if (treatJoinType != null) {
                if (node.getTreatType() == null) {
                    node = node.getTreatedJoinNode(treatJoinType);
                } else if (!treatJoinType.equals(node.getTreatType())) {
                    throw new IllegalArgumentException("A join node [" + nodeAliasInfo.getAlias() + "=" + nodeAliasInfo.getAbsolutePath() + "] for treat type [" + treatType + "] conflicts with the existing treat type [" + node.getTreatType() + "]");
                }
            }
        }
        return node;
    }

    private JoinNode findNode(JoinNode baseNode, String joinRelationName, ArrayExpression arrayExpression) {
        JoinTreeNode treeNode = baseNode.getNodes().get(joinRelationName);
        if (treeNode == null) {
            return null;
        }
        for (JoinNode node : treeNode.getJoinNodes().values()) {
            EqPredicate pred = this.getArrayExpressionPredicate(node, arrayExpression);
            CompoundPredicate compoundPredicate = node.getOnPredicate();
            if (!this.findPredicate(compoundPredicate, (Predicate)pred)) continue;
            return node;
        }
        return null;
    }

    private boolean findPredicate(CompoundPredicate compoundPredicate, Predicate pred) {
        if (compoundPredicate != null) {
            List children = compoundPredicate.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (!pred.equals(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void fetchPath(JoinNode node) {
        node.setFetch(true);
        node.getClauseDependencies().add(ClauseType.SELECT);
    }

    private class JoinOnBuilderEndedListener
    extends PredicateBuilderEndedListenerImpl {
        private JoinNode joinNode;

        private JoinOnBuilderEndedListener() {
        }

        @Override
        public void onBuilderEnded(PredicateBuilder builder) {
            super.onBuilderEnded(builder);
            Predicate predicate = builder.getPredicate();
            predicate.accept((Expression.Visitor)new VisitorAdapter(){
                private boolean isKeyFunction;

                public void visit(ListIndexExpression expression) {
                    boolean old = this.isKeyFunction;
                    this.isKeyFunction = true;
                    super.visit(expression);
                    this.isKeyFunction = old;
                }

                public void visit(MapKeyExpression expression) {
                    boolean old = this.isKeyFunction;
                    this.isKeyFunction = true;
                    super.visit(expression);
                    this.isKeyFunction = old;
                }

                public void visit(PathExpression expression) {
                    expression.setCollectionKeyPath(this.isKeyFunction);
                    super.visit(expression);
                }
            });
            this.joinNode.setOnPredicate((CompoundPredicate)predicate);
        }
    }

    private static class JoinResult {
        final JoinNode baseNode;
        final List<String> fields;
        final Type<?> type;
        final boolean lazy;

        public JoinResult(JoinNode baseNode, List<String> fields, Type<?> type) {
            this.baseNode = baseNode;
            this.fields = fields;
            this.type = type;
            this.lazy = false;
        }

        public JoinResult(JoinNode baseNode, List<String> fields, Type<?> type, boolean lazy) {
            this.baseNode = baseNode;
            this.fields = fields;
            this.type = type;
            this.lazy = lazy;
        }

        private boolean hasField() {
            return this.fields != null && !this.fields.isEmpty();
        }

        private String joinFields(String field) {
            if (this.fields == null || this.fields.isEmpty()) {
                return field;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.fields.get(0));
            for (int i = 1; i < this.fields.size(); ++i) {
                sb.append('.');
                sb.append(this.fields.get(i));
            }
            if (field != null) {
                sb.append('.');
                sb.append(field);
            }
            return sb.toString();
        }

        private String joinFields() {
            return this.joinFields(null);
        }

        private List<String> addToList(List<String> resultFields) {
            if (this.hasField() && resultFields != this.fields) {
                resultFields.addAll(this.fields);
            }
            return resultFields;
        }

        private boolean isLazy() {
            return this.lazy;
        }
    }

    private static class LazyPathReference
    implements PathReference,
    Path {
        private final JoinNode baseNode;
        private final String field;
        private final Type<?> type;

        public LazyPathReference(JoinNode baseNode, String field, Type<?> type) {
            this.baseNode = baseNode;
            this.field = field;
            this.type = type;
        }

        public JoinNode getBaseNode() {
            JoinTreeNode subNode = this.baseNode.getNodes().get(this.field);
            if (subNode != null && subNode.getDefaultNode() != null) {
                return subNode.getDefaultNode();
            }
            return this.baseNode;
        }

        public String getField() {
            JoinTreeNode subNode = this.baseNode.getNodes().get(this.field);
            if (subNode != null && subNode.getDefaultNode() != null) {
                return null;
            }
            return this.field;
        }

        public Type<?> getType() {
            return this.type;
        }

        public From getFrom() {
            return this.getBaseNode();
        }

        public String getPath() {
            StringBuilder sb = new StringBuilder();
            this.getBaseNode().appendDeReference(sb, this.getField());
            return sb.toString();
        }

        public Class<?> getJavaType() {
            return this.type.getJavaType();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseNode == null ? 0 : this.baseNode.hashCode());
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PathReference)) {
                return false;
            }
            PathReference other = (PathReference)obj;
            if (this.baseNode == null ? other.getBaseNode() != null : !this.baseNode.equals(other.getBaseNode())) {
                return false;
            }
            return !(this.field == null ? other.getField() != null : !this.field.equals(other.getField()));
        }
    }

    static class SimpleValueRetriever
    implements ValueRetriever<Object, Object> {
        SimpleValueRetriever() {
        }

        public Object getValue(Object target) {
            return target;
        }
    }

    static class KeyRestrictedLeftJoinCollectingVisitor
    extends VisitorAdapter
    implements JoinNodeVisitor {
        final JpaProvider jpaProvider;
        final Set<JoinNode> keyRestrictedLeftJoins;

        public KeyRestrictedLeftJoinCollectingVisitor(JpaProvider jpaProvider, Set<JoinNode> keyRestrictedLeftJoins) {
            this.jpaProvider = jpaProvider;
            this.keyRestrictedLeftJoins = keyRestrictedLeftJoins;
        }

        @Override
        public void visit(JoinNode node) {
            if (node.getJoinType() == JoinType.LEFT && node.getOnPredicate() != null) {
                node.getOnPredicate().accept((Expression.Visitor)this);
            }
        }

        public void visit(MapKeyExpression expression) {
            super.visit(expression);
            this.visitKeyOrIndexExpression(expression.getPath());
        }

        public void visit(ListIndexExpression expression) {
            super.visit(expression);
            this.visitKeyOrIndexExpression(expression.getPath());
        }

        private void visitKeyOrIndexExpression(PathExpression pathExpression) {
            JoinNode node = (JoinNode)pathExpression.getBaseNode();
            Attribute<?, ?> attribute = node.getParentTreeNode().getAttribute();
            if (attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.ELEMENT_COLLECTION && this.jpaProvider.getJoinTable(node.getParent().getEntityType(), attribute.getName()) != null) {
                this.keyRestrictedLeftJoins.add(node);
            }
        }
    }
}

