/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.From;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.AbortableResultJoinNodeVisitor;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.TreatedJoinAliasInfo;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.expression.BaseNode;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;

public class JoinNode
implements From,
ExpressionModifier,
BaseNode {
    private JoinType joinType = JoinType.LEFT;
    private boolean fetch = false;
    private final EnumSet<ClauseType> clauseDependencies = EnumSet.noneOf(ClauseType.class);
    private final JoinNode parent;
    private final JoinTreeNode parentTreeNode;
    private final JoinNode correlationParent;
    private final String correlationPath;
    private final Type<?> nodeType;
    private final EntityType<?> treatType;
    private final String valuesTypeName;
    private final int valueCount;
    private final String valuesIdName;
    private final Query valueQuery;
    private final String valuesClause;
    private final String valuesAliases;
    private final String qualificationExpression;
    private final JoinAliasInfo aliasInfo;
    private final List<JoinNode> joinNodesForTreatConstraint;
    private final Map<String, JoinTreeNode> nodes = new TreeMap<String, JoinTreeNode>();
    private final Map<String, JoinNode> treatedJoinNodes = new TreeMap<String, JoinNode>();
    private final Set<JoinNode> entityJoinNodes = new LinkedHashSet<JoinNode>();
    private final Set<JoinNode> dependencies = new HashSet<JoinNode>();
    private CompoundPredicate onPredicate;
    private boolean dirty = true;
    private boolean cardinalityMandatory;

    private JoinNode(TreatedJoinAliasInfo treatedJoinAliasInfo) {
        JoinNode treatedJoinNode = treatedJoinAliasInfo.getTreatedJoinNode();
        this.parent = treatedJoinNode.parent;
        this.parentTreeNode = treatedJoinNode.parentTreeNode;
        this.joinType = treatedJoinNode.joinType;
        this.correlationParent = treatedJoinNode.correlationParent;
        this.correlationPath = treatedJoinNode.correlationPath;
        this.nodeType = treatedJoinNode.nodeType;
        this.treatType = treatedJoinAliasInfo.getTreatType();
        this.qualificationExpression = treatedJoinNode.qualificationExpression;
        this.valuesTypeName = treatedJoinNode.valuesTypeName;
        this.valueCount = treatedJoinNode.valueCount;
        this.valuesIdName = treatedJoinNode.valuesIdName;
        this.valueQuery = treatedJoinNode.valueQuery;
        this.valuesClause = treatedJoinNode.valuesClause;
        this.valuesAliases = treatedJoinNode.valuesAliases;
        this.aliasInfo = treatedJoinAliasInfo;
        ArrayList<JoinNode> joinNodesForTreatConstraint = new ArrayList<JoinNode>(treatedJoinNode.joinNodesForTreatConstraint.size() + 1);
        joinNodesForTreatConstraint.addAll(treatedJoinNode.joinNodesForTreatConstraint);
        joinNodesForTreatConstraint.add(this);
        this.joinNodesForTreatConstraint = Collections.unmodifiableList(joinNodesForTreatConstraint);
    }

    private JoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinType joinType, JoinNode correlationParent, String correlationPath, Type<?> nodeType, EntityType<?> treatType, String qualificationExpression, JoinAliasInfo aliasInfo) {
        this.parent = parent;
        this.parentTreeNode = parentTreeNode;
        this.joinType = joinType;
        this.correlationParent = correlationParent;
        this.correlationPath = correlationPath;
        this.nodeType = nodeType;
        this.treatType = treatType;
        this.valuesTypeName = null;
        this.valueCount = 0;
        this.valuesIdName = null;
        this.valueQuery = null;
        this.valuesClause = null;
        this.valuesAliases = null;
        this.qualificationExpression = qualificationExpression;
        this.aliasInfo = aliasInfo;
        if (treatType != null) {
            if (parent != null) {
                ArrayList<JoinNode> joinNodesForTreatConstraint = new ArrayList<JoinNode>(parent.joinNodesForTreatConstraint.size() + 1);
                joinNodesForTreatConstraint.addAll(parent.joinNodesForTreatConstraint);
                joinNodesForTreatConstraint.add(this);
                this.joinNodesForTreatConstraint = Collections.unmodifiableList(joinNodesForTreatConstraint);
            } else {
                this.joinNodesForTreatConstraint = Collections.singletonList(this);
            }
        } else {
            this.joinNodesForTreatConstraint = parent != null ? parent.joinNodesForTreatConstraint : Collections.emptyList();
        }
        this.onUpdate(null);
    }

    private JoinNode(ManagedType<?> nodeType, String valuesTypeName, int valueCount, String valuesIdName, Query valueQuery, String valuesClause, String valuesAliases, JoinAliasInfo aliasInfo) {
        this.parent = null;
        this.parentTreeNode = null;
        this.joinType = null;
        this.correlationParent = null;
        this.correlationPath = null;
        this.nodeType = nodeType;
        this.treatType = null;
        this.valuesTypeName = valuesTypeName;
        this.valueCount = valueCount;
        this.valuesIdName = valuesIdName;
        this.valueQuery = valueQuery;
        this.valuesClause = valuesClause;
        this.valuesAliases = valuesAliases;
        this.qualificationExpression = null;
        this.aliasInfo = aliasInfo;
        this.joinNodesForTreatConstraint = Collections.emptyList();
        this.onUpdate(null);
    }

    public static JoinNode createRootNode(EntityType<?> nodeType, JoinAliasInfo aliasInfo) {
        return new JoinNode(null, null, null, null, null, (Type<?>)nodeType, null, null, aliasInfo);
    }

    public static JoinNode createValuesRootNode(ManagedType<?> nodeType, String valuesTypeName, int valueCount, String valuesIdName, Query valueQuery, String valuesClause, String valuesAliases, JoinAliasInfo aliasInfo) {
        return new JoinNode(nodeType, valuesTypeName, valueCount, valuesIdName, valueQuery, valuesClause, valuesAliases, aliasInfo);
    }

    public static JoinNode createCorrelationRootNode(JoinNode correlationParent, String correlationPath, Type<?> nodeType, EntityType<?> treatType, JoinAliasInfo aliasInfo) {
        return new JoinNode(null, null, null, correlationParent, correlationPath, nodeType, treatType, null, aliasInfo);
    }

    public static JoinNode createEntityJoinNode(JoinNode parent, JoinType joinType, EntityType<?> nodeType, JoinAliasInfo aliasInfo) {
        return new JoinNode(parent, null, joinType, null, null, (Type<?>)nodeType, null, null, aliasInfo);
    }

    public static JoinNode createAssociationJoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinType joinType, Type<?> nodeType, EntityType<?> treatType, String qualificationExpression, JoinAliasInfo aliasInfo) {
        return new JoinNode(parent, parentTreeNode, joinType, null, null, nodeType, treatType, qualificationExpression, aliasInfo);
    }

    public JoinNode cloneRootNode(JoinAliasInfo aliasInfo) {
        JoinNode newNode;
        if (this.valueQuery != null) {
            newNode = JoinNode.createValuesRootNode((ManagedType)this.nodeType, this.valuesTypeName, this.valueCount, this.valuesIdName, this.valueQuery, this.valuesClause, this.valuesAliases, aliasInfo);
        } else if (this.joinType == null) {
            newNode = JoinNode.createRootNode((EntityType)this.nodeType, aliasInfo);
        } else {
            throw new UnsupportedOperationException("Cloning subqueries not yet implemented!");
        }
        return newNode;
    }

    public JoinNode cloneJoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinAliasInfo aliasInfo) {
        JoinNode newNode = parentTreeNode == null ? JoinNode.createEntityJoinNode(parent, this.joinType, (EntityType)this.nodeType, aliasInfo) : JoinNode.createAssociationJoinNode(parent, parentTreeNode, this.joinType, this.nodeType, this.treatType, this.qualificationExpression, aliasInfo);
        newNode.fetch = this.fetch;
        return newNode;
    }

    private void onUpdate(StateChange stateChange) {
        if (this.cardinalityMandatory && stateChange != StateChange.JOIN_TYPE) {
            return;
        }
        this.dirty = true;
        if (this.parent != null) {
            this.parent.onUpdate(StateChange.CHILD);
        }
    }

    public boolean isCardinalityMandatory() {
        if (this.dirty) {
            this.updateCardinalityMandatory();
            this.dirty = false;
        }
        return this.cardinalityMandatory;
    }

    private void updateCardinalityMandatory() {
        boolean computedMandatory = false;
        if (this.joinType == JoinType.INNER) {
            if (this.parentTreeNode == null || this.parentTreeNode.isOptional() || !this.isEmptyCondition()) {
                computedMandatory = true;
            }
        } else if (this.joinType == JoinType.LEFT) {
            if (!this.isEmptyCondition() && !this.isArrayExpressionCondition()) {
                computedMandatory = true;
            }
            block0: for (Map.Entry<String, JoinTreeNode> nodeEntry : this.nodes.entrySet()) {
                JoinTreeNode treeNode = nodeEntry.getValue();
                for (JoinNode childNode : treeNode.getJoinNodes().values()) {
                    if (!childNode.isCardinalityMandatory()) continue;
                    computedMandatory = true;
                    break block0;
                }
            }
        }
        if (computedMandatory != this.cardinalityMandatory) {
            this.cardinalityMandatory = computedMandatory;
        }
    }

    private boolean isEmptyCondition() {
        return this.onPredicate == null || this.onPredicate.getChildren().isEmpty();
    }

    private boolean isArrayExpressionCondition() {
        if (this.onPredicate == null || this.onPredicate.getChildren().size() != 1) {
            return false;
        }
        Predicate predicate = (Predicate)this.onPredicate.getChildren().get(0);
        if (!(predicate instanceof EqPredicate)) {
            return false;
        }
        EqPredicate eqPredicate = (EqPredicate)predicate;
        Expression left = eqPredicate.getLeft();
        if (left instanceof MapKeyExpression) {
            return this.equals(((MapKeyExpression)left).getPath().getBaseNode());
        }
        if (left instanceof ListIndexExpression) {
            return this.equals(((ListIndexExpression)left).getPath().getBaseNode());
        }
        return false;
    }

    public void registerDependencies() {
        if (this.onPredicate != null) {
            this.onPredicate.accept((Expression.Visitor)new VisitorAdapter(){

                public void visit(PathExpression pathExpr) {
                    JoinNode baseNode = (JoinNode)pathExpr.getBaseNode();
                    if (baseNode != null && baseNode != JoinNode.this && (baseNode.getQualificationExpression() == null || baseNode.parent != JoinNode.this)) {
                        JoinNode.this.dependencies.add(baseNode);
                    }
                }
            });
        }
    }

    public void set(Expression expression) {
        if (!(expression instanceof CompoundPredicate)) {
            throw new IllegalArgumentException("Expected compound predicate but was given: " + expression);
        }
        this.onPredicate = (CompoundPredicate)expression;
    }

    public Expression get() {
        return this.onPredicate;
    }

    public void accept(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        if (this.onPredicate != null) {
            visitor.visit(this, ClauseType.JOIN);
        }
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                joinNode.accept(visitor);
            }
        }
        for (JoinNode joinNode : this.entityJoinNodes) {
            joinNode.accept(visitor);
        }
        for (JoinNode joinNode : this.treatedJoinNodes.values()) {
            joinNode.accept(visitor);
        }
    }

    public void accept(JoinNodeVisitor visitor) {
        visitor.visit(this);
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                joinNode.accept(visitor);
            }
        }
        for (JoinNode joinNode : this.entityJoinNodes) {
            joinNode.accept(visitor);
        }
        for (JoinNode joinNode : this.treatedJoinNodes.values()) {
            joinNode.accept(visitor);
        }
    }

    public <T> T accept(AbortableResultJoinNodeVisitor<T> visitor) {
        Object result = visitor.visit(this);
        if (visitor.getStopValue().equals(result)) {
            return result;
        }
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                result = joinNode.accept(visitor);
                if (!visitor.getStopValue().equals(result)) continue;
                return result;
            }
        }
        for (JoinNode joinNode : this.entityJoinNodes) {
            result = joinNode.accept(visitor);
            if (!visitor.getStopValue().equals(result)) continue;
            return result;
        }
        for (JoinNode joinNode : this.treatedJoinNodes.values()) {
            result = joinNode.accept(visitor);
            if (!visitor.getStopValue().equals(result)) continue;
            return result;
        }
        return result;
    }

    public JoinNode getTreatedJoinNode(EntityType<?> type) {
        String typeName = type.getJavaType().getName();
        JoinNode treatedNode = this.treatedJoinNodes.get(typeName);
        if (treatedNode != null) {
            return treatedNode;
        }
        TreatedJoinAliasInfo treatedJoinAliasInfo = new TreatedJoinAliasInfo(this, type);
        treatedNode = new JoinNode(treatedJoinAliasInfo);
        treatedJoinAliasInfo.setJoinNode(treatedNode);
        this.treatedJoinNodes.put(typeName, treatedNode);
        return treatedNode;
    }

    public EnumSet<ClauseType> getClauseDependencies() {
        return this.clauseDependencies;
    }

    public JoinTreeNode getParentTreeNode() {
        return this.parentTreeNode;
    }

    public JoinNode getParent() {
        return this.parent;
    }

    public JoinAliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
        this.onUpdate(StateChange.JOIN_TYPE);
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public Map<String, JoinTreeNode> getNodes() {
        return this.nodes;
    }

    public Map<String, JoinNode> getTreatedJoinNodes() {
        return this.treatedJoinNodes;
    }

    public JoinTreeNode getOrCreateTreeNode(String joinRelationName, Attribute<?, ?> attribute) {
        JoinTreeNode node = this.nodes.get(joinRelationName);
        if (node == null) {
            node = new JoinTreeNode(joinRelationName, attribute);
            this.nodes.put(joinRelationName, node);
        }
        return node;
    }

    public Set<JoinNode> getEntityJoinNodes() {
        return this.entityJoinNodes;
    }

    public void addEntityJoin(JoinNode entityJoinNode) {
        this.entityJoinNodes.add(entityJoinNode);
    }

    public Type<?> getNodeType() {
        if (this.treatType != null) {
            return this.treatType;
        }
        return this.nodeType;
    }

    public EntityType<?> getEntityType() {
        if (this.treatType != null) {
            return this.treatType;
        }
        if (this.nodeType instanceof EntityType) {
            return (EntityType)this.nodeType;
        }
        throw new IllegalArgumentException("Expected type of join node to be an entity but isn't: " + JpaMetamodelUtils.getTypeName(this.nodeType));
    }

    public ManagedType<?> getManagedType() {
        if (this.treatType != null) {
            return this.treatType;
        }
        if (this.nodeType instanceof ManagedType) {
            return (ManagedType)this.nodeType;
        }
        throw new IllegalArgumentException("Expected type of join node to be a managed type but isn't: " + JpaMetamodelUtils.getTypeName(this.nodeType));
    }

    public Type<?> getBaseType() {
        return this.nodeType;
    }

    public EntityType<?> getTreatType() {
        return this.treatType;
    }

    public boolean isTreatJoinNode() {
        return this.treatType != null && !(this.aliasInfo instanceof TreatedJoinAliasInfo);
    }

    public boolean isTreatedJoinNode() {
        return this.treatType != null && this.aliasInfo instanceof TreatedJoinAliasInfo;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public String getValuesIdName() {
        return this.valuesIdName;
    }

    public Query getValueQuery() {
        return this.valueQuery;
    }

    public String getValuesClause() {
        return this.valuesClause;
    }

    public String getValuesAliases() {
        return this.valuesAliases;
    }

    String getValuesTypeName() {
        return this.valuesTypeName;
    }

    public JoinNode getCorrelationParent() {
        return this.correlationParent;
    }

    public String getCorrelationPath() {
        return this.correlationPath;
    }

    public CompoundPredicate getOnPredicate() {
        return this.onPredicate;
    }

    public void setOnPredicate(CompoundPredicate onPredicate) {
        this.onPredicate = onPredicate;
        this.onUpdate(StateChange.ON_PREDICATE);
    }

    public Set<JoinNode> getDependencies() {
        return this.dependencies;
    }

    public boolean hasCollections() {
        if (!this.entityJoinNodes.isEmpty()) {
            return true;
        }
        ArrayList<JoinTreeNode> stack = new ArrayList<JoinTreeNode>();
        stack.addAll(this.nodes.values());
        for (JoinNode node : this.entityJoinNodes) {
            stack.addAll(node.getNodes().values());
        }
        for (JoinNode node : this.treatedJoinNodes.values()) {
            stack.addAll(node.getNodes().values());
        }
        while (!stack.isEmpty()) {
            JoinTreeNode treeNode = (JoinTreeNode)stack.remove(stack.size() - 1);
            if (treeNode.isCollection()) {
                return true;
            }
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                stack.addAll(joinNode.nodes.values());
            }
        }
        return false;
    }

    Set<JoinNode> getCollectionJoins() {
        HashSet<JoinNode> collectionJoins = new HashSet<JoinNode>();
        ArrayList<JoinTreeNode> stack = new ArrayList<JoinTreeNode>();
        stack.addAll(this.nodes.values());
        for (JoinNode node : this.entityJoinNodes) {
            stack.addAll(node.getNodes().values());
        }
        for (JoinNode node : this.treatedJoinNodes.values()) {
            stack.addAll(node.getNodes().values());
        }
        collectionJoins.addAll(this.entityJoinNodes);
        while (!stack.isEmpty()) {
            JoinTreeNode treeNode = (JoinTreeNode)stack.remove(stack.size() - 1);
            if (treeNode.isCollection()) {
                collectionJoins.addAll(treeNode.getJoinNodes().values());
            }
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                stack.addAll(joinNode.nodes.values());
            }
        }
        return collectionJoins;
    }

    List<JoinNode> getJoinNodesForTreatConstraint() {
        return this.joinNodesForTreatConstraint;
    }

    public String getQualificationExpression() {
        return this.qualificationExpression;
    }

    public boolean isQualifiedJoin() {
        return this.qualificationExpression != null;
    }

    public Expression createExpression(String field) {
        ArrayList<Object> pathElements = new ArrayList<Object>();
        if (this.qualificationExpression != null) {
            PathExpression path = new PathExpression(Collections.singletonList(new PropertyExpression(this.parent.getAlias())));
            if ("KEY".equalsIgnoreCase(this.qualificationExpression)) {
                pathElements.add(new MapKeyExpression(path));
            } else if ("INDEX".equalsIgnoreCase(this.qualificationExpression)) {
                pathElements.add(new ListIndexExpression(path));
            } else if ("ENTRY".equalsIgnoreCase(this.qualificationExpression)) {
                pathElements.add(new MapEntryExpression(path));
            }
        } else {
            pathElements.add(new PropertyExpression(this.aliasInfo.getAlias()));
        }
        if (field != null) {
            for (String fieldPart : field.split("\\.")) {
                pathElements.add(new PropertyExpression(fieldPart));
            }
        }
        if (this.valuesTypeName != null) {
            return new FunctionExpression("FUNCTION", Arrays.asList(new StringLiteral("TREAT_" + this.valuesTypeName.toUpperCase()), new PathExpression(pathElements)));
        }
        return new PathExpression(pathElements);
    }

    public void appendDeReference(StringBuilder sb, String property) {
        this.appendDeReference(sb, property, false);
    }

    public void appendDeReference(StringBuilder sb, String property, boolean renderTreat) {
        this.appendAlias(sb, renderTreat);
        if (property != null && this.valuesTypeName == null) {
            sb.append('.').append(property);
        }
    }

    public void appendAlias(StringBuilder sb) {
        this.appendAlias(sb, false);
    }

    public void appendAlias(StringBuilder sb, boolean renderTreat) {
        if (this.valuesTypeName != null) {
            sb.append("TREAT_");
            sb.append(this.valuesTypeName.toUpperCase()).append('(');
            sb.append(this.aliasInfo.getAlias());
            sb.append(".value");
            sb.append(')');
        } else if (this.qualificationExpression != null) {
            boolean hasTreat;
            boolean bl = hasTreat = renderTreat && this.treatType != null;
            if (hasTreat) {
                sb.append("TREAT(");
            }
            sb.append(this.qualificationExpression);
            sb.append('(');
            if (renderTreat) {
                this.parent.getAliasInfo().render(sb);
            } else {
                sb.append(this.parent.getAlias());
            }
            sb.append(')');
            if (hasTreat) {
                sb.append(" AS ");
                sb.append(this.treatType.getName());
                sb.append(')');
            }
        } else if (renderTreat) {
            this.aliasInfo.render(sb);
        } else {
            sb.append(this.aliasInfo.getAlias());
        }
    }

    public String getAlias() {
        return this.aliasInfo.getAlias();
    }

    public Type<?> getType() {
        return this.getNodeType();
    }

    public Class<?> getJavaType() {
        if (this.treatType != null) {
            return this.treatType.getJavaType();
        }
        return this.nodeType.getJavaType();
    }

    public int getJoinDepth() {
        int i = 0;
        JoinNode joinNode = this;
        while ((joinNode = joinNode.getParent()) != null) {
            ++i;
        }
        return i;
    }

    private static enum StateChange {
        JOIN_TYPE,
        ON_PREDICATE,
        CHILD;

    }
}

