/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.spi.ExtendedManagedType;
import java.util.List;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Type;

public class JoinVisitor
extends VisitorAdapter
implements SelectInfoVisitor {
    private final AssociationParameterTransformerFactory parameterTransformerFactory;
    private final EntityMetamodelImpl metamodel;
    private final JoinVisitor parentVisitor;
    private final JoinManager joinManager;
    private final ParameterManager parameterManager;
    private final boolean needsSingleValuedAssociationIdRemoval;
    private boolean joinRequired;
    private boolean joinWithObjectLeafAllowed = true;
    private ClauseType fromClause;
    private String selectAlias;

    public JoinVisitor(MainQuery mainQuery, JoinVisitor parentVisitor, JoinManager joinManager, ParameterManager parameterManager, boolean needsSingleValuedAssociationIdRemoval) {
        this.parameterTransformerFactory = mainQuery.parameterTransformerFactory;
        this.metamodel = mainQuery.metamodel;
        this.parentVisitor = parentVisitor;
        this.joinManager = joinManager;
        this.parameterManager = parameterManager;
        this.needsSingleValuedAssociationIdRemoval = needsSingleValuedAssociationIdRemoval;
        this.joinRequired = true;
    }

    public ClauseType getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(ClauseType fromClause) {
        this.fromClause = fromClause;
    }

    public void visit(PathExpression expression) {
        this.visit(expression, false);
    }

    private void visit(PathExpression expression, boolean idRemovable) {
        Expression aliasedExpression = this.joinManager.getJoinableSelectAlias(expression, this.fromClause == ClauseType.SELECT, false);
        if (aliasedExpression != null) {
            aliasedExpression.accept((Expression.Visitor)this);
        } else {
            JoinNode baseNode;
            AliasManager aliasOwner;
            this.joinManager.implicitJoin((Expression)expression, this.joinWithObjectLeafAllowed, null, this.fromClause, this.selectAlias, false, false, this.joinRequired, idRemovable);
            if (this.parentVisitor != null && (aliasOwner = (baseNode = (JoinNode)expression.getBaseNode()).getAliasInfo().getAliasOwner()) != this.joinManager.getAliasManager()) {
                this.parentVisitor.addClauseDependencies(baseNode, aliasOwner);
            }
        }
    }

    private void addClauseDependencies(JoinNode node, AliasManager aliasOwner) {
        if (aliasOwner != this.joinManager.getAliasManager()) {
            if (this.parentVisitor == null) {
                throw new IllegalStateException("Couldn't update clause dependencies because implicit joined node does not seem to belong to the query: " + node);
            }
            this.parentVisitor.addClauseDependencies(node, aliasOwner);
        } else {
            node.getClauseDependencies().add(this.fromClause);
        }
    }

    public void visit(TreatExpression expression) {
        throw new IllegalArgumentException("Treat should not be a root of an expression: " + expression.toString());
    }

    public boolean isJoinRequired() {
        return this.joinRequired;
    }

    public void setJoinRequired(boolean joinRequired) {
        this.joinRequired = joinRequired;
    }

    public void visit(FunctionExpression expression) {
        if (ExpressionUtils.isOuterFunction((FunctionExpression)expression)) {
            ((Expression)expression.getExpressions().get(0)).accept((Expression.Visitor)this.parentVisitor);
        } else {
            super.visit(expression);
        }
    }

    public void visit(SubqueryExpression expression) {
        ((AbstractCommonQueryBuilder)expression.getSubquery()).applyImplicitJoins(this);
    }

    public boolean isJoinWithObjectLeafAllowed() {
        return this.joinWithObjectLeafAllowed;
    }

    public void setJoinWithObjectLeafAllowed(boolean joinWithObjectLeafAllowed) {
        this.joinWithObjectLeafAllowed = joinWithObjectLeafAllowed;
    }

    public void visit(EqPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        this.removeAssociationIdIfPossible(predicate.getLeft(), predicate.getRight());
        this.joinRequired = original;
    }

    public void visit(InPredicate predicate) {
        Expression right;
        boolean original = this.joinRequired;
        this.joinRequired = false;
        boolean rewritten = false;
        if (predicate.getRight().size() == 1 && ((right = (Expression)predicate.getRight().get(0)) instanceof PathExpression || right instanceof ParameterExpression)) {
            this.removeAssociationIdIfPossible(predicate.getLeft(), right);
            rewritten = true;
        }
        if (!rewritten) {
            predicate.getLeft().accept((Expression.Visitor)this);
            for (Expression right2 : predicate.getRight()) {
                right2.accept((Expression.Visitor)this);
            }
        }
        this.joinRequired = original;
    }

    private void removeAssociationIdIfPossible(Expression left, Expression right) {
        String naturalIdAttribute;
        if (this.needsSingleValuedAssociationIdRemoval && this.fromClause == ClauseType.JOIN) {
            Type<?> associationType;
            ParameterValueTransformer tranformer;
            if (this.removeAssociationIdIfPossible(left)) {
                Type<?> associationType2;
                ParameterValueTransformer tranformer2;
                if (!this.removeAssociationIdIfPossible(right) && !this.rewriteToAssociationParam(tranformer2 = this.parameterTransformerFactory.getToEntityTranformer((associationType2 = this.getAssociationType(left, right)).getJavaType()), right)) {
                    left.accept((Expression.Visitor)this);
                }
            } else if (this.removeAssociationIdIfPossible(right) && !this.rewriteToAssociationParam(tranformer = this.parameterTransformerFactory.getToEntityTranformer((associationType = this.getAssociationType(left, right)).getJavaType()), left)) {
                right.accept((Expression.Visitor)this);
            }
        } else if (this.fromClause == ClauseType.JOIN && left instanceof PathExpression && right instanceof PathExpression && (naturalIdAttribute = this.getNaturalIdAttribute(left, right)) != null) {
            ((PathExpression)left).getExpressions().add(new PropertyExpression(naturalIdAttribute));
            ((PathExpression)right).getExpressions().add(new PropertyExpression(naturalIdAttribute));
            left.accept((Expression.Visitor)this);
            right.accept((Expression.Visitor)this);
        } else {
            left.accept((Expression.Visitor)this);
            right.accept((Expression.Visitor)this);
        }
    }

    private boolean removeAssociationIdIfPossible(Expression expression) {
        if (expression instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expression;
            this.visit(pathExpression, true);
            String lastElement = ((PathElementExpression)pathExpression.getExpressions().get(pathExpression.getExpressions().size() - 1)).toString();
            PathReference pathReference = pathExpression.getPathReference();
            JoinNode node = (JoinNode)pathReference.getBaseNode();
            String field = pathReference.getField();
            if (field == null) {
                if (node.getParentTreeNode() == null ? !lastElement.equals(node.getAlias()) : !lastElement.equals(node.getParentTreeNode().getRelationName()) && !lastElement.equals(node.getAlias())) {
                    return true;
                }
            } else {
                return !field.endsWith(lastElement) || field.length() != lastElement.length() && field.charAt(field.length() - lastElement.length()) != '.';
            }
        }
        return false;
    }

    private Type<?> getAssociationType(Expression expression1, Expression expression2) {
        if (expression1 instanceof PathExpression) {
            return ((PathExpression)expression1).getPathReference().getType();
        }
        return ((PathExpression)expression2).getPathReference().getType();
    }

    private String getNaturalIdAttribute(Expression expression1, Expression expression2) {
        String naturalIdAttribute = this.getNaturalIdAttribute(expression1);
        if (naturalIdAttribute != null) {
            return naturalIdAttribute;
        }
        return this.getNaturalIdAttribute(expression2);
    }

    private String getNaturalIdAttribute(Expression expression) {
        if (expression instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expression;
            this.visit(pathExpression, false);
            PathReference pathReference = pathExpression.getPathReference();
            if (pathReference.getField() != null && pathReference.getType() instanceof EntityType) {
                JoinNode node = (JoinNode)pathReference.getBaseNode();
                List identifierOrUniqueKeyEmbeddedPropertyNames = this.metamodel.getJpaProvider().getIdentifierOrUniqueKeyEmbeddedPropertyNames(node.getEntityType(), pathReference.getField());
                if (identifierOrUniqueKeyEmbeddedPropertyNames.size() == 1) {
                    String naturalIdAttribute = (String)identifierOrUniqueKeyEmbeddedPropertyNames.get(0);
                    ExtendedManagedType extendedManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, pathReference.getType().getJavaType());
                    if (!extendedManagedType.getIdAttribute().getName().equals(naturalIdAttribute)) {
                        return naturalIdAttribute;
                    }
                }
            }
        }
        return null;
    }

    private boolean rewriteToAssociationParam(ParameterValueTransformer tranformer, Expression expression) {
        if (!(expression instanceof ParameterExpression)) {
            return false;
        }
        ParameterExpression parameterExpression = (ParameterExpression)expression;
        ParameterManager.ParameterImpl<?> param = this.parameterManager.getParameter(parameterExpression.getName());
        param.setTranformer(tranformer);
        return true;
    }

    public void visit(IsNullPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        if (!this.removeAssociationIdIfPossible(predicate.getExpression())) {
            predicate.getExpression().accept((Expression.Visitor)this);
        }
        this.joinRequired = original;
    }

    public void visit(IsEmptyPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getExpression().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    public void visit(MemberOfPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getLeft().accept((Expression.Visitor)this);
        predicate.getRight().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    @Override
    public void visit(SelectInfo selectInfo) {
        try {
            this.selectAlias = selectInfo.getAlias();
            selectInfo.getExpression().accept((Expression.Visitor)this);
        }
        finally {
            this.selectAlias = null;
        }
    }
}

