/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AttributeHolder;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Type;

public final class JpaUtils {
    private static final Logger LOG = Logger.getLogger(JpaUtils.class.getName());

    private JpaUtils() {
    }

    public static AttributeHolder getAttributeForJoining(EntityMetamodel metamodel, PathExpression expression) {
        String baseNodeAlias;
        JoinNode expressionBaseNode = (JoinNode)expression.getPathReference().getBaseNode();
        String firstElementString = ((PathElementExpression)expression.getExpressions().get(0)).toString();
        JoinNode baseNode = expressionBaseNode;
        while (!firstElementString.equals(baseNodeAlias = baseNode.getAlias()) && (baseNode = baseNode.getParent()) != null) {
        }
        if (baseNode == null) {
            baseNodeAlias = null;
            baseNode = expressionBaseNode.getParent() == null ? expressionBaseNode : expressionBaseNode.getParent();
        }
        return JpaUtils.getAttributeForJoining(metamodel, baseNode.getNodeType(), (Expression)expression, baseNodeAlias);
    }

    public static AttributeHolder getAttributeForJoining(EntityMetamodel metamodel, Type<?> baseNodeType, Expression joinExpression, String baseNodeAlias) {
        PathTargetResolvingExpressionVisitor visitor = new PathTargetResolvingExpressionVisitor(metamodel, baseNodeType, baseNodeAlias);
        joinExpression.accept((Expression.Visitor)visitor);
        Map possibleTargets = visitor.getPossibleTargets();
        if (possibleTargets.size() > 1) {
            throw new IllegalArgumentException("Multiple possible target types for expression: " + joinExpression);
        }
        Map.Entry entry = possibleTargets.entrySet().iterator().next();
        return new AttributeHolder((Attribute)entry.getKey(), (Type)entry.getValue());
    }
}

