/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;

public class MultipleSubqueryInitiatorImpl<T>
extends SubqueryBuilderListenerImpl<MultipleSubqueryInitiator<T>>
implements MultipleSubqueryInitiator<T>,
ExpressionBuilder {
    private final T result;
    private final ExpressionBuilderEndedListener listener;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private Expression expression;
    private String subqueryAlias;
    private SubqueryInitiator<?> subqueryStartMarker;

    public MultipleSubqueryInitiatorImpl(T result, Expression expression, ExpressionBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory) {
        this.result = result;
        this.expression = expression;
        this.listener = listener;
        this.subqueryInitFactory = subqueryInitFactory;
    }

    public SubqueryInitiator<MultipleSubqueryInitiator<T>> with(String subqueryAlias) {
        this.verifySubqueryBuilderEnded();
        this.subqueryAlias = subqueryAlias;
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this, this, false));
    }

    public SubqueryBuilder<MultipleSubqueryInitiator<T>> with(String subqueryAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        this.subqueryAlias = subqueryAlias;
        return this.startSubqueryBuilder(this.subqueryInitFactory.createSubqueryBuilder(this, this, false, criteriaBuilder));
    }

    public T end() {
        if (this.listener != null) {
            this.listener.onBuilderEnded(this);
        }
        return this.result;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<MultipleSubqueryInitiator<T>> builder) {
        super.onBuilderEnded(builder);
        this.expression = ExpressionUtils.replaceSubexpression(this.expression, this.subqueryAlias, (Expression)new SubqueryExpression(builder));
        this.subqueryStartMarker = null;
        this.subqueryAlias = null;
    }

    @Override
    public void verifySubqueryBuilderEnded() {
        if (this.subqueryStartMarker != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
        super.verifySubqueryBuilderEnded();
    }

    public <X> SubqueryInitiator<X> startSubqueryInitiator(SubqueryInitiator<X> subqueryInitiator) {
        this.subqueryStartMarker = subqueryInitiator;
        return subqueryInitiator;
    }
}

