/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.GroupByExpressionGatheringVisitor;
import com.blazebit.persistence.impl.NodeInfo;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OrderByManager
extends AbstractManager<ExpressionModifier> {
    private final GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor;
    private final List<OrderByInfo> orderByInfos = new ArrayList<OrderByInfo>();
    private final AliasManager aliasManager;
    private final JpaProvider jpaProvider;

    OrderByManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, AliasManager aliasManager, JpaProvider jpaProvider, GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.groupByExpressionGatheringVisitor = groupByExpressionGatheringVisitor;
        this.aliasManager = aliasManager;
        this.jpaProvider = jpaProvider;
    }

    void applyFrom(OrderByManager orderByManager) {
        for (OrderByInfo info : orderByManager.orderByInfos) {
            this.orderBy(this.subqueryInitFactory.reattachSubqueries(info.getExpression().clone(true)), info.ascending, info.nullFirst);
        }
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.ORDER_BY;
    }

    public boolean containsOrderBySelectAlias(String alias) {
        if (alias == null || this.orderByInfos.isEmpty()) {
            return false;
        }
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpression().toString();
            if (!alias.equals(potentialSelectAlias)) continue;
            return true;
        }
        return false;
    }

    List<OrderByExpression> getOrderByExpressions(EntityMetamodel metamodel) {
        if (this.orderByInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OrderByExpression> realExpressions = new ArrayList<OrderByExpression>(this.orderByInfos.size());
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderByInfo.getExpression().toString());
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
            } else {
                expr = orderByInfo.getExpression();
            }
            boolean nullable = ExpressionUtils.isNullable(metamodel, expr);
            boolean unique = ExpressionUtils.isUnique(metamodel, expr);
            realExpressions.add(new OrderByExpression(orderByInfo.ascending, orderByInfo.nullFirst, expr, nullable, unique));
        }
        return realExpressions;
    }

    boolean hasOrderBys() {
        return this.orderByInfos.size() > 0;
    }

    int getOrderByCount() {
        return this.orderByInfos.size();
    }

    boolean hasComplexOrderBys() {
        if (this.orderByInfos.isEmpty()) {
            return false;
        }
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo;
            OrderByInfo orderByInfo = infos.get(i);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderByInfo.getExpression().toString());
            if (aliasInfo == null || !(aliasInfo instanceof SelectInfo) || (selectInfo = (SelectInfo)aliasInfo).getExpression() instanceof PathExpression) continue;
            return true;
        }
        return false;
    }

    void orderBy(Expression expr, boolean ascending, boolean nullFirst) {
        this.orderByInfos.add(new OrderByInfo(expr, ascending, nullFirst));
        this.registerParameterExpressions(expr);
    }

    void acceptVisitor(Expression.Visitor v) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            orderByInfo.getExpression().accept(v);
        }
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v, X stopValue) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            if (!stopValue.equals(orderByInfo.getExpression().accept(v))) continue;
            return stopValue;
        }
        return null;
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            visitor.visit(orderByInfo, ClauseType.ORDER_BY);
        }
    }

    void buildSelectClauses(StringBuilder sb, boolean allClauses) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        this.queryGenerator.setClauseType(ClauseType.SELECT);
        this.queryGenerator.setQueryBuffer(sb);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpression().toString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                if (!allClauses && selectInfo.getExpression() instanceof PathExpression) continue;
                sb.append(", ");
                this.queryGenerator.generate(selectInfo.getExpression());
                sb.append(" AS ").append(potentialSelectAlias);
                continue;
            }
            if (!allClauses) continue;
            sb.append(", ");
            this.queryGenerator.generate(orderByInfo.getExpression());
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
    }

    void buildGroupByClauses(Set<String> clauses) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        StringBuilder sb = new StringBuilder();
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpression().toString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
            } else {
                expr = orderByInfo.getExpression();
            }
            Set<Expression> extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions(expr);
            if (extractedGroupByExpressions.isEmpty()) continue;
            this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
            this.queryGenerator.setQueryBuffer(sb);
            for (Expression expression : extractedGroupByExpressions) {
                sb.setLength(0);
                this.queryGenerator.generate(expression);
                if (this.jpaProvider.supportsNullPrecedenceExpression()) {
                    clauses.add(sb.toString());
                    continue;
                }
                String expressionString = sb.toString();
                sb.setLength(0);
                this.jpaProvider.renderNullPrecedence(sb, expressionString, expressionString, null, null);
                clauses.add(sb.toString());
            }
            this.queryGenerator.setClauseType(null);
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.groupByExpressionGatheringVisitor.clear();
    }

    void buildOrderBy(StringBuilder sb, boolean inverseOrder, boolean resolveSelectAliases) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        this.queryGenerator.setClauseType(ClauseType.ORDER_BY);
        this.queryGenerator.setQueryBuffer(sb);
        sb.append(" ORDER BY ");
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            this.applyOrderBy(sb, infos.get(i), inverseOrder, resolveSelectAliases);
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
    }

    private void applyOrderBy(StringBuilder sb, OrderByInfo orderBy, boolean inverseOrder, boolean resolveSelectAliases) {
        if (this.jpaProvider.supportsNullPrecedenceExpression()) {
            this.queryGenerator.setClauseType(ClauseType.ORDER_BY);
            this.queryGenerator.setQueryBuffer(sb);
            if (resolveSelectAliases) {
                AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderBy.getExpression().toString());
                if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                    this.queryGenerator.generate(((SelectInfo)aliasInfo).getExpression());
                } else {
                    this.queryGenerator.generate(orderBy.getExpression());
                }
            } else {
                this.queryGenerator.generate(orderBy.getExpression());
            }
            if (orderBy.ascending == inverseOrder) {
                sb.append(" DESC");
            } else {
                sb.append(" ASC");
            }
            if (orderBy.nullFirst == inverseOrder) {
                sb.append(" NULLS LAST");
            } else {
                sb.append(" NULLS FIRST");
            }
        } else {
            String expression;
            String resolvedExpression;
            StringBuilder expressionSb = new StringBuilder();
            this.queryGenerator.setClauseType(ClauseType.ORDER_BY);
            this.queryGenerator.setQueryBuffer(expressionSb);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderBy.getExpression().toString());
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                this.queryGenerator.generate(((SelectInfo)aliasInfo).getExpression());
                resolvedExpression = expressionSb.toString();
            } else {
                resolvedExpression = null;
            }
            if (resolveSelectAliases && resolvedExpression != null) {
                expression = resolvedExpression;
            } else {
                expressionSb.setLength(0);
                this.queryGenerator.generate(orderBy.getExpression());
                expression = expressionSb.toString();
            }
            String order = orderBy.ascending == inverseOrder ? "DESC" : "ASC";
            String nulls = orderBy.nullFirst == inverseOrder ? "LAST" : "FIRST";
            this.jpaProvider.renderNullPrecedence(sb, expression, resolvedExpression, order, nulls);
        }
        this.queryGenerator.setClauseType(null);
    }

    private static class OrderByInfo
    extends NodeInfo {
        private boolean ascending;
        private boolean nullFirst;

        public OrderByInfo(Expression expression, boolean ascending, boolean nullFirst) {
            super(expression);
            this.ascending = ascending;
            this.nullFirst = nullFirst;
        }

        @Override
        public OrderByInfo clone() {
            return new OrderByInfo(this.getExpression(), this.ascending, this.nullFirst);
        }
    }
}

