/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.IllegalSubqueryDetector;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.PaginatedTypedQueryImpl;
import com.blazebit.persistence.impl.builder.object.DelegatingKeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.builder.object.KeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import com.blazebit.persistence.impl.keyset.SimpleKeysetLink;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.ObjectBuilderTypedQuery;
import com.blazebit.persistence.impl.transform.ExpressionTransformerGroup;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.SingularAttribute;

public class PaginatedCriteriaBuilderImpl<T>
extends AbstractFullQueryBuilder<T, PaginatedCriteriaBuilder<T>, PaginatedCriteriaBuilderImpl<T>, PaginatedCriteriaBuilderImpl<T>, BaseFinalSetOperationBuilderImpl<T, ?, ?>>
implements PaginatedCriteriaBuilder<T> {
    private static final String ENTITY_PAGE_POSITION_PARAMETER_NAME = "_entityPagePositionParameter";
    private static final String PAGE_POSITION_ID_QUERY_ALIAS_PREFIX = "_page_position_";
    private boolean keysetExtraction;
    private boolean withCountQuery = true;
    private int highestOffset = 0;
    private final KeysetPage keysetPage;
    private final Object entityId;
    private boolean needsNewIdList;
    private KeysetMode keysetMode;
    private String cachedCountQueryString;
    private String cachedExternalCountQueryString;
    private String cachedIdQueryString;
    private String cachedExternalIdQueryString;

    public PaginatedCriteriaBuilderImpl(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> baseBuilder, boolean keysetExtraction, Object entityId, int pageSize) {
        super(baseBuilder);
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize may not be zero or negative");
        }
        this.keysetExtraction = keysetExtraction;
        this.keysetPage = null;
        this.entityId = entityId;
        this.maxResults = pageSize;
        this.updateKeysetMode();
    }

    public PaginatedCriteriaBuilderImpl(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> baseBuilder, boolean keysetExtraction, KeysetPage keysetPage, int firstRow, int pageSize) {
        super(baseBuilder);
        if (firstRow < 0) {
            throw new IllegalArgumentException("firstRow may not be negative");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize may not be zero or negative");
        }
        this.keysetExtraction = keysetExtraction;
        this.keysetPage = keysetPage;
        this.firstResult = firstRow;
        this.entityId = null;
        this.maxResults = pageSize;
        this.updateKeysetMode();
    }

    public <Y> PaginatedCriteriaBuilder<Y> copy(Class<Y> resultClass) {
        FullQueryBuilder<Y, ?> criteriaBuilder = super.copy(resultClass);
        PaginatedCriteriaBuilder builder = this.entityId != null ? criteriaBuilder.page(this.entityId, this.maxResults) : (this.keysetPage != null ? criteriaBuilder.page(this.keysetPage, this.firstResult, this.maxResults) : criteriaBuilder.page(this.firstResult, this.maxResults));
        builder.withKeysetExtraction(this.keysetExtraction);
        return builder;
    }

    @Override
    public PaginatedCriteriaBuilder<T> setFirstResult(int firstResult) {
        super.setFirstResult(firstResult);
        this.updateKeysetMode();
        return this;
    }

    @Override
    public PaginatedCriteriaBuilder<T> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        this.updateKeysetMode();
        return this;
    }

    private void updateKeysetMode() {
        KeysetMode oldMode = this.keysetMode;
        this.keysetMode = KeysetPaginationHelper.getKeysetMode(this.keysetPage, this.entityId, this.firstResult, this.maxResults);
        if (this.keysetMode == KeysetMode.NONE) {
            this.keysetManager.setKeysetLink(null);
        } else if (this.keysetMode == KeysetMode.NEXT) {
            this.keysetManager.setKeysetLink(new SimpleKeysetLink(this.keysetPage.getHighest(), this.keysetMode));
        } else {
            this.keysetManager.setKeysetLink(new SimpleKeysetLink(this.keysetPage.getLowest(), this.keysetMode));
        }
        if (this.keysetMode != oldMode) {
            this.prepareForModification();
        }
    }

    public PaginatedCriteriaBuilder<T> withKeysetExtraction(boolean keysetExtraction) {
        this.keysetExtraction = keysetExtraction;
        return this;
    }

    public boolean isKeysetExtraction() {
        return this.keysetExtraction;
    }

    public PaginatedCriteriaBuilder<T> withCountQuery(boolean withCountQuery) {
        this.withCountQuery = withCountQuery;
        return this;
    }

    public boolean isWithCountQuery() {
        return this.withCountQuery;
    }

    public PaginatedCriteriaBuilder<T> withHighestKeysetOffset(int offset) {
        this.highestOffset = offset;
        return this;
    }

    public int getHighestKeysetOffset() {
        return this.highestOffset;
    }

    private <X> TypedQuery<X> getCountQuery(String countQueryString, Class<X> resultType, boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins) {
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT))) {
            TypedQuery countQuery = this.em.createQuery(countQueryString, resultType);
            if (this.isCacheable()) {
                this.jpaProvider.setCacheable((Query)countQuery);
            }
            this.parameterManager.parameterizeQuery((Query)countQuery);
            return countQuery;
        }
        TypedQuery baseQuery = this.em.createQuery(countQueryString, resultType);
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT));
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes((Query)baseQuery, false) : Collections.EMPTY_LIST;
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, this.parameterManager.getParameters(), parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
        CustomSQLTypedQuery countQuery = new CustomSQLTypedQuery(querySpecification, (Query)baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(countQuery);
        return countQuery;
    }

    @Override
    public PaginatedTypedQueryImpl<T> getQuery() {
        KeysetExtractionObjectBuilder<T> objectBuilder;
        TypedQuery<T> objectQuery;
        this.prepareAndCheck();
        Set<JoinNode> keyRestrictedLeftJoins = this.joinManager.getKeyRestrictedLeftJoins();
        boolean normalQueryMode = !this.isMainQuery || !this.mainQuery.cteManager.hasCtes() && !this.joinManager.hasEntityFunctions() && keyRestrictedLeftJoins.isEmpty();
        Object countQuery = null;
        String countQueryString = this.getPageCountQueryStringWithoutCheck();
        countQuery = this.entityId == null ? this.getCountQuery(countQueryString, Long.class, normalQueryMode, keyRestrictedLeftJoins) : this.getCountQuery(countQueryString, Object[].class, normalQueryMode, keyRestrictedLeftJoins);
        TypedQuery<Object[]> idQuery = null;
        if (this.joinManager.hasCollections()) {
            String idQueryString = this.getPageIdQueryStringWithoutCheck();
            idQuery = this.getIdQuery(idQueryString, normalQueryMode, keyRestrictedLeftJoins);
            objectQuery = this.getObjectQueryById(normalQueryMode, keyRestrictedLeftJoins);
            objectBuilder = null;
        } else {
            Map.Entry<TypedQuery<T>, KeysetExtractionObjectBuilder<T>> entry = this.getObjectQuery(normalQueryMode, keyRestrictedLeftJoins);
            objectQuery = entry.getKey();
            objectBuilder = entry.getValue();
        }
        PaginatedTypedQueryImpl<T> query = new PaginatedTypedQueryImpl<T>(this.withCountQuery, this.highestOffset, (TypedQuery<?>)countQuery, idQuery, objectQuery, objectBuilder, this.parameterManager.getParameters(), this.entityId, this.firstResult, this.maxResults, this.needsNewIdList, this.keysetExtraction, this.keysetMode, this.keysetPage);
        return query;
    }

    @Override
    public PagedList<T> getResultList() {
        return this.getQuery().getResultList();
    }

    public String getPageCountQueryString() {
        this.prepareAndCheck();
        return this.getExternalPageCountQueryString();
    }

    private String getPageCountQueryStringWithoutCheck() {
        if (this.cachedCountQueryString == null) {
            this.cachedCountQueryString = this.buildPageCountQueryString(false);
        }
        return this.cachedCountQueryString;
    }

    protected String getExternalPageCountQueryString() {
        if (this.cachedExternalCountQueryString == null) {
            this.cachedExternalCountQueryString = this.buildPageCountQueryString(true);
        }
        return this.cachedExternalCountQueryString;
    }

    public String getPageIdQueryString() {
        this.prepareAndCheck();
        return this.getExternalPageIdQueryString();
    }

    private String getPageIdQueryStringWithoutCheck() {
        if (this.cachedIdQueryString == null) {
            this.cachedIdQueryString = this.buildPageIdQueryString(false);
        }
        return this.cachedIdQueryString;
    }

    protected String getExternalPageIdQueryString() {
        if (this.cachedExternalIdQueryString == null) {
            this.cachedExternalIdQueryString = this.buildPageIdQueryString(true);
        }
        return this.cachedExternalIdQueryString;
    }

    @Override
    public String getQueryString() {
        this.prepareAndCheck();
        return this.getExternalQueryString();
    }

    @Override
    protected String getBaseQueryString() {
        if (this.cachedQueryString == null) {
            this.cachedQueryString = !this.joinManager.hasCollections() ? this.buildObjectQueryString(false) : this.buildBaseQueryString(false);
        }
        return this.cachedQueryString;
    }

    @Override
    protected String getExternalQueryString() {
        if (this.cachedExternalQueryString == null) {
            this.cachedExternalQueryString = !this.joinManager.hasCollections() ? this.buildObjectQueryString(true) : this.buildBaseQueryString(true);
        }
        return this.cachedExternalQueryString;
    }

    @Override
    protected void prepareForModification() {
        super.prepareForModification();
        this.cachedCountQueryString = null;
        this.cachedExternalCountQueryString = null;
        this.cachedIdQueryString = null;
        this.cachedExternalIdQueryString = null;
    }

    @Override
    protected void prepareAndCheck() {
        if (!this.needsCheck) {
            return;
        }
        this.verifyBuilderEnded();
        if (!this.orderByManager.hasOrderBys()) {
            throw new IllegalStateException("Pagination requires at least one order by item!");
        }
        this.applyImplicitJoins(null);
        this.applyExpressionTransformers();
        List<OrderByExpression> orderByExpressions = this.orderByManager.getOrderByExpressions(this.mainQuery.metamodel);
        if (!orderByExpressions.get(orderByExpressions.size() - 1).isUnique()) {
            throw new IllegalStateException("The last order by item must be unique!");
        }
        if (this.keysetManager.hasKeyset()) {
            this.keysetManager.initialize(orderByExpressions);
        }
        this.needsNewIdList = this.keysetExtraction || this.orderByManager.hasComplexOrderBys();
        this.needsCheck = false;
    }

    private Map.Entry<TypedQuery<T>, KeysetExtractionObjectBuilder<T>> getObjectQuery(boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins) {
        Object query;
        String queryString = this.getBaseQueryString();
        Class expectedResultType = this.keysetExtraction ? Object[].class : this.selectManager.getExpectedQueryResultType();
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, EnumSet.noneOf(ClauseType.class))) {
            query = this.em.createQuery(queryString, expectedResultType);
            if (this.isCacheable()) {
                this.jpaProvider.setCacheable((Query)query);
            }
            this.parameterManager.parameterizeQuery((Query)query);
        } else {
            TypedQuery baseQuery = this.em.createQuery(queryString, expectedResultType);
            Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
            List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, EnumSet.noneOf(ClauseType.class));
            List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery);
            boolean shouldRenderCteNodes = this.renderCteNodes(false);
            List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes((Query)baseQuery, false) : Collections.EMPTY_LIST;
            CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, this.parameterManager.getParameters(), parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
            query = new CustomSQLTypedQuery(querySpecification, (Query)baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
            this.parameterManager.parameterizeQuery((Query)query);
        }
        KeysetExtractionObjectBuilder objectBuilder = null;
        ObjectBuilder transformerObjectBuilder = this.selectManager.getSelectObjectBuilder();
        if (this.keysetExtraction) {
            int keysetSize = this.orderByManager.getOrderByCount();
            objectBuilder = transformerObjectBuilder == null ? new KeysetExtractionObjectBuilder(keysetSize, this.keysetMode, this.selectManager.getExpectedQueryResultType() != Object[].class) : new DelegatingKeysetExtractionObjectBuilder(transformerObjectBuilder, keysetSize, this.keysetMode);
            transformerObjectBuilder = objectBuilder;
        }
        if (transformerObjectBuilder != null) {
            query = new ObjectBuilderTypedQuery((TypedQuery<?>)query, transformerObjectBuilder);
        }
        return new AbstractMap.SimpleEntry<TypedQuery, Object>((TypedQuery)query, objectBuilder);
    }

    private TypedQuery<Object[]> getIdQuery(String idQueryString, boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins) {
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, EnumSet.of(ClauseType.SELECT))) {
            TypedQuery idQuery = this.em.createQuery(idQueryString, Object[].class);
            if (this.isCacheable()) {
                this.jpaProvider.setCacheable((Query)idQuery);
            }
            this.parameterManager.parameterizeQuery((Query)idQuery);
            return idQuery;
        }
        TypedQuery baseQuery = this.em.createQuery(idQueryString, Object[].class);
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery);
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, EnumSet.of(ClauseType.SELECT));
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes((Query)baseQuery, false) : Collections.EMPTY_LIST;
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, this.parameterManager.getParameters(), parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
        CustomSQLTypedQuery<Object[]> idQuery = new CustomSQLTypedQuery<Object[]>(querySpecification, (Query)baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(idQuery);
        return idQuery;
    }

    private TypedQuery<T> getObjectQueryById(boolean normalQueryMode, Set<JoinNode> keyRestrictedLeftJoins) {
        if (normalQueryMode && PaginatedCriteriaBuilderImpl.isEmpty(keyRestrictedLeftJoins, EnumSet.complementOf(EnumSet.of(ClauseType.SELECT, ClauseType.ORDER_BY)))) {
            TypedQuery query = this.em.createQuery(this.getBaseQueryString(), this.selectManager.getExpectedQueryResultType());
            if (this.isCacheable()) {
                this.jpaProvider.setCacheable((Query)query);
            }
            this.parameterManager.parameterizeQuery((Query)query, Collections.singleton("ids"));
            return this.applyObjectBuilder(query);
        }
        TypedQuery baseQuery = this.em.createQuery(this.getBaseQueryString(), this.selectManager.getExpectedQueryResultType());
        Set<String> parameterListNames = this.parameterManager.getParameterListNames((Query)baseQuery, Collections.singleton("ids"));
        parameterListNames.add("ids");
        List<String> keyRestrictedLeftJoinAliases = this.getKeyRestrictedLeftJoinAliases((Query)baseQuery, keyRestrictedLeftJoins, EnumSet.complementOf(EnumSet.of(ClauseType.SELECT, ClauseType.ORDER_BY)));
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes((Query)baseQuery);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes((Query)baseQuery, false) : Collections.EMPTY_LIST;
        HashSet parameters = new HashSet(this.parameterManager.getParameters());
        parameters.add(baseQuery.getParameter("ids"));
        CustomQuerySpecification querySpecification = new CustomQuerySpecification(this, (Query)baseQuery, parameters, parameterListNames, null, null, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes);
        CustomSQLTypedQuery query = new CustomSQLTypedQuery(querySpecification, (Query)baseQuery, this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        this.parameterManager.parameterizeQuery(query, Collections.singleton("ids"));
        return this.applyObjectBuilder(query);
    }

    @Override
    protected String buildPageCountQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildPageCountQueryString(sbSelectFrom, externalRepresentation);
        return sbSelectFrom.toString();
    }

    private String buildPageCountQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        SingularAttribute idAttribute = JpaMetamodelUtils.getIdAttribute(this.mainQuery.metamodel.entity(rootNode.getJavaType()));
        String idName = idAttribute.getName();
        StringBuilder idClause = new StringBuilder(100);
        rootNode.appendDeReference(idClause, idName);
        String countString = this.jpaProvider.getCustomFunctionInvocation("count_tuple", 1) + "'DISTINCT'," + idClause + ")";
        sbSelectFrom.append("SELECT ").append(countString);
        if (this.entityId != null) {
            this.parameterManager.addParameterMapping(ENTITY_PAGE_POSITION_PARAMETER_NAME, this.entityId, ClauseType.SELECT);
            sbSelectFrom.append(", ");
            sbSelectFrom.append(this.jpaProvider.getCustomFunctionInvocation("page_position", 2));
            sbSelectFrom.append('(');
            this.appendSimplePageIdQueryString(sbSelectFrom);
            sbSelectFrom.append("),");
            sbSelectFrom.append(':').append(ENTITY_PAGE_POSITION_PARAMETER_NAME);
            sbSelectFrom.append(")");
        }
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        Set<JoinNode> countNodesToFetch = Collections.emptySet();
        Set<JoinNode> collectionJoinNodes = this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT), null, true, externalRepresentation, whereClauseConjuncts, this.explicitVersionEntities, countNodesToFetch);
        boolean hasCollectionJoinUsages = collectionJoinNodes.size() > 0;
        this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts);
        if (!hasCollectionJoinUsages) {
            int idx = sbSelectFrom.indexOf(countString);
            int endIdx = idx + countString.length() - 1;
            String countStar = this.jpaProvider.supportsCountStar() ? "COUNT(*" : this.jpaProvider.getCustomFunctionInvocation("count_star", 0);
            int i = idx;
            int j = 0;
            while (i < endIdx) {
                if (j < countStar.length()) {
                    sbSelectFrom.setCharAt(i, countStar.charAt(j));
                } else {
                    sbSelectFrom.setCharAt(i, ' ');
                }
                ++i;
                ++j;
            }
        }
        return sbSelectFrom.toString();
    }

    private String appendSimplePageIdQueryString(StringBuilder sbSelectFrom) {
        this.queryGenerator.setAliasPrefix(PAGE_POSITION_ID_QUERY_ALIAS_PREFIX);
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaMetamodelUtils.getIdAttribute(this.mainQuery.metamodel.entity(rootNode.getJavaType())).getName();
        StringBuilder idClause = new StringBuilder(PAGE_POSITION_ID_QUERY_ALIAS_PREFIX);
        rootNode.appendDeReference(idClause, idName);
        sbSelectFrom.append("SELECT ").append((CharSequence)idClause);
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        Set<JoinNode> idNodesToFetch = Collections.emptySet();
        this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.SELECT), PAGE_POSITION_ID_QUERY_ALIAS_PREFIX, false, false, whereClauseConjuncts, this.explicitVersionEntities, idNodesToFetch);
        this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts);
        boolean inverseOrder = false;
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        clauses.add(idClause.toString());
        this.orderByManager.buildGroupByClauses(clauses);
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, true);
        this.queryGenerator.setAliasPrefix(null);
        return sbSelectFrom.toString();
    }

    private String buildPageIdQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildPageIdQueryString(sbSelectFrom, externalRepresentation);
        return sbSelectFrom.toString();
    }

    private String buildPageIdQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaMetamodelUtils.getIdAttribute(this.mainQuery.metamodel.entity(rootNode.getJavaType())).getName();
        StringBuilder idClause = new StringBuilder(100);
        rootNode.appendDeReference(idClause, idName);
        sbSelectFrom.append("SELECT ").append((CharSequence)idClause);
        if (this.needsNewIdList) {
            this.orderByManager.buildSelectClauses(sbSelectFrom, this.keysetExtraction);
        }
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        Set<JoinNode> idNodesToFetch = Collections.emptySet();
        this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.SELECT), null, false, externalRepresentation, whereClauseConjuncts, this.explicitVersionEntities, idNodesToFetch);
        if (this.keysetMode == KeysetMode.NONE) {
            this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts);
        } else {
            sbSelectFrom.append(" WHERE ");
            int positionalOffset = this.parameterManager.getPositionalOffset();
            if (this.mainQuery.getQueryConfiguration().isOptimizedKeysetPredicateRenderingEnabled()) {
                this.keysetManager.buildOptimizedKeysetPredicate(sbSelectFrom, positionalOffset);
            } else {
                this.keysetManager.buildKeysetPredicate(sbSelectFrom, positionalOffset);
            }
            if (this.whereManager.hasPredicates() || !whereClauseConjuncts.isEmpty()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom, whereClauseConjuncts);
            }
        }
        boolean inverseOrder = this.keysetMode == KeysetMode.PREVIOUS;
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        clauses.add(idClause.toString());
        this.orderByManager.buildGroupByClauses(clauses);
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, !this.needsNewIdList);
        this.orderByManager.acceptVisitor((Expression.Visitor)new IllegalSubqueryDetector(this.aliasManager));
        return sbSelectFrom.toString();
    }

    @Override
    protected String buildBaseQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildBaseQueryString(sbSelectFrom, externalRepresentation);
        return sbSelectFrom.toString();
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        ExpressionTransformerGroup transformerGroup;
        int i;
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaMetamodelUtils.getIdAttribute(this.mainQuery.metamodel.entity(rootNode.getJavaType())).getName();
        this.selectManager.buildSelect(sbSelectFrom, false);
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        this.joinManager.buildClause(sbSelectFrom, EnumSet.complementOf(EnumSet.of(ClauseType.SELECT, ClauseType.ORDER_BY)), null, false, externalRepresentation, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch);
        sbSelectFrom.append(" WHERE ");
        rootNode.appendDeReference(sbSelectFrom, idName);
        sbSelectFrom.append(" IN :").append("ids").append("");
        for (String conjunct : whereClauseConjuncts) {
            sbSelectFrom.append(" AND ");
            sbSelectFrom.append(conjunct);
        }
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        this.groupByManager.buildGroupByClauses(clauses);
        int size = this.transformerGroups.size();
        for (i = 0; i < size; ++i) {
            transformerGroup = (ExpressionTransformerGroup)this.transformerGroups.get(i);
            clauses.addAll(transformerGroup.getRequiredGroupByClauses());
        }
        if (this.hasGroupBy) {
            if (this.mainQuery.getQueryConfiguration().isImplicitGroupByFromSelectEnabled()) {
                this.selectManager.buildGroupByClauses(this.mainQuery.metamodel, clauses);
            }
            if (this.mainQuery.getQueryConfiguration().isImplicitGroupByFromHavingEnabled()) {
                this.havingManager.buildGroupByClauses(clauses);
            }
            if (this.mainQuery.getQueryConfiguration().isImplicitGroupByFromOrderByEnabled()) {
                this.orderByManager.buildGroupByClauses(clauses);
            }
        }
        if (!clauses.isEmpty()) {
            for (i = 0; i < size; ++i) {
                transformerGroup = (ExpressionTransformerGroup)this.transformerGroups.get(i);
                clauses.addAll(transformerGroup.getOptionalGroupByClauses());
            }
        }
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.havingManager.buildClause(sbSelectFrom);
        this.queryGenerator.setResolveSelectAliases(false);
        this.orderByManager.buildOrderBy(sbSelectFrom, false, false);
        this.queryGenerator.setResolveSelectAliases(true);
    }

    private String buildObjectQueryString(boolean externalRepresentation) {
        StringBuilder sbSelectFrom = new StringBuilder();
        if (externalRepresentation && this.isMainQuery) {
            this.mainQuery.cteManager.buildClause(sbSelectFrom);
        }
        this.buildObjectQueryString(sbSelectFrom, externalRepresentation);
        return sbSelectFrom.toString();
    }

    private String buildObjectQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation) {
        ExpressionTransformerGroup transformerGroup;
        int i;
        this.selectManager.buildSelect(sbSelectFrom, false);
        if (this.keysetExtraction) {
            this.orderByManager.buildSelectClauses(sbSelectFrom, true);
        }
        ArrayList<String> whereClauseConjuncts = new ArrayList<String>();
        this.joinManager.buildClause(sbSelectFrom, EnumSet.noneOf(ClauseType.class), null, false, externalRepresentation, whereClauseConjuncts, this.explicitVersionEntities, this.nodesToFetch);
        if (this.keysetMode == KeysetMode.NONE) {
            this.whereManager.buildClause(sbSelectFrom, whereClauseConjuncts);
        } else {
            sbSelectFrom.append(" WHERE ");
            int positionalOffset = this.parameterManager.getPositionalOffset();
            if (this.mainQuery.getQueryConfiguration().isOptimizedKeysetPredicateRenderingEnabled()) {
                this.keysetManager.buildOptimizedKeysetPredicate(sbSelectFrom, positionalOffset);
            } else {
                this.keysetManager.buildKeysetPredicate(sbSelectFrom, positionalOffset);
            }
            if (this.whereManager.hasPredicates() || !whereClauseConjuncts.isEmpty()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom, whereClauseConjuncts);
            }
        }
        boolean inverseOrder = this.keysetMode == KeysetMode.PREVIOUS;
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        this.groupByManager.buildGroupByClauses(clauses);
        int size = this.transformerGroups.size();
        for (i = 0; i < size; ++i) {
            transformerGroup = (ExpressionTransformerGroup)this.transformerGroups.get(i);
            clauses.addAll(transformerGroup.getRequiredGroupByClauses());
        }
        if (this.hasGroupBy) {
            if (this.mainQuery.getQueryConfiguration().isImplicitGroupByFromSelectEnabled()) {
                this.selectManager.buildGroupByClauses(this.mainQuery.metamodel, clauses);
            }
            if (this.mainQuery.getQueryConfiguration().isImplicitGroupByFromHavingEnabled()) {
                this.havingManager.buildGroupByClauses(clauses);
            }
            if (this.mainQuery.getQueryConfiguration().isImplicitGroupByFromOrderByEnabled()) {
                this.orderByManager.buildGroupByClauses(clauses);
            }
        }
        if (!clauses.isEmpty()) {
            for (i = 0; i < size; ++i) {
                transformerGroup = (ExpressionTransformerGroup)this.transformerGroups.get(i);
                clauses.addAll(transformerGroup.getOptionalGroupByClauses());
            }
        }
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.havingManager.buildClause(sbSelectFrom);
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, false);
        this.orderByManager.acceptVisitor((Expression.Visitor)new IllegalSubqueryDetector(this.aliasManager));
        return sbSelectFrom.toString();
    }

    @Override
    public PaginatedCriteriaBuilder<T> distinct() {
        throw new IllegalStateException("Calling distinct() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public PaginatedCriteriaBuilder<T> groupBy(String ... paths) {
        throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public PaginatedCriteriaBuilder<T> groupBy(String expression) {
        throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public <Y> SelectObjectBuilder<PaginatedCriteriaBuilder<Y>> selectNew(Class<Y> clazz) {
        return super.selectNew(clazz);
    }

    public <Y> PaginatedCriteriaBuilder<Y> selectNew(ObjectBuilder<Y> builder) {
        return (PaginatedCriteriaBuilder)super.selectNew(builder);
    }
}

