/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PagedArrayList;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedTypedQuery;
import com.blazebit.persistence.impl.builder.object.KeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPageImpl;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import com.blazebit.persistence.impl.util.SetView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;

public class PaginatedTypedQueryImpl<X>
implements PaginatedTypedQuery<X> {
    private final boolean withCount;
    private final int highestOffset;
    private final TypedQuery<?> countQuery;
    private final TypedQuery<?> idQuery;
    private final TypedQuery<X> objectQuery;
    private final KeysetExtractionObjectBuilder<X> objectBuilder;
    private final Map<String, Parameter<?>> parameters;
    private final Map<String, ParameterLocation> parameterToQuery;
    private final Object entityId;
    private int firstResult;
    private int pageSize;
    private final boolean needsNewIdList;
    private final boolean keysetExtraction;
    private final KeysetMode keysetMode;
    private final KeysetPage keysetPage;

    public PaginatedTypedQueryImpl(boolean withCount, int highestOffset, TypedQuery<?> countQuery, TypedQuery<?> idQuery, TypedQuery<X> objectQuery, KeysetExtractionObjectBuilder<X> objectBuilder, Set<Parameter<?>> parameters, Object entityId, int firstResult, int pageSize, boolean needsNewIdList, boolean keysetExtraction, KeysetMode keysetMode, KeysetPage keysetPage) {
        ParameterLocation parameterLocation;
        String name;
        this.withCount = withCount;
        this.highestOffset = highestOffset;
        this.countQuery = countQuery;
        this.idQuery = idQuery;
        this.objectQuery = objectQuery;
        this.objectBuilder = objectBuilder;
        this.parameterToQuery = new HashMap<String, ParameterLocation>(parameters.size());
        this.entityId = entityId;
        this.firstResult = firstResult;
        this.pageSize = pageSize;
        this.needsNewIdList = needsNewIdList;
        this.keysetExtraction = keysetExtraction;
        this.keysetMode = keysetMode;
        this.keysetPage = keysetPage;
        HashMap params = new HashMap(parameters.size());
        for (Parameter<?> parameter : parameters) {
            params.put(this.getParameterName(parameter), parameter);
        }
        this.parameters = Collections.unmodifiableMap(params);
        for (Parameter parameter : countQuery.getParameters()) {
            this.parameterToQuery.put(this.getParameterName(parameter), ParameterLocation.COUNT);
        }
        if (idQuery != null) {
            for (Parameter parameter : idQuery.getParameters()) {
                name = this.getParameterName(parameter);
                parameterLocation = this.parameterToQuery.get(name);
                parameterLocation = parameterLocation == null ? ParameterLocation.ID : parameterLocation.andId();
                this.parameterToQuery.put(name, parameterLocation);
            }
        }
        if (objectQuery != null) {
            for (Parameter parameter : objectQuery.getParameters()) {
                name = this.getParameterName(parameter);
                parameterLocation = this.parameterToQuery.get(name);
                parameterLocation = parameterLocation == null ? ParameterLocation.OBJECT : parameterLocation.andObject();
                this.parameterToQuery.put(name, parameterLocation);
            }
        }
    }

    private String getParameterName(Parameter<?> parameter) {
        String name = parameter.getName();
        if (name == null) {
            return parameter.getPosition().toString();
        }
        return name;
    }

    public long getTotalCount() {
        return (Long)this.countQuery.getSingleResult();
    }

    public List<X> getPageResultList() {
        int queryFirstResult = this.firstResult;
        int firstRow = this.firstResult;
        return this.getResultList(queryFirstResult, firstRow, -1L);
    }

    public PagedList<X> getResultList() {
        int queryFirstResult = this.firstResult;
        int firstRow = this.firstResult;
        long totalSize = -1L;
        if (this.withCount) {
            if (this.entityId == null) {
                totalSize = (Long)this.countQuery.getSingleResult();
            } else {
                Object[] result = (Object[])this.countQuery.getSingleResult();
                totalSize = (Long)result[0];
                if (result[1] == null) {
                    queryFirstResult = -1;
                    firstRow = 0;
                } else {
                    int position = ((Long)result[1]).intValue() - 1;
                    firstRow = position == 0 ? 0 : position - position % this.pageSize;
                    queryFirstResult = firstRow;
                }
            }
        }
        if (totalSize == 0L) {
            return new PagedArrayList(null, totalSize, queryFirstResult, this.pageSize);
        }
        return this.getResultList(queryFirstResult, firstRow, totalSize);
    }

    private PagedList<X> getResultList(int queryFirstResult, int firstRow, long totalSize) {
        if (this.idQuery != null) {
            this.idQuery.setMaxResults(this.pageSize);
            if (this.keysetMode == KeysetMode.NONE) {
                this.idQuery.setFirstResult(firstRow);
            } else {
                this.idQuery.setFirstResult(0);
            }
            ArrayList<Object> ids = this.idQuery.getResultList();
            if (ids.isEmpty()) {
                KeysetPage newKeysetPage = null;
                if (this.keysetMode == KeysetMode.NEXT) {
                    newKeysetPage = this.keysetPage;
                }
                return new PagedArrayList(newKeysetPage, totalSize, queryFirstResult, this.pageSize);
            }
            Serializable[] lowest = null;
            Serializable[] highest = null;
            if (this.needsNewIdList) {
                if (this.keysetExtraction) {
                    int keysetPageSize = this.pageSize - this.highestOffset;
                    lowest = KeysetPaginationHelper.extractKey((Object[])ids.get(0), 1);
                    highest = KeysetPaginationHelper.extractKey((Object[])(ids.size() >= keysetPageSize ? ids.get(keysetPageSize - 1) : ids.get(ids.size() - 1)), 1);
                }
                ArrayList<Object> newIds = new ArrayList<Object>(ids.size());
                for (int i = 0; i < ids.size(); ++i) {
                    newIds.add(((Object[])ids.get(i))[0]);
                }
                ids = newIds;
            }
            this.objectQuery.setParameter("ids", (Object)ids);
            KeysetPageImpl newKeyset = null;
            if (this.keysetExtraction) {
                newKeyset = new KeysetPageImpl(firstRow, this.pageSize, lowest, highest);
            }
            List queryResultList = this.objectQuery.getResultList();
            PagedArrayList pagedResultList = new PagedArrayList((Collection)queryResultList, (KeysetPage)newKeyset, totalSize, queryFirstResult, this.pageSize);
            return pagedResultList;
        }
        this.objectQuery.setMaxResults(this.pageSize);
        if (this.keysetMode == KeysetMode.NONE) {
            this.objectQuery.setFirstResult(firstRow);
        } else {
            this.objectQuery.setFirstResult(0);
        }
        List result = this.objectQuery.getResultList();
        if (result.isEmpty()) {
            KeysetPage newKeysetPage = null;
            if (this.keysetMode == KeysetMode.NEXT) {
                newKeysetPage = this.keysetPage;
            }
            return new PagedArrayList(newKeysetPage, totalSize, queryFirstResult, this.pageSize);
        }
        if (this.keysetMode == KeysetMode.PREVIOUS) {
            Collections.reverse(result);
        }
        KeysetPageImpl newKeyset = null;
        if (this.keysetExtraction) {
            Serializable[] lowest = this.objectBuilder.getLowest();
            Serializable[] highest = this.objectBuilder.getHighest();
            newKeyset = new KeysetPageImpl(firstRow, this.pageSize, lowest, highest);
        }
        PagedArrayList pagedResultList = new PagedArrayList((Collection)result, newKeyset, totalSize, queryFirstResult, this.pageSize);
        return pagedResultList;
    }

    public X getSingleResult() {
        PagedList<X> result = this.getResultList();
        if (result.size() == 0) {
            throw new NoResultException("No entity found for query");
        }
        if (result.size() > 1) {
            HashSet<X> uniqueResult = new HashSet<X>(result);
            if (uniqueResult.size() > 1) {
                throw new NonUniqueResultException("result returns more than one element");
            }
            return (X)uniqueResult.iterator().next();
        }
        return (X)result.get(0);
    }

    public int executeUpdate() {
        throw new IllegalArgumentException("Can not call executeUpdate on a select query!");
    }

    public TypedQuery<X> setMaxResults(int maxResult) {
        throw new IllegalArgumentException("Updating max results is not supported on paginated query!");
    }

    public int getMaxResults() {
        return this.pageSize;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        throw new IllegalArgumentException("Updating first result is not supported on paginated query!");
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Map<String, Object> getHints() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        if (param.getName() == null) {
            List<Query> queries = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getPosition().intValue(), value);
            }
        } else if (Character.isDigit(param.getName().charAt(0))) {
            List<Query> queries = this.parameterToQuery.get(param.getName()).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(Integer.parseInt(param.getName()), value);
            }
        } else {
            List<Query> queries = this.parameterToQuery.get(param.getName()).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getName(), value);
            }
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        if (param.getName() == null) {
            List<Query> queries = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getPosition().intValue(), value, temporalType);
            }
        } else if (Character.isDigit(param.getName().charAt(0))) {
            List<Query> queries = this.parameterToQuery.get(param.getName()).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(Integer.parseInt(param.getName()), value, temporalType);
            }
        } else {
            List<Query> queries = this.parameterToQuery.get(param.getName()).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getName(), value, temporalType);
            }
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (param.getName() == null) {
            List<Query> queries = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getPosition().intValue(), value, temporalType);
            }
        } else if (Character.isDigit(param.getName().charAt(0))) {
            List<Query> queries = this.parameterToQuery.get(param.getName()).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(Integer.parseInt(param.getName()), value, temporalType);
            }
        } else {
            List<Query> queries = this.parameterToQuery.get(param.getName()).getQueries((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            for (Query query : queries) {
                query.setParameter(param.getName(), value, temporalType);
            }
        }
        return this;
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        return this.setParameter((Parameter<T>)((Parameter)this.getParameter(name)), (T)value);
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Date.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        return this.setParameter((Parameter<T>)((Parameter)this.getParameter(position)), (T)value);
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(position, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(position, Date.class), value, temporalType);
    }

    public Set<Parameter<?>> getParameters() {
        return new SetView(this.parameters.values());
    }

    public Parameter<?> getParameter(String name) {
        Parameter<?> param = this.parameters.get(name);
        if (param == null) {
            throw new IllegalArgumentException("Couldn't find parameter with name '" + name + "'!");
        }
        return param;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Parameter<?> param = this.getParameter(name);
        if (!param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException("The parameter with the name '" + name + "' has the type '" + param.getParameterType().getName() + "' which is not assignable to requested type '" + type.getName() + "'");
        }
        return param;
    }

    public boolean isBound(Parameter<?> param) {
        if (this.objectQuery.isBound(param)) {
            return true;
        }
        if (this.idQuery != null && this.idQuery.isBound(param)) {
            return true;
        }
        return this.countQuery.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param.getName() == null) {
            Query query = this.parameterToQuery.get(Integer.toString(param.getPosition())).getQuery((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            return (T)query.getParameterValue(param.getPosition().intValue());
        }
        if (Character.isDigit(param.getName().charAt(0))) {
            Query query = this.parameterToQuery.get(param.getName()).getQuery((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
            return (T)query.getParameterValue(Integer.parseInt(param.getName()));
        }
        Query query = this.parameterToQuery.get(param.getName()).getQuery((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
        return (T)query.getParameterValue(param.getName());
    }

    public Object getParameterValue(String name) {
        Query query = this.parameterToQuery.get(name).getQuery((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
        return query.getParameterValue(name);
    }

    public Object getParameterValue(int position) {
        Query query = this.parameterToQuery.get(Integer.toString(position)).getQuery((Query)this.countQuery, (Query)this.idQuery, (Query)this.objectQuery);
        return query.getParameterValue(position);
    }

    public Parameter<?> getParameter(int position) {
        Parameter<?> param = this.parameters.get(Integer.toString(position));
        if (param == null) {
            throw new IllegalArgumentException("Couldn't find parameter with position '" + position + "'!");
        }
        return param;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        Parameter<?> param = this.getParameter(position);
        if (!param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException("The parameter at position '" + position + "' has the type '" + param.getParameterType().getName() + "' which is not assignable to requested type '" + type.getName() + "'");
        }
        return param;
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushMode) {
        this.objectQuery.setFlushMode(flushMode);
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.objectQuery.getFlushMode();
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        this.objectQuery.setLockMode(lockMode);
        return this;
    }

    public LockModeType getLockMode() {
        return this.objectQuery.getLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        throw new PersistenceException("Unsupported unwrap: " + cls.getName());
    }

    private static enum ParameterLocation {
        COUNT{

            @Override
            public ParameterLocation andId() {
                return COUNT_ID;
            }

            @Override
            public ParameterLocation andObject() {
                return COUNT_OBJECT;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Collections.singletonList(countQuery);
            }
        }
        ,
        COUNT_ID{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return COUNT_ID_OBJECT;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(countQuery, idQuery);
            }
        }
        ,
        COUNT_ID_OBJECT{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(countQuery, idQuery, objectQuery);
            }
        }
        ,
        COUNT_OBJECT{

            @Override
            public ParameterLocation andId() {
                return COUNT_ID_OBJECT;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return countQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(countQuery, objectQuery);
            }
        }
        ,
        ID{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return ID_OBJECT;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return idQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Collections.singletonList(idQuery);
            }
        }
        ,
        ID_OBJECT{

            @Override
            public ParameterLocation andId() {
                return this;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return idQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Arrays.asList(idQuery, objectQuery);
            }
        }
        ,
        OBJECT{

            @Override
            public ParameterLocation andId() {
                return ID_OBJECT;
            }

            @Override
            public ParameterLocation andObject() {
                return this;
            }

            @Override
            public Query getQuery(Query countQuery, Query idQuery, Query objectQuery) {
                return objectQuery;
            }

            @Override
            public List<Query> getQueries(Query countQuery, Query idQuery, Query objectQuery) {
                return Collections.singletonList(objectQuery);
            }
        };


        public abstract ParameterLocation andId();

        public abstract ParameterLocation andObject();

        public abstract Query getQuery(Query var1, Query var2, Query var3);

        public abstract List<Query> getQueries(Query var1, Query var2, Query var3);
    }
}

