/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.lang.ValueRetriever;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExtendedParameter;
import com.blazebit.persistence.impl.ParameterRegistrationVisitor;
import com.blazebit.persistence.impl.ParameterUnregistrationVisitor;
import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class ParameterManager {
    private static final String PREFIX = "param_";
    private int counter;
    private final Map<String, ParameterImpl<?>> parameters = new HashMap();
    private final Map<String, String> valuesParameters = new HashMap<String, String>();
    private final ParameterRegistrationVisitor parameterRegistrationVisitor = new ParameterRegistrationVisitor(this);
    private final ParameterUnregistrationVisitor parameterUnregistrationVisitor = new ParameterUnregistrationVisitor(this);
    private int positionalOffset = -1;

    public void collectParameterRegistrations(Expression expression, ClauseType clauseType) {
        try {
            this.parameterRegistrationVisitor.setClauseType(clauseType);
            expression.accept((Expression.Visitor)this.parameterRegistrationVisitor);
        }
        finally {
            this.parameterRegistrationVisitor.setClauseType(null);
        }
    }

    public void collectParameterUnregistrations(Expression expression, ClauseType clauseType) {
        try {
            this.parameterUnregistrationVisitor.setClauseType(clauseType);
            expression.accept((Expression.Visitor)this.parameterUnregistrationVisitor);
        }
        finally {
            this.parameterUnregistrationVisitor.setClauseType(null);
        }
    }

    void applyFrom(ParameterManager parameterManager) {
        this.counter = parameterManager.counter;
        this.parameters.putAll(parameterManager.parameters);
        this.valuesParameters.putAll(parameterManager.valuesParameters);
        this.positionalOffset = parameterManager.positionalOffset;
    }

    Set<String> getParameterListNames(Query q) {
        return this.getParameterListNames(q, Collections.EMPTY_SET);
    }

    Set<String> getParameterListNames(Query q, Set<String> skippedParameters) {
        HashSet<String> parameterListNames = new HashSet<String>();
        this.collectParameterListNames(q, parameterListNames, skippedParameters);
        return parameterListNames;
    }

    void collectParameterListNames(Query q, Set<String> parameterListNames) {
        this.collectParameterListNames(q, parameterListNames, Collections.EMPTY_SET);
    }

    void collectParameterListNames(Query q, Set<String> parameterListNames, Set<String> skippedParameters) {
        for (Parameter p : q.getParameters()) {
            String name = p.getName();
            if (skippedParameters.contains(name) || !this.getParameter(name).isCollectionValued()) continue;
            parameterListNames.add(name);
        }
    }

    void parameterizeQuery(Query q) {
        this.parameterizeQuery(q, Collections.EMPTY_SET);
    }

    void parameterizeQuery(Query q, Set<String> skippedParameters) {
        HashSet<String> requestedValueParameters = new HashSet<String>();
        for (Parameter p : q.getParameters()) {
            String parameterName = p.getName();
            if (parameterName == null) {
                parameterName = p.getPosition().toString();
            }
            if (skippedParameters.contains(parameterName)) continue;
            ParameterImpl<?> parameter = this.parameters.get(parameterName);
            if (parameter == null) {
                String valuesParameter = this.valuesParameters.get(parameterName);
                if (valuesParameter == null) {
                    throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
                }
                requestedValueParameters.add(valuesParameter);
                continue;
            }
            if (parameter.getParameterValue() instanceof ValuesParameterWrapper) {
                if (parameter.getValue() == null) continue;
                q.setParameter(parameterName, parameter.getValue());
                continue;
            }
            parameter.bind(q);
        }
        for (String parameterName : requestedValueParameters) {
            ParameterImpl<?> parameter = this.parameters.get(parameterName);
            parameter.bind(q);
        }
    }

    public ParameterImpl<?> getParameter(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        return parameter;
    }

    public Set<Parameter<?>> getParameters() {
        return new HashSet(this.parameters.values());
    }

    public Map<String, String> getValuesParameters() {
        return Collections.unmodifiableMap(this.valuesParameters);
    }

    public Map<String, ParameterValueTransformer> getTransformers() {
        HashMap<String, ParameterValueTransformer> transformers = new HashMap<String, ParameterValueTransformer>();
        for (Map.Entry<String, ParameterImpl<?>> entry : this.parameters.entrySet()) {
            ParameterValueTransformer transformer = entry.getValue().getTranformer();
            if (transformer == null) continue;
            transformers.put(entry.getKey(), transformer);
        }
        return transformers;
    }

    public Map<String, ValuesParameterBinder> getValuesBinders() {
        HashMap<String, ValuesParameterBinder> binders = new HashMap<String, ValuesParameterBinder>();
        for (Map.Entry<String, ParameterImpl<?>> entry : this.parameters.entrySet()) {
            ParameterValue value = entry.getValue().getParameterValue();
            if (!(value instanceof ValuesParameterWrapper)) continue;
            binders.put(entry.getKey(), ((ValuesParameterWrapper)value).getBinder());
        }
        return binders;
    }

    public boolean containsParameter(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        return this.parameters.containsKey(parameterName);
    }

    public boolean isParameterSet(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        return parameter != null && parameter.getValue() != null;
    }

    public Object getParameterValue(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        return parameter.getValue();
    }

    public ParameterExpression addParameterExpression(Object o, ClauseType clause) {
        String name = this.addParameter(o, o instanceof Collection, clause);
        return new ParameterExpression(name, o, o instanceof Collection);
    }

    private String addParameter(Object o, boolean collectionValued, ClauseType clause) {
        if (o == null) {
            throw new NullPointerException();
        }
        String name = PREFIX + this.counter++;
        this.parameters.put(name, new ParameterImpl<Object>(name, collectionValued, clause, o));
        return name;
    }

    public void addParameterMapping(String parameterName, Object o, ClauseType clause) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        Integer position = this.determinePositionalOffset(parameterName);
        if (position == null) {
            this.parameters.put(parameterName, new ParameterImpl<Object>(parameterName, o instanceof Collection, clause, o));
        } else {
            this.parameters.put(parameterName, new ParameterImpl<Object>(position, o instanceof Collection, clause, o));
        }
    }

    public void registerParameterName(String parameterName, boolean collectionValued, ClauseType clause) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            Integer position = this.determinePositionalOffset(parameterName);
            if (position == null) {
                this.parameters.put(parameterName, new ParameterImpl(parameterName, collectionValued, clause));
            } else {
                this.parameters.put(parameterName, new ParameterImpl(position, collectionValued, clause));
            }
        } else {
            parameter.getClauseTypes().add(clause);
        }
    }

    private Integer determinePositionalOffset(String parameterName) {
        if (Character.isDigit(parameterName.charAt(0))) {
            int value = Integer.parseInt(parameterName);
            this.positionalOffset = Math.max(value, this.positionalOffset);
            return value;
        }
        return null;
    }

    public void unregisterParameterName(String parameterName, ClauseType clauseType) {
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter != null) {
            parameter.getClauseTypes().remove((Object)clauseType);
            if (parameter.getClauseTypes().isEmpty()) {
                this.parameters.remove(parameterName);
            }
        }
    }

    public void registerValuesParameter(String parameterName, Class<?> type, String[][] parameterNames, ValueRetriever<Object, Object>[] pathExpressions) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException("Can't register parameter for VALUES clause because there already exists a parameter with the name: " + parameterName);
        }
        this.parameters.put(parameterName, new ParameterImpl<ValuesParameterWrapper>(parameterName, false, ClauseType.JOIN, new ValuesParameterWrapper(type, parameterNames, pathExpressions)));
        for (int i = 0; i < parameterNames.length; ++i) {
            for (int j = 0; j < parameterNames[i].length; ++j) {
                this.valuesParameters.put(parameterNames[i][j], parameterName);
            }
        }
    }

    public void satisfyParameter(String parameterName, Object parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setValue(parameterValue);
    }

    public void satisfyParameter(String parameterName, Calendar value, TemporalType temporalType) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setValue(new TemporalCalendarParameterWrapper(temporalType, value));
    }

    public void satisfyParameter(String parameterName, Date value, TemporalType temporalType) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setValue(new TemporalDateParameterWrapper(temporalType, value));
    }

    public void setParameterType(String parameterName, Class<?> type) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        ParameterImpl<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        parameter.setParameterType(type);
    }

    public int getPositionalOffset() {
        if (this.positionalOffset == -1) {
            return -1;
        }
        return this.positionalOffset + 1;
    }

    static final class ValuesParameterWrapper
    implements ParameterValue {
        private final Class<?> type;
        private final ValuesParameterBinder binder;
        private Collection<Object> value;

        public ValuesParameterWrapper(Class<?> type, String[][] parameterNames, ValueRetriever<Object, Object>[] pathExpressions) {
            this.type = type;
            this.binder = new ValuesParameterBinder(parameterNames, pathExpressions);
        }

        public ValuesParameterBinder getBinder() {
            return this.binder;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Class<?> getValueType() {
            return Collection.class;
        }

        @Override
        public ParameterValue withValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("null not allowed for VALUES parameter!");
            }
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Value for VALUES parameter must be a collection! Unsupported type: " + value.getClass());
            }
            Collection collection = (Collection)value;
            if (collection.size() > this.binder.size()) {
                throw new IllegalArgumentException("The size of the collection must be lower or equal to the specified size for the VALUES clause.");
            }
            this.value = collection;
            return this;
        }

        @Override
        public void bind(Query query, String name) {
            if (this.value == null) {
                throw new IllegalArgumentException("No values are bound for parameter with name: " + name);
            }
            this.binder.bind(query, this.value);
        }

        @Override
        public void bind(Query query, int position) {
            if (this.value == null) {
                throw new IllegalArgumentException("No values are bound for parameter with position: " + position);
            }
            this.binder.bind(query, this.value);
        }
    }

    static final class TemporalDateParameterWrapper
    implements ParameterValue {
        private final TemporalType type;
        private Date value;

        public TemporalDateParameterWrapper(TemporalType type, Date value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public Date getValue() {
            return this.value;
        }

        @Override
        public ParameterValue withValue(Object value) {
            this.value = (Date)value;
            return this;
        }

        @Override
        public Class<?> getValueType() {
            return Date.class;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value, this.type);
        }

        @Override
        public void bind(Query query, int position) {
            query.setParameter(position, this.value, this.type);
        }
    }

    static final class TemporalCalendarParameterWrapper
    implements ParameterValue {
        private final TemporalType type;
        private Calendar value;

        public TemporalCalendarParameterWrapper(TemporalType type, Calendar value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public Calendar getValue() {
            return this.value;
        }

        @Override
        public ParameterValue withValue(Object value) {
            this.value = (Calendar)value;
            return this;
        }

        @Override
        public Class<?> getValueType() {
            return Calendar.class;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value, this.type);
        }

        @Override
        public void bind(Query query, int position) {
            query.setParameter(position, this.value, this.type);
        }
    }

    static interface ParameterValue {
        public Class<?> getValueType();

        public Object getValue();

        public ParameterValue withValue(Object var1);

        public void bind(Query var1, String var2);

        public void bind(Query var1, int var2);
    }

    static final class ParameterImpl<T>
    implements ExtendedParameter<T> {
        private final String name;
        private final Integer position;
        private final boolean collectionValued;
        private final Set<ClauseType> clauseTypes;
        private Class<T> parameterType;
        private T value;
        private boolean valueSet;
        private ParameterValueTransformer tranformer;

        public ParameterImpl(String name, boolean collectionValued, ClauseType clause) {
            this.name = name;
            this.position = null;
            this.collectionValued = collectionValued;
            this.clauseTypes = EnumSet.of(clause);
        }

        public ParameterImpl(String name, boolean collectionValued, ClauseType clause, T value) {
            this(name, collectionValued, clause);
            this.setValue(value);
        }

        public ParameterImpl(int position, boolean collectionValued, ClauseType clause) {
            this.name = null;
            this.position = position;
            this.collectionValued = collectionValued;
            this.clauseTypes = EnumSet.of(clause);
        }

        public ParameterImpl(int position, boolean collectionValued, ClauseType clause, T value) {
            this(position, collectionValued, clause);
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        @Override
        public boolean isCollectionValued() {
            return this.collectionValued;
        }

        public Set<ClauseType> getClauseTypes() {
            return this.clauseTypes;
        }

        public Class<T> getParameterType() {
            return this.parameterType;
        }

        public void setParameterType(Class<T> parameterType) {
            this.parameterType = parameterType;
        }

        public ParameterValue getParameterValue() {
            if (this.value instanceof ParameterValue) {
                return (ParameterValue)this.value;
            }
            return null;
        }

        public boolean isValueSet() {
            return this.valueSet;
        }

        public T getValue() {
            if (this.value instanceof ParameterValue) {
                return (T)((ParameterValue)this.value).getValue();
            }
            return this.value;
        }

        public void setValue(T value) {
            this.valueSet = true;
            if (this.tranformer != null) {
                value = this.transform(value);
            }
            if (this.value instanceof ParameterValue) {
                this.value = ((ParameterValue)this.value).withValue(value);
            } else {
                this.value = value;
                if (value != null) {
                    this.parameterType = value instanceof ParameterValue ? ((ParameterValue)value).getValueType() : value.getClass();
                }
            }
        }

        private T transform(T value) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                ArrayList<Object> list = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    list.add(this.tranformer.transform(o));
                }
                return (T)list;
            }
            return (T)this.tranformer.transform(value);
        }

        public ParameterValueTransformer getTranformer() {
            return this.tranformer;
        }

        public void setTranformer(ParameterValueTransformer tranformer) {
            if (this.tranformer == null) {
                this.tranformer = tranformer;
                if (this.valueSet) {
                    this.value = this.transform(this.value);
                }
            } else if (!this.tranformer.equals(tranformer)) {
                throw new IllegalStateException("Tried to set parameter value transformer [" + tranformer + "] although a transformer [" + this.tranformer + "] is already set for parameter: " + this.name);
            }
        }

        public void bind(Query q) {
            if (this.valueSet) {
                if (this.value instanceof ParameterValue) {
                    if (this.name == null) {
                        ((ParameterValue)this.value).bind(q, this.position);
                    } else {
                        ((ParameterValue)this.value).bind(q, this.name);
                    }
                } else if (this.name == null) {
                    q.setParameter(this.position.intValue(), this.value);
                } else {
                    q.setParameter(this.name, this.value);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (this.name != null ? !this.name.equals(parameter.getName()) : parameter.getName() != null) {
                return false;
            }
            return this.position != null ? this.position.equals(parameter.getPosition()) : parameter.getPosition() == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
            return result;
        }
    }
}

