/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.RestrictionBuilderExpressionBuilderListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.CaseExpressionBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.JoinOnBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.RootPredicate;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.Collections;
import java.util.List;

public abstract class PredicateManager<T>
extends AbstractManager<ExpressionModifier> {
    protected final ExpressionFactory expressionFactory;
    protected final RootPredicate rootPredicate;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<T>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<T>>();
    private SubqueryBuilderListenerImpl<T> rightSubqueryPredicateBuilderListener;
    private SubqueryBuilderListenerImpl<RestrictionBuilder<T>> superExprLeftSubqueryPredicateBuilderListener;
    private CaseExpressionBuilderListener caseExpressionBuilderListener;
    private MultipleSubqueryInitiator<?> currentMultipleSubqueryInitiator;

    PredicateManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.rootPredicate = new RootPredicate(parameterManager, this.getClauseType());
        this.expressionFactory = expressionFactory;
    }

    void applyFrom(PredicateManager predicateManager) {
        this.rootPredicate.getPredicate().getChildren().addAll(this.subqueryInitFactory.reattachSubqueries(predicateManager.rootPredicate.getPredicate().clone(true)).getChildren());
    }

    RestrictionBuilder<T> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, Expression expr) {
        return (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
    }

    CaseWhenStarterBuilder<RestrictionBuilder<T>> restrictCase(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener((RestrictionBuilderImpl)restrictionBuilder);
        return (CaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new CaseWhenBuilderImpl<RestrictionBuilder>(restrictionBuilder, this.caseExpressionBuilderListener, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
    }

    void restrictExpression(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, Predicate predicate) {
        this.rootPredicate.verifyBuilderEnded();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.getClauseType());
        List children = this.rootPredicate.getPredicate().getChildren();
        children.clear();
        children.add(predicate);
    }

    SimpleCaseWhenStarterBuilder<RestrictionBuilder<T>> restrictSimpleCase(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, Expression caseOperand) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener((RestrictionBuilderImpl)restrictionBuilder);
        return (SimpleCaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new SimpleCaseWhenBuilderImpl<RestrictionBuilder>(restrictionBuilder, this.caseExpressionBuilderListener, this.expressionFactory, caseOperand));
    }

    SubqueryInitiator<RestrictionBuilder<T>> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false);
    }

    SubqueryBuilder<RestrictionBuilder<T>> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, FullQueryBuilder<?, ?> criteriaBuilder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, criteriaBuilder);
    }

    MultipleSubqueryInitiator<RestrictionBuilder<T>> restrictSubqueries(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        RestrictionBuilderImpl<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> restrictionBuilder = this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        MultipleSubqueryInitiatorImpl initiator = new MultipleSubqueryInitiatorImpl(restrictionBuilder, expr, new RestrictionBuilderExpressionBuilderListener(restrictionBuilder), this.subqueryInitFactory);
        return initiator;
    }

    <X> MultipleSubqueryInitiator<X> restrictExpressionSubqueries(X builder, Predicate predicate) {
        this.rootPredicate.verifyBuilderEnded();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.getClauseType());
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(builder, (Expression)predicate, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                List children = PredicateManager.this.rootPredicate.getPredicate().getChildren();
                children.clear();
                children.add((Predicate)builder.getExpression());
                PredicateManager.this.currentMultipleSubqueryInitiator = null;
            }
        }, this.subqueryInitFactory);
        this.currentMultipleSubqueryInitiator = initiator;
        return initiator;
    }

    SubqueryInitiator<RestrictionBuilder<T>> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<RestrictionBuilder<T>>(subqueryAlias, expr);
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.superExprLeftSubqueryPredicateBuilderListener, false);
    }

    SubqueryBuilder<RestrictionBuilder<T>> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<RestrictionBuilder<T>>(subqueryAlias, expr);
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.superExprLeftSubqueryPredicateBuilderListener, false, criteriaBuilder);
    }

    SubqueryInitiator<T> restrictExists(T result) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(result, this.rightSubqueryPredicateBuilderListener, true);
    }

    SubqueryInitiator<T> restrictNotExists(T result) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(result, this.rightSubqueryPredicateBuilderListener, true);
    }

    SubqueryBuilder<T> restrictExists(T result, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryBuilder(result, this.rightSubqueryPredicateBuilderListener, true, criteriaBuilder);
    }

    SubqueryBuilder<T> restrictNotExists(T result, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryBuilder(result, this.rightSubqueryPredicateBuilderListener, true, criteriaBuilder);
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        visitor.visit(this.rootPredicate, this.getClauseType());
    }

    void verifyBuilderEnded() {
        this.rootPredicate.verifyBuilderEnded();
        this.leftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        if (this.rightSubqueryPredicateBuilderListener != null) {
            this.rightSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.superExprLeftSubqueryPredicateBuilderListener != null) {
            this.superExprLeftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.caseExpressionBuilderListener != null) {
            this.caseExpressionBuilderListener.verifyBuilderEnded();
        }
        if (this.currentMultipleSubqueryInitiator != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    void acceptVisitor(Expression.Visitor v) {
        this.rootPredicate.getPredicate().accept(v);
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v) {
        return (X)this.rootPredicate.getPredicate().accept(v);
    }

    boolean hasPredicates() {
        return this.rootPredicate.getPredicate().getChildren().size() > 0;
    }

    void buildClause(StringBuilder sb) {
        this.buildClause(sb, Collections.emptyList());
    }

    void buildClause(StringBuilder sb, List<String> additionalConjuncts) {
        if (!this.hasPredicates() && additionalConjuncts.isEmpty()) {
            return;
        }
        this.queryGenerator.setClauseType(this.getClauseType());
        this.queryGenerator.setQueryBuffer(sb);
        sb.append(' ').append(this.getClauseName()).append(' ');
        int oldLength = sb.length();
        this.applyPredicate(this.queryGenerator);
        this.queryGenerator.setClauseType(null);
        int size = additionalConjuncts.size();
        if (sb.length() != oldLength && size > 0) {
            sb.append(" AND ");
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(additionalConjuncts.get(i));
        }
    }

    void buildClausePredicate(StringBuilder sb) {
        this.buildClausePredicate(sb, Collections.emptyList());
    }

    void buildClausePredicate(StringBuilder sb, List<String> additionalConjuncts) {
        this.queryGenerator.setClauseType(this.getClauseType());
        this.queryGenerator.setQueryBuffer(sb);
        int oldLength = sb.length();
        this.applyPredicate(this.queryGenerator);
        this.queryGenerator.setClauseType(null);
        int size = additionalConjuncts.size();
        if (sb.length() != oldLength && size > 0) {
            sb.append(" AND ");
        }
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(additionalConjuncts.get(i));
        }
    }

    protected abstract String getClauseName();

    void applyPredicate(ResolvingQueryGenerator queryGenerator) {
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
        queryGenerator.generate((Expression)this.rootPredicate.getPredicate());
        queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
    }

    public JoinOnBuilder<?> startOnBuilder(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        return this.rootPredicate.startBuilder(new JoinOnBuilderImpl(builder, this.rootPredicate, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }
}

