/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.OrderByElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;

public class ResolvingQueryGenerator
extends SimpleQueryGenerator {
    protected String aliasPrefix;
    private boolean resolveSelectAliases = true;
    private Set<JoinNode> renderedJoinNodes;
    private ClauseType clauseType;
    private Map<JoinNode, Boolean> treatedJoinNodesForConstraints;
    private final AliasManager aliasManager;
    private final ParameterManager parameterManager;
    private final EntityMetamodel metamodel;
    private final AssociationParameterTransformerFactory parameterTransformerFactory;
    private final JpaProvider jpaProvider;
    private final Map<String, JpqlFunction> registeredFunctions;
    private final Map<String, String> registeredFunctionsNames;

    public ResolvingQueryGenerator(AliasManager aliasManager, ParameterManager parameterManager, AssociationParameterTransformerFactory parameterTransformerFactory, EntityMetamodel metamodel, JpaProvider jpaProvider, Map<String, JpqlFunction> registeredFunctions) {
        this.aliasManager = aliasManager;
        this.parameterManager = parameterManager;
        this.metamodel = metamodel;
        this.parameterTransformerFactory = parameterTransformerFactory;
        this.jpaProvider = jpaProvider;
        this.registeredFunctions = registeredFunctions;
        this.registeredFunctionsNames = new HashMap<String, String>(registeredFunctions.size());
        for (Map.Entry<String, JpqlFunction> registeredFunctionEntry : registeredFunctions.entrySet()) {
            this.registeredFunctionsNames.put(registeredFunctionEntry.getKey().toLowerCase(), registeredFunctionEntry.getKey());
        }
    }

    public void generate(Expression expression) {
        if (expression instanceof NullExpression && this.clauseType != ClauseType.SET) {
            this.sb.append(this.jpaProvider.getNullExpression());
            return;
        }
        expression.accept((Expression.Visitor)this);
    }

    public void visit(MapValueExpression expression) {
        String valueFunction = this.jpaProvider.getCollectionValueFunction();
        if (valueFunction != null) {
            this.sb.append(valueFunction);
            this.sb.append('(');
            expression.getPath().accept((Expression.Visitor)this);
            this.sb.append(')');
        } else {
            expression.getPath().accept((Expression.Visitor)this);
        }
    }

    public void visit(FunctionExpression expression) {
        Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
        if (expression instanceof AggregateExpression) {
            this.treatedJoinNodesForConstraints = null;
        }
        if (com.blazebit.persistence.parser.util.ExpressionUtils.isOuterFunction((FunctionExpression)expression)) {
            ((Expression)expression.getExpressions().get(0)).accept((Expression.Visitor)this);
        } else if (ExpressionUtils.isFunctionFunctionExpression(expression)) {
            List arguments = expression.getExpressions();
            String literalFunctionName = ExpressionUtils.unwrapStringLiteral(((Expression)arguments.get(0)).toString());
            String resolvedFunctionName = this.resolveRenderedFunctionName(literalFunctionName);
            List<Object> argumentsWithoutFunctionName = arguments.size() > 1 ? arguments.subList(1, arguments.size()) : Collections.emptyList();
            this.renderFunctionFunction(resolvedFunctionName, argumentsWithoutFunctionName);
        } else if (this.isCountStarFunction(expression)) {
            this.renderCountStar();
        } else {
            super.visit(expression);
        }
        this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
    }

    private String resolveRenderedFunctionName(String literalFunctionName) {
        String registeredFunctionName = this.registeredFunctionsNames.get(literalFunctionName.toLowerCase());
        return registeredFunctionName == null ? literalFunctionName : registeredFunctionName;
    }

    protected void renderCountStar() {
        if (this.jpaProvider.supportsCountStar()) {
            this.sb.append("COUNT(*)");
        } else {
            this.renderFunctionFunction(this.resolveRenderedFunctionName("COUNT_STAR"), Collections.emptyList());
        }
    }

    public void visit(SubqueryExpression expression) {
        this.sb.append('(');
        if (expression.getSubquery() instanceof SubqueryInternalBuilder) {
            boolean isSimple;
            SubqueryInternalBuilder subquery = (SubqueryInternalBuilder)expression.getSubquery();
            boolean hasFirstResult = subquery.getFirstResult() != 0;
            boolean hasMaxResults = subquery.getMaxResults() != Integer.MAX_VALUE;
            boolean hasLimit = hasFirstResult || hasMaxResults;
            boolean hasSetOperations = subquery instanceof BaseFinalSetOperationBuilder;
            boolean bl = isSimple = !hasLimit && !hasSetOperations;
            if (isSimple) {
                this.sb.append(subquery.getQueryString());
            } else if (hasSetOperations) {
                this.asExpression((AbstractCommonQueryBuilder)((Object)subquery)).accept((Expression.Visitor)this);
            } else {
                this.asExpression((AbstractCommonQueryBuilder)((Object)subquery)).accept((Expression.Visitor)this);
            }
        } else {
            this.sb.append(expression.getSubquery().getQueryString());
        }
        this.sb.append(')');
    }

    protected Expression asExpression(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            BaseFinalSetOperationBuilderImpl operationBuilder = (BaseFinalSetOperationBuilderImpl)queryBuilder;
            SetOperationManager operationManager = operationBuilder.setOperationManager;
            if (operationManager.getOperator() == null || !operationManager.hasSetOperations()) {
                return this.asExpression(operationManager.getStartQueryBuilder());
            }
            ArrayList<Object> setOperationArgs = new ArrayList<Object>(operationManager.getSetOperations().size() + 2);
            StringBuilder nameSb = new StringBuilder();
            nameSb.append("SET_");
            nameSb.append(operationManager.getOperator().name());
            setOperationArgs.add(new StringLiteral(nameSb.toString()));
            setOperationArgs.add(this.asExpression(operationManager.getStartQueryBuilder()));
            List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> setOperands = operationManager.getSetOperations();
            int operandsSize = setOperands.size();
            for (int i = 0; i < operandsSize; ++i) {
                setOperationArgs.add(this.asExpression(setOperands.get(i)));
            }
            List<OrderByElement> orderByElements = operationBuilder.getOrderByElements();
            if (orderByElements.size() > 0) {
                setOperationArgs.add(new StringLiteral("ORDER_BY"));
                int orderByElementsSize = orderByElements.size();
                for (int i = 0; i < orderByElementsSize; ++i) {
                    StringBuilder argSb = new StringBuilder(20);
                    argSb.append(orderByElements.get(i).toString());
                    setOperationArgs.add(new StringLiteral(argSb.toString()));
                }
            }
            if (operationBuilder.hasLimit()) {
                if (operationBuilder.maxResults != Integer.MAX_VALUE) {
                    setOperationArgs.add(new StringLiteral("LIMIT"));
                    setOperationArgs.add(new NumericLiteral(Integer.toString(operationBuilder.maxResults), NumericType.INTEGER));
                }
                if (operationBuilder.firstResult != 0) {
                    setOperationArgs.add(new StringLiteral("OFFSET"));
                    setOperationArgs.add(new NumericLiteral(Integer.toString(operationBuilder.firstResult), NumericType.INTEGER));
                }
            }
            FunctionExpression functionExpr = new FunctionExpression("FUNCTION", setOperationArgs);
            return functionExpr;
        }
        String queryString = queryBuilder.getQueryString();
        final StringBuilder subquerySb = new StringBuilder(queryString.length() + 2);
        subquerySb.append(queryString);
        SubqueryExpression expression = new SubqueryExpression(new Subquery(){

            public String getQueryString() {
                return subquerySb.toString();
            }
        });
        if (queryBuilder.hasLimit()) {
            boolean hasFirstResult = queryBuilder.getFirstResult() != 0;
            boolean hasMaxResults = queryBuilder.getMaxResults() != Integer.MAX_VALUE;
            ArrayList<Object> arguments = new ArrayList<Object>(2);
            arguments.add(new StringLiteral("LIMIT"));
            arguments.add(expression);
            if (!hasMaxResults) {
                throw new IllegalArgumentException("First result without max results is not supported!");
            }
            arguments.add(new NumericLiteral(Integer.toString(queryBuilder.getMaxResults()), NumericType.INTEGER));
            if (hasFirstResult) {
                arguments.add(new NumericLiteral(Integer.toString(queryBuilder.getFirstResult()), NumericType.INTEGER));
            }
            expression = new FunctionExpression("FUNCTION", arguments);
        }
        return expression;
    }

    protected void renderFunctionFunction(String functionName, List<Expression> arguments) {
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        if (this.registeredFunctions.containsKey(functionName)) {
            this.sb.append(this.jpaProvider.getCustomFunctionInvocation(functionName, arguments.size()));
            if (arguments.size() > 0) {
                arguments.get(0).accept((Expression.Visitor)this);
                for (int i = 1; i < arguments.size(); ++i) {
                    this.sb.append(",");
                    arguments.get(i).accept((Expression.Visitor)this);
                }
            }
            this.sb.append(')');
        } else if (this.jpaProvider.supportsJpa21()) {
            this.sb.append("FUNCTION('");
            this.sb.append(functionName);
            this.sb.append('\'');
            for (int i = 0; i < arguments.size(); ++i) {
                this.sb.append(',');
                arguments.get(i).accept((Expression.Visitor)this);
            }
            this.sb.append(')');
        } else {
            throw new IllegalArgumentException("Unknown function [" + functionName + "] is used!");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    private boolean isCountStarFunction(FunctionExpression expression) {
        return expression instanceof AggregateExpression && expression.getExpressions().isEmpty() && "COUNT".equalsIgnoreCase(expression.getFunctionName());
    }

    public void visit(TreatExpression expression) {
        if (this.jpaProvider.supportsRootTreat()) {
            super.visit(expression);
        } else if (this.jpaProvider.supportsSubtypePropertyResolving()) {
            expression.getExpression().accept((Expression.Visitor)this);
        } else {
            throw new IllegalArgumentException("Can not render treat expression[" + expression.toString() + "] as the JPA provider does not support it!");
        }
    }

    public void visit(PathExpression expression) {
        SelectInfo selectAliasInfo;
        AliasInfo aliasInfo;
        if (this.resolveSelectAliases && expression.getBaseNode() == null && (aliasInfo = this.aliasManager.getAliasInfo(expression.toString())) != null && aliasInfo instanceof SelectInfo && (selectAliasInfo = (SelectInfo)aliasInfo).getExpression() instanceof PathExpression) {
            PathExpression clonedSelectExpression = (PathExpression)selectAliasInfo.getExpression().clone(false);
            clonedSelectExpression.setUsedInCollectionFunction(expression.isUsedInCollectionFunction());
            clonedSelectExpression.setPathReference(((PathExpression)selectAliasInfo.getExpression()).getPathReference());
            clonedSelectExpression.accept((Expression.Visitor)this);
            return;
        }
        JoinNode baseNode = (JoinNode)expression.getBaseNode();
        if (baseNode == null) {
            super.visit(expression);
        } else {
            String field = expression.getField();
            if (field == null) {
                if (expression.isUsedInCollectionFunction() || this.renderAbsolutePath(expression)) {
                    super.visit(expression);
                } else {
                    boolean valueFunction;
                    boolean bl = valueFunction = this.needsValueFunction(expression, baseNode, field) && this.jpaProvider.getCollectionValueFunction() != null;
                    if (valueFunction) {
                        this.sb.append(this.jpaProvider.getCollectionValueFunction());
                        this.sb.append('(');
                    }
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendAlias(this.sb);
                    if (valueFunction) {
                        this.sb.append(')');
                    }
                }
            } else {
                boolean addTypeCaseWhen;
                List<JoinNode> treatedJoinNodes = baseNode.getJoinNodesForTreatConstraint();
                if (this.treatedJoinNodesForConstraints != null) {
                    for (JoinNode node : treatedJoinNodes) {
                        this.treatedJoinNodesForConstraints.put(node, Boolean.FALSE);
                    }
                }
                ManagedType<?> baseNodeType = baseNode.getManagedType();
                boolean bl = addTypeCaseWhen = !treatedJoinNodes.isEmpty() && baseNodeType instanceof EntityType && this.jpaProvider.needsTypeConstraintForColumnSharing() && this.jpaProvider.isColumnShared((EntityType)baseNodeType, field);
                if (addTypeCaseWhen) {
                    this.sb.append("CASE WHEN ");
                    boolean first = true;
                    for (int i = 0; i < treatedJoinNodes.size(); ++i) {
                        JoinNode treatedJoinNode = treatedJoinNodes.get(i);
                        if (this.jpaProvider.supportsTreatJoin() && treatedJoinNode.isTreatJoinNode()) continue;
                        if (first) {
                            first = false;
                        } else {
                            this.sb.append(" AND ");
                        }
                        this.sb.append("TYPE(");
                        this.sb.append(treatedJoinNode.getAlias());
                        this.sb.append(") = ");
                        this.sb.append(treatedJoinNode.getTreatType().getName());
                    }
                    this.sb.append(" THEN ");
                }
                boolean valueFunction = this.needsValueFunction(expression, baseNode, field) && this.jpaProvider.getCollectionValueFunction() != null;
                boolean renderTreat = this.jpaProvider.supportsRootTreat();
                if (valueFunction) {
                    this.sb.append(this.jpaProvider.getCollectionValueFunction());
                    this.sb.append('(');
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendAlias(this.sb, renderTreat);
                    this.sb.append(')');
                    this.sb.append(".").append(field);
                } else {
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendDeReference(this.sb, field, renderTreat);
                }
                if (addTypeCaseWhen) {
                    this.sb.append(" END");
                }
            }
        }
    }

    private boolean needsValueFunction(PathExpression expression, JoinNode baseNode, String field) {
        return !expression.isCollectionKeyPath() && baseNode.getParentTreeNode() != null && baseNode.getParentTreeNode().isMap() && (field == null || this.jpaProvider.supportsCollectionValueDereference());
    }

    private boolean renderAbsolutePath(PathExpression expression) {
        JoinNode baseNode = (JoinNode)expression.getBaseNode();
        return this.renderedJoinNodes != null && !this.renderedJoinNodes.contains(baseNode);
    }

    protected boolean needsParenthesisForCaseResult(Expression expression) {
        return expression instanceof ArithmeticExpression;
    }

    protected String getBooleanConditionalExpression(boolean value) {
        return this.jpaProvider.getBooleanConditionalExpression(value);
    }

    protected String getBooleanExpression(boolean value) {
        return this.jpaProvider.getBooleanExpression(value);
    }

    protected String escapeCharacter(char character) {
        return this.jpaProvider.escapeCharacter(character);
    }

    public void visit(ParameterExpression expression) {
        boolean needsBrackets;
        boolean bl = needsBrackets = this.jpaProvider.needsBracketsForListParamter() && expression.isCollectionValued();
        if (needsBrackets) {
            this.sb.append('(');
        }
        super.visit(expression);
        if (needsBrackets) {
            this.sb.append(')');
        }
    }

    protected String getLiteralParameterValue(ParameterExpression expression) {
        Object value = expression.getValue();
        if (value == null) {
            value = this.parameterManager.getParameterValue(expression.getName());
        }
        if (value != null) {
            TypeConverter converter = TypeUtils.getConverter(value.getClass());
            return converter.toString(value);
        }
        return null;
    }

    public void setResolveSelectAliases(boolean replaceSelectAliases) {
        this.resolveSelectAliases = replaceSelectAliases;
    }

    public void setAliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
    }

    public void setRenderedJoinNodes(Set<JoinNode> renderedJoinNodes) {
        this.renderedJoinNodes = renderedJoinNodes;
    }

    public void setClauseType(ClauseType clauseType) {
        this.clauseType = clauseType;
    }

    public void visit(ArrayExpression expression) {
    }

    public void visit(InPredicate predicate) {
        if (predicate.getRight().size() == 1 && this.jpaProvider.needsAssociationToIdRewriteInOnClause() && this.clauseType == ClauseType.JOIN) {
            Expression right = (Expression)predicate.getRight().get(0);
            if (right instanceof ParameterExpression) {
                ParameterExpression parameterExpression = (ParameterExpression)right;
                Type<?> associationType = this.getAssociationType(predicate.getLeft(), right);
                if (associationType instanceof EntityType) {
                    this.renderEquality(predicate.getLeft(), right, predicate.isNegated(), PredicateQuantifier.ONE);
                } else {
                    super.visit(predicate);
                }
            } else if (right instanceof PathExpression) {
                this.renderEquality(predicate.getLeft(), right, predicate.isNegated(), PredicateQuantifier.ONE);
            } else {
                super.visit(predicate);
            }
        } else {
            super.visit(predicate);
        }
    }

    private Type<?> getAssociationType(Expression expression1, Expression expression2) {
        if (expression1 instanceof PathExpression) {
            return ((PathExpression)expression1).getPathReference().getType();
        }
        return ((PathExpression)expression2).getPathReference().getType();
    }

    public void visit(EqPredicate predicate) {
        this.renderEquality(predicate.getLeft(), predicate.getRight(), predicate.isNegated(), predicate.getQuantifier());
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    private void renderEquality(Expression left, Expression right, boolean negated, PredicateQuantifier quantifier) {
        String operator = negated ? " <> " : " = ";
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PLAIN);
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        if (this.jpaProvider.needsAssociationToIdRewriteInOnClause() && this.clauseType == ClauseType.JOIN) {
            boolean rewritten = this.renderAssociationIdIfPossible(left);
            this.sb.append(operator);
            if (quantifier != PredicateQuantifier.ONE) {
                this.sb.append(quantifier.toString());
            }
            if (rewritten |= this.renderAssociationIdIfPossible(right)) {
                this.rewriteToIdParam(left);
                this.rewriteToIdParam(right);
            }
        } else {
            left.accept((Expression.Visitor)this);
            this.sb.append(operator);
            if (quantifier != PredicateQuantifier.ONE) {
                this.sb.append(quantifier.toString());
            }
            right.accept((Expression.Visitor)this);
        }
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    private boolean renderAssociationIdIfPossible(Expression expression) {
        expression.accept((Expression.Visitor)this);
        if (expression instanceof PathExpression) {
            Type pathType;
            PathExpression pathExpression = (PathExpression)expression;
            if ((!this.jpaProvider.needsBrokenAssociationToIdRewriteInOnClause() || pathExpression.getBaseNode() != null && pathExpression.getField() != null) && (pathType = pathExpression.getPathReference().getType()) instanceof IdentifiableType) {
                String idName = JpaMetamodelUtils.getIdAttribute((IdentifiableType)((IdentifiableType)pathType)).getName();
                this.sb.append('.');
                this.sb.append(idName);
                return true;
            }
        }
        return false;
    }

    private void rewriteToIdParam(Expression expression) {
        if (!(expression instanceof ParameterExpression)) {
            return;
        }
        ParameterExpression parameterExpression = (ParameterExpression)expression;
        ParameterManager.ParameterImpl<?> param = this.parameterManager.getParameter(parameterExpression.getName());
        param.setTranformer(this.parameterTransformerFactory.getToIdTransformer());
    }

    public void visit(IsNullPredicate predicate) {
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        predicate.getExpression().accept((Expression.Visitor)this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT NULL");
            this.flipTreatedJoinNodeConstraints();
        } else {
            this.sb.append(" IS NULL");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    public void visit(IsEmptyPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(MemberOfPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(LikePredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(BetweenPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(ExistsPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(GtPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(GePredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(LtPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(LePredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    protected void visitWhenClauseCondition(Expression condition) {
        if (!(condition instanceof Predicate) || condition instanceof CompoundPredicate) {
            condition.accept((Expression.Visitor)this);
            return;
        }
        Predicate p = (Predicate)condition;
        int startPosition = this.sb.length();
        Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
        this.treatedJoinNodesForConstraints = new LinkedHashMap<JoinNode, Boolean>();
        p.accept((Expression.Visitor)this);
        this.insertTreatJoinConstraint(startPosition, this.sb.length());
        this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
    }

    public void visit(CompoundPredicate predicate) {
        boolean parenthesisRequired;
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldConditionalContext = this.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        boolean bl = parenthesisRequired = predicate.getChildren().size() > 1;
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
            if (parenthesisRequired) {
                this.sb.append('(');
            }
        }
        if (predicate.getChildren().size() == 1) {
            int startPosition = this.sb.length();
            Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
            this.treatedJoinNodesForConstraints = new LinkedHashMap<JoinNode, Boolean>();
            ((Predicate)predicate.getChildren().get(0)).accept((Expression.Visitor)this);
            this.insertTreatJoinConstraint(startPosition, this.sb.length());
            this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
            return;
        }
        int startLen = this.sb.length();
        String operator = " " + predicate.getOperator().toString() + " ";
        List children = predicate.getChildren();
        int size = children.size();
        Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
        this.treatedJoinNodesForConstraints = new LinkedHashMap<JoinNode, Boolean>();
        for (int i = 0; i < size; ++i) {
            int endPosition;
            int startPosition = this.sb.length();
            Predicate child = (Predicate)children.get(i);
            if (child instanceof CompoundPredicate && ((CompoundPredicate)child).getOperator() != predicate.getOperator() && !child.isNegated()) {
                this.sb.append("(");
                int len = this.sb.length();
                child.accept((Expression.Visitor)this);
                if (len == this.sb.length()) {
                    this.sb.deleteCharAt(len - 1);
                    endPosition = this.sb.length();
                } else {
                    this.sb.append(")");
                    endPosition = this.sb.length();
                    this.sb.append(operator);
                }
            } else {
                child.accept((Expression.Visitor)this);
                endPosition = this.sb.length();
                this.sb.append(operator);
            }
            this.insertTreatJoinConstraint(startPosition, endPosition);
            this.treatedJoinNodesForConstraints.clear();
        }
        this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
        if (startLen < this.sb.length()) {
            this.sb.delete(this.sb.length() - operator.length(), this.sb.length());
        }
        if (predicate.isNegated() && parenthesisRequired) {
            this.sb.append(')');
        }
        this.setBooleanLiteralRenderingContext(oldConditionalContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    private void flipTreatedJoinNodeConstraints() {
        if (this.treatedJoinNodesForConstraints != null) {
            for (Map.Entry<JoinNode, Boolean> entry : this.treatedJoinNodesForConstraints.entrySet()) {
                if (entry.getValue() == Boolean.TRUE) {
                    entry.setValue(Boolean.FALSE);
                    continue;
                }
                entry.setValue(Boolean.TRUE);
            }
        }
    }

    private boolean insertTreatJoinConstraint(int startPosition, int endPosition) {
        if (!this.treatedJoinNodesForConstraints.isEmpty()) {
            StringBuilder treatConditionBuilder = new StringBuilder(this.treatedJoinNodesForConstraints.size() * 40);
            treatConditionBuilder.append('(');
            for (Map.Entry<JoinNode, Boolean> entry : this.treatedJoinNodesForConstraints.entrySet()) {
                JoinNode node = entry.getKey();
                if (this.jpaProvider.supportsTreatJoin() && node.isTreatJoinNode()) continue;
                treatConditionBuilder.append("TYPE(");
                treatConditionBuilder.append(node.getAlias());
                if (entry.getValue() == Boolean.TRUE) {
                    treatConditionBuilder.append(") <> ");
                    treatConditionBuilder.append(node.getTreatType().getName());
                    treatConditionBuilder.append(" OR ");
                    continue;
                }
                treatConditionBuilder.append(") = ");
                treatConditionBuilder.append(node.getTreatType().getName());
                treatConditionBuilder.append(" AND ");
            }
            if (treatConditionBuilder.length() > 1) {
                this.sb.insert(endPosition, ')');
                this.sb.insert(startPosition, treatConditionBuilder);
                return true;
            }
        }
        return false;
    }
}

