/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EntitySelectResolveVisitor;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.GroupByExpressionGatheringVisitor;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoVisitor;
import com.blazebit.persistence.impl.SelectObjectBuilderEndedListener;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.SubqueryBuilderImpl;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.object.ClassObjectBuilder;
import com.blazebit.persistence.impl.builder.object.ConstructorObjectBuilder;
import com.blazebit.persistence.impl.builder.object.SelectObjectBuilderImpl;
import com.blazebit.persistence.impl.builder.object.TupleObjectBuilder;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.spi.JpaProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;

public class SelectManager<T>
extends AbstractManager<SelectInfo> {
    private final List<SelectInfo> selectInfos = new ArrayList<SelectInfo>();
    private boolean distinct = false;
    private boolean hasDefaultSelect;
    private boolean hasSizeSelect;
    private SelectObjectBuilderImpl<?> selectObjectBuilder;
    private ObjectBuilder<T> objectBuilder;
    private int objectBuilderStartIndex;
    private SubqueryBuilderListenerImpl<?> subqueryBuilderListener;
    private final Map<String, Integer> selectAliasToPositionMap = new HashMap<String, Integer>();
    private final SelectObjectBuilderEndedListenerImpl selectObjectBuilderEndedListener = new SelectObjectBuilderEndedListenerImpl();
    private CaseExpressionBuilderListener caseExpressionBuilderListener;
    private final GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor;
    private final JoinManager joinManager;
    private final AliasManager aliasManager;
    private final ExpressionFactory expressionFactory;
    private final JpaProvider jpaProvider;
    private final MainQuery mainQuery;
    private final Class<?> resultClazz;

    public SelectManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, JoinManager joinManager, AliasManager aliasManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, JpaProvider jpaProvider, MainQuery mainQuery, GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor, Class<?> resultClazz) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.groupByExpressionGatheringVisitor = groupByExpressionGatheringVisitor;
        this.joinManager = joinManager;
        this.aliasManager = aliasManager;
        this.expressionFactory = expressionFactory;
        this.jpaProvider = jpaProvider;
        this.mainQuery = mainQuery;
        this.resultClazz = resultClazz;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.SELECT;
    }

    void verifyBuilderEnded() {
        if (this.subqueryBuilderListener != null) {
            this.subqueryBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.caseExpressionBuilderListener != null) {
            this.caseExpressionBuilderListener.verifyBuilderEnded();
        }
        this.selectObjectBuilderEndedListener.verifyBuilderEnded();
    }

    ObjectBuilder<T> getSelectObjectBuilder() {
        if (this.objectBuilder == null && this.resultClazz.equals(Tuple.class)) {
            return new TupleObjectBuilder(this.selectInfos, this.selectAliasToPositionMap);
        }
        return this.objectBuilder;
    }

    public int getObjectBuilderStartIndex() {
        return this.objectBuilderStartIndex;
    }

    public List<SelectInfo> getSelectInfos() {
        return this.selectInfos;
    }

    public boolean containsSizeSelect() {
        return this.hasSizeSelect;
    }

    public Set<JoinNode> collectFetchOwners() {
        HashSet<JoinNode> fetchOwners = new HashSet<JoinNode>();
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            Expression expression = selectInfo.getExpression();
            if (expression instanceof MapValueExpression) {
                expression = ((MapValueExpression)expression).getPath();
            } else if (expression instanceof MapKeyExpression) {
                expression = ((MapKeyExpression)expression).getPath();
            }
            if (!(expression instanceof PathExpression)) continue;
            PathExpression pathExpression = (PathExpression)expression;
            JoinNode node = (JoinNode)pathExpression.getBaseNode();
            if (pathExpression.getField() != null) continue;
            fetchOwners.add(node);
        }
        if (size == 0) {
            fetchOwners.add(this.joinManager.getRootNodeOrFail("Empty select not allowed when having multiple roots!"));
        }
        return fetchOwners;
    }

    void acceptVisitor(Expression.Visitor v) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            selectInfo.getExpression().accept(v);
        }
    }

    void acceptVisitor(SelectInfoVisitor v) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            selectInfo.accept(v);
        }
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v, X stopValue) {
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            if (!stopValue.equals(selectInfo.getExpression().accept(v))) continue;
            return stopValue;
        }
        return null;
    }

    void buildGroupByClauses(EntityMetamodel m, Set<String> clauses) {
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<PathExpression> componentPaths = new LinkedHashSet<PathExpression>();
        EntitySelectResolveVisitor resolveVisitor = new EntitySelectResolveVisitor(m, componentPaths);
        if (this.selectInfos.isEmpty()) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail("Empty select not allowed when having multiple roots!");
            String rootAlias = rootNode.getAliasInfo().getAlias();
            List<PathElementExpression> path = Arrays.asList(new PropertyExpression(rootAlias));
            resolveVisitor.visit(new PathExpression(path, (PathReference)new SimplePathReference(rootNode, null, rootNode.getNodeType()), false, false));
            this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
            this.queryGenerator.setQueryBuffer(sb);
            for (PathExpression pathExpr : componentPaths) {
                sb.setLength(0);
                this.queryGenerator.generate((Expression)pathExpr);
                clauses.add(sb.toString());
            }
            this.queryGenerator.setClauseType(null);
        } else {
            List<SelectInfo> infos = this.selectInfos;
            int size = this.selectInfos.size();
            for (int i = 0; i < size; ++i) {
                SelectInfo selectInfo = infos.get(i);
                componentPaths.clear();
                selectInfo.getExpression().accept((Expression.Visitor)resolveVisitor);
                if (componentPaths.size() > 0) {
                    this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
                    this.queryGenerator.setQueryBuffer(sb);
                    for (PathExpression pathExpr : componentPaths) {
                        sb.setLength(0);
                        this.queryGenerator.generate((Expression)pathExpr);
                        clauses.add(sb.toString());
                    }
                    this.queryGenerator.setClauseType(null);
                    continue;
                }
                Set<Expression> extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions(selectInfo.getExpression());
                if (extractedGroupByExpressions.isEmpty()) continue;
                this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
                this.queryGenerator.setQueryBuffer(sb);
                for (Expression expression : extractedGroupByExpressions) {
                    sb.setLength(0);
                    this.queryGenerator.generate(expression);
                    clauses.add(sb.toString());
                }
                this.queryGenerator.setClauseType(null);
            }
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.groupByExpressionGatheringVisitor.clear();
    }

    void buildSelect(StringBuilder sb, boolean isInsertInto) {
        sb.append("SELECT ");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        if (size == 0) {
            JoinNode rootNode = this.joinManager.getRootNodeOrFail("Empty select not allowed when having multiple roots!");
            rootNode.appendAlias(sb);
        } else {
            this.queryGenerator.setClauseType(ClauseType.SELECT);
            this.queryGenerator.setQueryBuffer(sb);
            SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
            SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = !this.mainQuery.getQueryConfiguration().isParameterAsLiteralRenderingEnabled() || isInsertInto ? this.queryGenerator.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER) : this.queryGenerator.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.LITERAL);
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                this.applySelect(this.queryGenerator, sb, infos.get(i));
            }
            this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
            this.queryGenerator.setParameterRenderingMode(oldParameterRenderingMode);
            this.queryGenerator.setClauseType(null);
        }
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super SelectInfo> visitor) {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            visitor.visit(selectInfo, ClauseType.SELECT);
        }
    }

    <X> SubqueryInitiator<X> selectSubquery(X builder, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SelectSubqueryBuilderListener(selectAlias);
        SubqueryInitiator<X> initiator = this.subqueryInitFactory.createSubqueryInitiator(builder, this.subqueryBuilderListener, false);
        this.subqueryBuilderListener.onInitiatorStarted(initiator);
        return initiator;
    }

    <X> SubqueryInitiator<X> selectSubquery(X builder, String subqueryAlias, Expression expression, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SuperExpressionSelectSubqueryBuilderListener(subqueryAlias, expression, selectAlias);
        SubqueryInitiator<X> initiator = this.subqueryInitFactory.createSubqueryInitiator(builder, this.subqueryBuilderListener, false);
        this.subqueryBuilderListener.onInitiatorStarted(initiator);
        return initiator;
    }

    <X> MultipleSubqueryInitiator<X> selectSubqueries(X builder, Expression expression, final String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(builder, expression, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                SelectManager.this.select(builder.getExpression(), selectAlias);
            }
        }, this.subqueryInitFactory);
        return initiator;
    }

    <X> SubqueryBuilder<X> selectSubquery(X builder, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SelectSubqueryBuilderListener(selectAlias);
        SubqueryBuilderImpl<X> subqueryBuilder = this.subqueryInitFactory.createSubqueryBuilder(builder, this.subqueryBuilderListener, false, criteriaBuilder);
        this.subqueryBuilderListener.onBuilderStarted(subqueryBuilder);
        return subqueryBuilder;
    }

    <X> SubqueryBuilder<X> selectSubquery(X builder, String subqueryAlias, Expression expression, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.subqueryBuilderListener = new SuperExpressionSelectSubqueryBuilderListener(subqueryAlias, expression, selectAlias);
        SubqueryBuilderImpl<X> subqueryBuilder = this.subqueryInitFactory.createSubqueryBuilder(builder, this.subqueryBuilderListener, false, criteriaBuilder);
        this.subqueryBuilderListener.onBuilderStarted(subqueryBuilder);
        return subqueryBuilder;
    }

    <X> CaseWhenStarterBuilder<X> selectCase(X builder, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(selectAlias);
        return (CaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new CaseWhenBuilderImpl<X>(builder, this.caseExpressionBuilderListener, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, ClauseType.SELECT));
    }

    <X> SimpleCaseWhenStarterBuilder<X> selectSimpleCase(X builder, String selectAlias, Expression caseOperandExpression) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(selectAlias);
        return (SimpleCaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new SimpleCaseWhenBuilderImpl<X>(builder, this.caseExpressionBuilderListener, this.expressionFactory, caseOperandExpression));
    }

    Class<?> getExpectedQueryResultType() {
        if (this.selectInfos.size() > 1) {
            return Object[].class;
        }
        return this.jpaProvider.getDefaultQueryResultType();
    }

    void select(Expression expr, String selectAlias) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        this.selectInternal(expr, selectAlias);
    }

    private void selectInternal(Expression expr, String selectAlias) {
        SelectInfo selectInfo = new SelectInfo(expr, selectAlias, this.aliasManager);
        if (selectAlias != null) {
            this.aliasManager.registerAliasInfo(selectInfo);
            this.selectAliasToPositionMap.put(selectAlias, this.selectAliasToPositionMap.size());
        }
        this.selectInfos.add(selectInfo);
        this.hasSizeSelect = this.hasSizeSelect || ExpressionUtils.containsSizeExpression(selectInfo.getExpression());
        this.registerParameterExpressions(expr);
    }

    <Y, X extends AbstractFullQueryBuilder<?, ?, ?, ?, ?>> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(X builder, Class<Y> clazz) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        this.objectBuilderStartIndex = this.selectInfos.size();
        this.selectObjectBuilder = this.selectObjectBuilderEndedListener.startBuilder(new SelectObjectBuilderImpl<X>(builder, this.selectObjectBuilderEndedListener, this.subqueryInitFactory, this.expressionFactory));
        this.objectBuilder = new ClassObjectBuilder<Y>(clazz);
        return this.selectObjectBuilder;
    }

    <Y, X extends AbstractFullQueryBuilder<?, ?, ?, ?, ?>> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(X builder, Constructor<Y> constructor) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        this.objectBuilderStartIndex = this.selectInfos.size();
        this.selectObjectBuilder = this.selectObjectBuilderEndedListener.startBuilder(new SelectObjectBuilderImpl<X>(builder, this.selectObjectBuilderEndedListener, this.subqueryInitFactory, this.expressionFactory));
        this.objectBuilder = new ConstructorObjectBuilder<Y>(constructor);
        return this.selectObjectBuilder;
    }

    <X extends FullQueryBuilder<?, X>> void selectNew(X builder, ObjectBuilder<?> objectBuilder) {
        this.verifyBuilderEnded();
        this.clearDefaultSelects();
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        this.objectBuilderStartIndex = this.selectInfos.size();
        objectBuilder.applySelects(builder);
        this.objectBuilder = objectBuilder;
    }

    void setDefaultSelect(List<SelectInfo> selectInfos) {
        if (!this.selectInfos.isEmpty()) {
            throw new IllegalStateException("Can't set default select when explicit select items are already set!");
        }
        this.hasDefaultSelect = true;
        for (int i = 0; i < selectInfos.size(); ++i) {
            SelectInfo selectInfo = selectInfos.get(i);
            String selectAlias = selectInfo.getAlias();
            Expression expr = this.subqueryInitFactory.reattachSubqueries(selectInfo.getExpression().clone(false));
            this.selectInternal(expr, selectAlias);
        }
    }

    void distinct() {
        this.distinct = true;
    }

    boolean isDistinct() {
        return this.distinct;
    }

    private void clearDefaultSelects() {
        if (!this.hasDefaultSelect) {
            return;
        }
        for (int i = 0; i < this.selectInfos.size(); ++i) {
            SelectInfo selectInfo = this.selectInfos.get(i);
            this.aliasManager.unregisterAliasInfoForBottomLevel(selectInfo);
            this.unregisterParameterExpressions(selectInfo.getExpression());
        }
        this.selectAliasToPositionMap.clear();
        this.selectInfos.clear();
        this.hasDefaultSelect = false;
        this.hasSizeSelect = false;
    }

    private void applySelect(ResolvingQueryGenerator queryGenerator, StringBuilder sb, SelectInfo select) {
        queryGenerator.generate(select.getExpression());
        if (select.alias != null) {
            sb.append(" AS ").append(select.alias);
        }
    }

    private class SelectObjectBuilderEndedListenerImpl
    implements SelectObjectBuilderEndedListener {
        private SelectObjectBuilder<?> currentBuilder;

        private SelectObjectBuilderEndedListenerImpl() {
        }

        protected void verifyBuilderEnded() {
            if (this.currentBuilder != null) {
                throw new IllegalStateException("A builder was not ended properly.");
            }
        }

        protected <X extends SelectObjectBuilder<?>> X startBuilder(X builder) {
            if (this.currentBuilder != null) {
                throw new IllegalStateException("There was an attempt to start a builder but a previous builder was not ended.");
            }
            this.currentBuilder = builder;
            return builder;
        }

        @Override
        public void onBuilderEnded(Collection<Map.Entry<Expression, String>> expressions) {
            if (this.currentBuilder == null) {
                throw new IllegalStateException("There was an attempt to end a builder that was not started or already closed.");
            }
            this.currentBuilder = null;
            for (Map.Entry<Expression, String> e : expressions) {
                SelectManager.this.select(e.getKey(), e.getValue());
            }
        }
    }

    private class CaseExpressionBuilderListener
    extends ExpressionBuilderEndedListenerImpl {
        private final String selectAlias;

        public CaseExpressionBuilderListener(String selectAlias) {
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(ExpressionBuilder builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select(builder.getExpression(), this.selectAlias);
        }
    }

    private class SuperExpressionSelectSubqueryBuilderListener<X>
    extends SuperExpressionSubqueryBuilderListener<X> {
        private final String selectAlias;

        public SuperExpressionSelectSubqueryBuilderListener(String subqueryAlias, Expression superExpression, String selectAlias) {
            super(subqueryAlias, superExpression);
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select(this.superExpression, this.selectAlias);
        }
    }

    private class SelectSubqueryBuilderListener<X>
    extends SubqueryBuilderListenerImpl<X> {
        private final String selectAlias;

        public SelectSubqueryBuilderListener(String selectAlias) {
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select((Expression)new SubqueryExpression(builder), this.selectAlias);
        }
    }
}

