/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.MiddleOngoingSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.List;

public class SetOperationManager {
    private AbstractCommonQueryBuilder<?, ?, ?, ?, ?> startQueryBuilder;
    private SetOperationType operator;
    private final boolean nested;
    private final List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> setOperations;

    SetOperationManager(SetOperationType operator, boolean nested) {
        this.operator = operator;
        this.nested = nested;
        this.setOperations = new ArrayList();
    }

    List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> getSetOperations() {
        return this.setOperations;
    }

    boolean hasSetOperations() {
        return this.setOperations.size() > 0;
    }

    boolean isNested() {
        return this.nested;
    }

    boolean isEmpty() {
        if (this.startQueryBuilder != null && !this.startQueryBuilder.isEmpty()) {
            return false;
        }
        for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder : this.setOperations) {
            if (builder.isEmpty()) continue;
            return false;
        }
        return true;
    }

    AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getStartQueryBuilder() {
        return this.startQueryBuilder;
    }

    void setStartQueryBuilder(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> startQueryBuilder) {
        this.startQueryBuilder = startQueryBuilder;
    }

    SetOperationType getOperator() {
        return this.operator;
    }

    void setOperator(SetOperationType operator) {
        this.operator = operator;
    }

    void addSetOperation(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (this.startQueryBuilder.isEmpty()) {
            this.startQueryBuilder = queryBuilder;
            this.operator = null;
        } else {
            this.setOperations.add(queryBuilder);
        }
    }

    public <T, Z extends AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> void replaceOperand(MiddleOngoingSetOperationCTECriteriaBuilder<T, Z> oldOperand, Z newOperand) {
        if (this.startQueryBuilder == oldOperand) {
            this.startQueryBuilder = newOperand;
            return;
        }
        for (int i = 0; i < this.setOperations.size(); ++i) {
            if (this.setOperations.get(i) != oldOperand) continue;
            this.setOperations.set(i, newOperand);
            return;
        }
        throw new IllegalStateException("Could not replace old with new operand!");
    }

    public boolean removeOperand(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> operand) {
        if (this.startQueryBuilder == operand) {
            this.startQueryBuilder = null;
            return true;
        }
        if (this.startQueryBuilder instanceof BaseFinalSetOperationBuilderImpl && ((BaseFinalSetOperationBuilderImpl)this.startQueryBuilder).setOperationManager.removeOperand(operand)) {
            return true;
        }
        for (int i = 0; i < this.setOperations.size(); ++i) {
            if (this.setOperations.get(i) == operand) {
                this.setOperations.remove(i);
                return true;
            }
            if (!(this.setOperations.get(i) instanceof BaseFinalSetOperationBuilderImpl)) continue;
            BaseFinalSetOperationBuilderImpl finalSetOperationBuilder = (BaseFinalSetOperationBuilderImpl)this.setOperations.get(i);
            if (!finalSetOperationBuilder.setOperationManager.removeOperand(operand)) continue;
            if (finalSetOperationBuilder.isEmpty()) {
                this.setOperations.remove(i);
            }
            return true;
        }
        return false;
    }
}

