/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryBuilderImpl;
import com.blazebit.persistence.impl.SubqueryBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorImpl;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.InplaceModificationResultVisitorAdapter;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import java.util.Arrays;

public class SubqueryInitiatorFactory {
    private final MainQuery mainQuery;
    private final AliasManager aliasManager;
    private final JoinManager parentJoinManager;
    private final SubqueryReattachingTransformationVisitor subqueryTransformationVisitor;

    public SubqueryInitiatorFactory(MainQuery mainQuery, AliasManager aliasManager, JoinManager parentJoinManager) {
        this.mainQuery = mainQuery;
        this.aliasManager = aliasManager;
        this.parentJoinManager = parentJoinManager;
        this.subqueryTransformationVisitor = new SubqueryReattachingTransformationVisitor();
    }

    public <T> SubqueryInitiator<T> createSubqueryInitiator(T result, SubqueryBuilderListener<T> listener, boolean inExists) {
        return new SubqueryInitiatorImpl<T>(this.mainQuery, this.aliasManager, this.parentJoinManager, result, listener, inExists);
    }

    public <T> SubqueryBuilderImpl<T> createSubqueryBuilder(T result, SubqueryBuilderListener<T> listener, boolean inExists, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.createSubqueryBuilder(result, listener, inExists, (AbstractCommonQueryBuilder)criteriaBuilder);
    }

    public <T> SubqueryBuilderImpl<T> createSubqueryBuilder(T result, SubqueryBuilderListener<T> listener, boolean inExists, SubqueryBuilderImpl<?> subqueryBuilder) {
        return this.createSubqueryBuilder(result, listener, inExists, (AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)subqueryBuilder);
    }

    private <T> SubqueryBuilderImpl<T> createSubqueryBuilder(T result, SubqueryBuilderListener<T> listener, boolean inExists, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        SubqueryBuilderImpl<T> subqueryBuilder = new SubqueryBuilderImpl<T>(this.mainQuery, this.aliasManager, this.parentJoinManager, this.mainQuery.subqueryExpressionFactory, result, listener);
        this.mainQuery.cteManager.applyFrom(builder.mainQuery.cteManager);
        subqueryBuilder.joinManager.applyFrom(builder.joinManager);
        subqueryBuilder.whereManager.applyFrom(builder.whereManager);
        subqueryBuilder.havingManager.applyFrom(builder.havingManager);
        subqueryBuilder.groupByManager.applyFrom(builder.groupByManager);
        subqueryBuilder.orderByManager.applyFrom(builder.orderByManager);
        subqueryBuilder.setFirstResult(builder.firstResult);
        subqueryBuilder.setMaxResults(builder.maxResults);
        if (inExists) {
            subqueryBuilder.selectManager.setDefaultSelect(Arrays.asList(new SelectInfo(this.mainQuery.expressionFactory.createArithmeticExpression("1"))));
        } else {
            subqueryBuilder.selectManager.setDefaultSelect(builder.selectManager.getSelectInfos());
        }
        if (listener != null) {
            listener.onBuilderStarted(subqueryBuilder);
        }
        return subqueryBuilder;
    }

    public <T extends Expression> T reattachSubqueries(T expression) {
        return (T)((Expression)expression.accept((Expression.ResultVisitor)this.subqueryTransformationVisitor));
    }

    class SubqueryReattachingTransformationVisitor
    extends InplaceModificationResultVisitorAdapter {
        private boolean inExists;

        SubqueryReattachingTransformationVisitor() {
        }

        public Expression visit(ExistsPredicate predicate) {
            this.inExists = true;
            try {
                Expression expression = super.visit(predicate);
                return expression;
            }
            finally {
                this.inExists = false;
            }
        }

        public Expression visit(SubqueryExpression expression) {
            AbstractCommonQueryBuilder subqueryBuilder = (AbstractCommonQueryBuilder)expression.getSubquery();
            SubqueryBuilderImpl builder = SubqueryInitiatorFactory.this.createSubqueryBuilder(null, null, this.inExists, subqueryBuilder);
            return new SubqueryExpression((Subquery)builder);
        }
    }
}

