/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.lang.ValueRetriever;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.Query;

public class ValuesParameterBinder {
    private final String[][] parameterNames;
    private final ValueRetriever<Object, Object>[] pathExpressions;

    public ValuesParameterBinder(String[][] parameterNames, ValueRetriever<Object, Object>[] pathExpressions) {
        this.parameterNames = parameterNames;
        this.pathExpressions = pathExpressions;
    }

    public void bind(Query query, Collection<Object> value) {
        Iterator<Object> iterator = value.iterator();
        for (int i = 0; i < this.parameterNames.length; ++i) {
            int j;
            Object element;
            if (iterator.hasNext() && (element = iterator.next()) != null) {
                for (j = 0; j < this.parameterNames[i].length; ++j) {
                    query.setParameter(this.parameterNames[i][j], this.pathExpressions[j].getValue(element));
                }
                continue;
            }
            for (j = 0; j < this.parameterNames[i].length; ++j) {
                query.setParameter(this.parameterNames[i][j], null);
            }
        }
    }

    public String[][] getParameterNames() {
        return this.parameterNames;
    }

    public ValueRetriever<Object, Object>[] getPathExpressions() {
        return this.pathExpressions;
    }

    public int size() {
        return this.parameterNames.length;
    }
}

