/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenOrBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;

public class CaseWhenAndThenBuilderImpl<T extends CaseWhenBuilder<?>>
extends PredicateBuilderEndedListenerImpl
implements CaseWhenAndThenBuilder<T>,
ExpressionBuilder {
    private final T result;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private final CompoundPredicate predicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND);
    private final ExpressionBuilderEndedListener listener;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<CaseWhenAndThenBuilder<T>>>();
    private WhenClauseExpression whenClause;

    public CaseWhenAndThenBuilderImpl(T result, ExpressionBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager, ClauseType clauseType) {
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.listener = listener;
        this.clauseType = clauseType;
    }

    public RestrictionBuilder<CaseWhenAndThenBuilder<T>> and(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        return (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> andSubquery() {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> andSubquery(String subqueryAlias, String expression) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener, false);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> andSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, criteriaBuilder);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> andSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression, true));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener, false, criteriaBuilder);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> andSubqueries(String expression) {
        return this.startMultipleSubqueryInitiator(this.expressionFactory.createArithmeticExpression(expression));
    }

    private MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> startMultipleSubqueryInitiator(Expression expression) {
        this.verifyBuilderEnded();
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
        MultipleSubqueryInitiatorImpl<RestrictionBuilder<CaseWhenAndThenBuilder<T>>> initiator = new MultipleSubqueryInitiatorImpl<RestrictionBuilder<CaseWhenAndThenBuilder<T>>>(restrictionBuilder, expression, null, this.subqueryInitFactory);
        return initiator;
    }

    public SubqueryInitiator<CaseWhenAndThenBuilder<T>> andExists() {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightSubqueryPredicateBuilderListener, true);
    }

    public SubqueryInitiator<CaseWhenAndThenBuilder<T>> andNotExists() {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightSubqueryPredicateBuilderListener, true);
    }

    public SubqueryBuilder<CaseWhenAndThenBuilder<T>> andExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryBuilder(this, rightSubqueryPredicateBuilderListener, true, criteriaBuilder);
    }

    public SubqueryBuilder<CaseWhenAndThenBuilder<T>> andNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryBuilder(this, rightSubqueryPredicateBuilderListener, true, criteriaBuilder);
    }

    public CaseWhenOrBuilder<CaseWhenAndThenBuilder<T>> or() {
        return this.startBuilder(new CaseWhenOrBuilderImpl<CaseWhenAndThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType));
    }

    @Override
    public void onBuilderEnded(PredicateBuilder builder) {
        super.onBuilderEnded(builder);
        this.predicate.getChildren().add(builder.getPredicate());
    }

    public T thenExpression(String expression) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No and clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, this.expressionFactory.createScalarExpression(expression));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T then(Object value) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No and clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, (Expression)this.parameterManager.addParameterExpression(value, this.clauseType));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public Expression getExpression() {
        return this.whenClause;
    }
}

