/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.SimpleCaseWhenBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import java.util.ArrayList;
import java.util.List;

public class SimpleCaseWhenBuilderImpl<T>
implements SimpleCaseWhenBuilder<T>,
ExpressionBuilder {
    private final T result;
    private final Expression caseOperandExpression;
    private final List<WhenClauseExpression> whenExpressions;
    private SimpleCaseExpression expression;
    private final ExpressionFactory expressionFactory;
    private final ExpressionBuilderEndedListener listener;

    public SimpleCaseWhenBuilderImpl(T result, ExpressionBuilderEndedListener listener, ExpressionFactory expressionFactory, Expression caseOperandExpression) {
        this.result = result;
        this.caseOperandExpression = caseOperandExpression;
        this.whenExpressions = new ArrayList<WhenClauseExpression>();
        this.expressionFactory = expressionFactory;
        this.listener = listener;
    }

    public SimpleCaseWhenBuilder<T> when(String condition, String thenExpression) {
        this.whenExpressions.add(new WhenClauseExpression(this.expressionFactory.createScalarExpression(condition), this.expressionFactory.createScalarExpression(thenExpression)));
        return this;
    }

    public T otherwise(String elseExpression) {
        if (this.whenExpressions.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        this.expression = new SimpleCaseExpression(this.caseOperandExpression, this.whenExpressions, this.expressionFactory.createScalarExpression(elseExpression));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }
}

