/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import java.io.Serializable;
import java.util.List;

public class KeysetExtractionObjectBuilder<T>
implements ObjectBuilder<T> {
    private final int keysetSize;
    private final KeysetMode keysetMode;
    private final boolean unwrap;
    private Object[] first;
    private Object[] last;

    public KeysetExtractionObjectBuilder(int keysetSize, KeysetMode keysetMode, boolean unwrap) {
        this.keysetSize = keysetSize;
        this.keysetMode = keysetMode;
        this.unwrap = unwrap;
    }

    public T build(Object[] tuple) {
        if (this.keysetMode == KeysetMode.PREVIOUS) {
            if (this.first == null) {
                this.first = tuple;
                this.last = tuple;
            } else {
                this.first = tuple;
            }
        } else if (this.first == null) {
            this.first = tuple;
            this.last = tuple;
        } else {
            this.last = tuple;
        }
        if (this.unwrap) {
            return (T)tuple[0];
        }
        Object[] newTuple = new Object[tuple.length - this.keysetSize];
        System.arraycopy(tuple, 0, newTuple, 0, newTuple.length);
        return (T)newTuple;
    }

    public Serializable[] getLowest() {
        if (this.first == null) {
            return null;
        }
        return KeysetPaginationHelper.extractKey(this.first, this.first.length - this.keysetSize);
    }

    public Serializable[] getHighest() {
        if (this.last == null) {
            return null;
        }
        return KeysetPaginationHelper.extractKey(this.last, this.last.length - this.keysetSize);
    }

    public List<T> buildList(List<T> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
    }
}

