/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.CaseWhenThenBuilder;
import com.blazebit.persistence.EscapeBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.LikeBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryAndExpressionBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.EscapeBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;

public class LikeBuilderImpl<T>
extends SubqueryAndExpressionBuilderListener<T>
implements LikeBuilder<T>,
PredicateBuilder {
    private final Expression leftExpression;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final T result;
    private final PredicateBuilderEndedListener listener;
    private final EscapeBuilderImpl.EscapeBuilderImplEndedListener escapeBuilderEndedListener = new EscapeBuilderImpl.EscapeBuilderImplEndedListener(){

        @Override
        public void onBuilderEnded(EscapeBuilderImpl<?> builder) {
            super.onBuilderEnded(builder);
            LikeBuilderImpl.this.likePredicate = new LikePredicate(LikeBuilderImpl.this.leftExpression, LikeBuilderImpl.this.patternExpression, LikeBuilderImpl.this.caseSensitive, builder.getEscapeCharacter(), LikeBuilderImpl.this.negated);
            LikeBuilderImpl.this.listener.onBuilderEnded(LikeBuilderImpl.this);
        }
    };
    private boolean negated;
    private boolean caseSensitive;
    private LikePredicate likePredicate;
    private Expression patternExpression;

    public LikeBuilderImpl(T result, PredicateBuilderEndedListener listener, Expression leftExpression, ExpressionFactory expressionFactory, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, ClauseType clauseType, boolean negated, boolean caseSensitive) {
        this.result = result;
        this.listener = listener;
        this.leftExpression = leftExpression;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.clauseType = clauseType;
        this.subqueryInitFactory = subqueryInitFactory;
        this.negated = negated;
        this.caseSensitive = caseSensitive;
    }

    public EscapeBuilder<T> value(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.patternExpression = this.parameterManager.addParameterExpression(value, this.clauseType);
        return this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
    }

    public EscapeBuilder<T> expression(String expression) {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        this.patternExpression = this.expressionFactory.createStringExpression(expression);
        return this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
    }

    public MultipleSubqueryInitiator<EscapeBuilder<T>> subqueries(String expression) {
        Expression expr = this.expressionFactory.createStringExpression(expression);
        ExpressionToEscapeBuilderEndedListener listener = new ExpressionToEscapeBuilderEndedListener();
        return new MultipleSubqueryInitiatorImpl<EscapeBuilder<T>>(new EscapeBuilderImpl<T>(listener, this.result), expr, listener, this.subqueryInitFactory);
    }

    public RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhen(String expression) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).when(expression);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubquery() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery();
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubquery(String subqueryAlias, String expression) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery(subqueryAlias, expression);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubqueries(String expression) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubqueries(expression);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery(criteriaBuilder);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery(subqueryAlias, expression, criteriaBuilder);
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhenExists() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenExists();
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhenNotExists() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenNotExists();
    }

    public SubqueryBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhenExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenExists(criteriaBuilder);
    }

    public SubqueryBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhenNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenNotExists(criteriaBuilder);
    }

    public CaseWhenAndThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>> caseWhenAnd() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenAnd();
    }

    public CaseWhenOrThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>> caseWhenOr() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenOr();
    }

    public SimpleCaseWhenBuilder<EscapeBuilder<T>> simpleCase(String caseOperand) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new SimpleCaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.expressionFactory, this.expressionFactory.createCaseOperandExpression(caseOperand)));
    }

    public LikePredicate getPredicate() {
        return this.likePredicate;
    }

    @Override
    protected void verifyBuilderEnded() {
        super.verifyBuilderEnded();
        this.escapeBuilderEndedListener.verifyBuilderEnded();
    }

    private class ExpressionToEscapeBuilderEndedListener
    extends EscapeBuilderImpl.EscapeBuilderImplEndedListener
    implements ExpressionBuilderEndedListener {
        private Expression patternExpression;

        private ExpressionToEscapeBuilderEndedListener() {
        }

        @Override
        public void onBuilderEnded(ExpressionBuilder builder) {
            this.patternExpression = builder.getExpression();
        }

        @Override
        public void onBuilderEnded(EscapeBuilderImpl<?> builder) {
            super.onBuilderEnded(builder);
            LikeBuilderImpl.this.likePredicate = new LikePredicate(LikeBuilderImpl.this.leftExpression, this.patternExpression, LikeBuilderImpl.this.caseSensitive, builder.getEscapeCharacter(), LikeBuilderImpl.this.negated);
            LikeBuilderImpl.this.listener.onBuilderEnded(LikeBuilderImpl.this);
        }
    }
}

