/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;

public class RootPredicate
extends PredicateBuilderEndedListenerImpl
implements ExpressionModifier {
    private final CompoundPredicate predicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND);
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;

    public RootPredicate(ParameterManager parameterManager, ClauseType clauseType) {
        this.parameterManager = parameterManager;
        this.clauseType = clauseType;
    }

    @Override
    public void onBuilderEnded(PredicateBuilder builder) {
        super.onBuilderEnded(builder);
        Predicate predicate = builder.getPredicate();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.clauseType);
        this.predicate.getChildren().add(predicate);
    }

    public CompoundPredicate getPredicate() {
        return this.predicate;
    }

    public void set(Expression expression) {
        if (!(expression instanceof CompoundPredicate)) {
            throw new IllegalArgumentException("Expected compound predicate!");
        }
        if (expression != this.predicate) {
            this.predicate.getChildren().clear();
            this.predicate.getChildren().addAll(((CompoundPredicate)expression).getChildren());
        }
    }

    public Expression get() {
        return this.predicate;
    }

    public ExpressionModifier clone() {
        return this;
    }
}

