/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.AbstractDbmsLimitHandler;
import com.blazebit.persistence.impl.util.SqlUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DB2DbmsLimitHandler
extends AbstractDbmsLimitHandler {
    public DB2DbmsLimitHandler() {
        super(40);
    }

    public DB2DbmsLimitHandler(int length) {
        super(length);
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public boolean limitIncludesOffset() {
        return true;
    }

    public void applySql(StringBuilder sqlSb, boolean isSubquery, String limit, String offset) {
        int appendIndex;
        if (offset != null) {
            int selectIndex = SqlUtils.indexOfSelect(sqlSb);
            String[] aliases = SqlUtils.getSelectItemAliases(sqlSb, selectIndex);
            int[] finalTableSubqueryBounds = SqlUtils.indexOfFinalTableSubquery(sqlSb, selectIndex);
            StringBuilder selectClauseSb = new StringBuilder(80 + aliases.length * 20);
            selectClauseSb.append("select ");
            LinkedHashMap<Integer, String> sequences = null;
            for (int i = 0; i < aliases.length; ++i) {
                if (aliases[i].regionMatches(true, 0, "next value for ", 0, 15)) {
                    if (sequences == null) {
                        sequences = new LinkedHashMap<Integer, String>();
                    }
                    sequences.put(i, aliases[i]);
                }
                selectClauseSb.append(aliases[i]);
                selectClauseSb.append(',');
            }
            selectClauseSb.setCharAt(selectClauseSb.length() - 1, ' ');
            selectClauseSb.append("from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( ");
            sqlSb.ensureCapacity(sqlSb.length() + 120 + selectClauseSb.length());
            sqlSb.insert(Math.max(selectIndex, finalTableSubqueryBounds[0]), selectClauseSb);
            int removedChars = 0;
            if (sequences != null) {
                int startIndex = selectIndex + selectClauseSb.length();
                for (Map.Entry sequenceEntry : sequences.entrySet()) {
                    int currentIdx;
                    String sequence = (String)sequenceEntry.getValue();
                    int index = sqlSb.indexOf(sequence, startIndex);
                    if ((Integer)sequenceEntry.getKey() == 0) {
                        currentIdx = index + sequence.length();
                        while (Character.isWhitespace(sqlSb.charAt(currentIdx))) {
                            ++currentIdx;
                        }
                        int diff = ++currentIdx - index;
                        sqlSb.replace(index, currentIdx, "");
                        startIndex -= diff;
                        removedChars += diff;
                        continue;
                    }
                    currentIdx = index - 1;
                    while (Character.isWhitespace(sqlSb.charAt(currentIdx))) {
                        --currentIdx;
                    }
                    int end = index + sequence.length();
                    int diff = end - currentIdx;
                    sqlSb.replace(currentIdx, end, "");
                    startIndex -= end - currentIdx;
                    removedChars += diff;
                }
            }
            appendIndex = finalTableSubqueryBounds[1] + selectClauseSb.length() - removedChars;
        } else {
            appendIndex = SqlUtils.indexOfFinalTableSubquery(sqlSb, 0)[1];
            StringBuilder limitSb = new StringBuilder(40);
            limitSb.append(" fetch first ").append(limit).append(" rows only");
            sqlSb.insert(appendIndex, limitSb);
        }
        if (offset != null) {
            if (limit != null) {
                StringBuilder limitSb = new StringBuilder(120);
                limitSb.append(" fetch first ");
                limitSb.append(limit);
                limitSb.append(" rows only ) as inner2_ ) as inner1_ where rownumber_ > ");
                limitSb.append(offset);
                limitSb.append(" order by rownumber_");
                sqlSb.insert(appendIndex, limitSb);
            } else {
                StringBuilder limitSb = new StringBuilder(30);
                limitSb.append(" ) where rownumber_ > ").append(offset);
                sqlSb.insert(appendIndex, limitSb);
            }
        }
    }

    public int bindLimitParametersAtEndOfQuery(Integer limit, Integer offset, PreparedStatement statement, int index) throws SQLException {
        return 0;
    }
}

