/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.cast;

import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.TemplateRenderer;

public class CastFunction
implements JpqlFunction {
    private final String functionName;
    private final Class<?> castType;
    private final TemplateRenderer renderer;

    public CastFunction(Class<?> castType, DbmsDialect dbmsDialect) {
        this.functionName = "CAST_" + castType.getSimpleName().toUpperCase();
        this.castType = castType;
        this.renderer = new TemplateRenderer("cast(?1 as " + dbmsDialect.getSqlType(castType) + ")");
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return this.castType;
    }

    public void render(FunctionRenderContext context) {
        if (context.getArgumentsSize() != 1) {
            throw new RuntimeException("The " + this.functionName + " function needs exactly one argument <expression>! args=" + context);
        }
        this.renderer.start(context).addArgument(0).build();
    }
}

