/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.count;

import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCountFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "count_tuple";
    public static final String DISTINCT_QUALIFIER = "DISTINCT";

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return Long.class;
    }

    protected Count getCount(FunctionRenderContext context) {
        if (context.getArgumentsSize() == 0) {
            throw new RuntimeException("The count_tuple function needs at least one argument!");
        }
        boolean distinct = false;
        int startIndex = 0;
        String maybeDistinct = context.getArgument(0);
        if ("'DISTINCT'".equalsIgnoreCase(maybeDistinct)) {
            distinct = true;
            ++startIndex;
        }
        ArrayList<String> expressions = new ArrayList<String>(context.getArgumentsSize());
        for (int i = startIndex; i < context.getArgumentsSize(); ++i) {
            expressions.addAll(SqlUtils.getExpressionItems(context.getArgument(i)));
        }
        if (expressions.isEmpty()) {
            throw new RuntimeException("The count_tuple function needs at least one expression to count! args=" + context);
        }
        return new Count(distinct, expressions);
    }

    protected static final class Count {
        private final boolean distinct;
        private final List<String> arguments;

        public Count(boolean distinct, List<String> arguments) {
            this.distinct = distinct;
            this.arguments = arguments;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public List<String> getArguments() {
            return this.arguments;
        }
    }
}

