/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.count;

import com.blazebit.persistence.impl.function.count.AbstractCountFunction;
import com.blazebit.persistence.spi.FunctionRenderContext;
import java.util.List;

public class CountTupleEmulationFunction
extends AbstractCountFunction {
    private static final String DISTINCT = "distinct ";
    private static final boolean ANSI_SQL = true;
    private final String concatOperator;

    public CountTupleEmulationFunction() {
        this("||");
    }

    public CountTupleEmulationFunction(String concatOperator) {
        this.concatOperator = concatOperator;
    }

    public void render(FunctionRenderContext context) {
        List<String> args;
        int size;
        AbstractCountFunction.Count count = this.getCount(context);
        context.addChunk("count(");
        if (count.isDistinct()) {
            context.addChunk(DISTINCT);
        }
        if ((size = (args = count.getArguments()).size()) > 1) {
            if (count.isDistinct()) {
                context.addChunk("coalesce(nullif(coalesce(");
                context.addChunk(args.get(0));
                int argumentNumber = 1;
                int i = 1;
                while (i < size) {
                    context.addChunk(" " + this.concatOperator + " ''");
                    context.addChunk(", '\\0'), ''), '\\0" + argumentNumber + "') " + this.concatOperator + " '\\0' " + this.concatOperator + " coalesce(nullif(coalesce(");
                    context.addChunk(args.get(i));
                    ++i;
                    ++argumentNumber;
                }
                context.addChunk(" " + this.concatOperator + " ''");
                context.addChunk(", '\\0'), ''), '\\0" + argumentNumber + "')");
            } else {
                context.addChunk("case when ");
                context.addChunk(args.get(0));
                context.addChunk(" is null");
                for (int i = 1; i < size; ++i) {
                    context.addChunk(" or ");
                    context.addChunk(args.get(i));
                    context.addChunk(" is null");
                }
                context.addChunk(" then null else 1 end");
            }
        } else {
            context.addChunk(count.getArguments().get(0));
        }
        context.addChunk(")");
    }
}

