/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.count;

import com.blazebit.persistence.impl.function.count.AbstractCountFunction;
import com.blazebit.persistence.spi.FunctionRenderContext;
import java.util.List;

public class CountTupleFunction
extends AbstractCountFunction {
    private static final String COUNT = "count(";
    private static final String DISTINCT = "distinct ";
    private static final String COUNT_DISTINCT = "count(distinct ";

    public void render(FunctionRenderContext context) {
        AbstractCountFunction.Count count = this.getCount(context);
        if (count.isDistinct()) {
            context.addChunk(COUNT_DISTINCT);
        } else {
            context.addChunk(COUNT);
        }
        List<String> args = count.getArguments();
        int size = args.size();
        if (size > 1) {
            context.addChunk("(");
            context.addChunk(args.get(0));
            for (int i = 1; i < context.getArgumentsSize(); ++i) {
                context.addChunk(", ");
                context.addChunk(args.get(i));
            }
            context.addChunk(")");
        } else {
            context.addChunk(args.get(0));
        }
        context.addChunk(")");
    }
}

