/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.groupconcat;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.TemplateRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGroupConcatFunction
implements JpqlFunction {
    protected final TemplateRenderer renderer;

    public AbstractGroupConcatFunction(String template) {
        this.renderer = new TemplateRenderer(template);
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return String.class;
    }

    protected GroupConcat getGroupConcat(FunctionRenderContext context) {
        if (context.getArgumentsSize() == 0) {
            throw new RuntimeException("The group concat function needs at least one argument! args=" + context);
        }
        boolean distinct = false;
        int startIndex = 0;
        int argsSize = context.getArgumentsSize();
        String maybeDistinct = context.getArgument(0);
        if ("'DISTINCT'".equalsIgnoreCase(maybeDistinct)) {
            distinct = true;
            ++startIndex;
        }
        if (startIndex >= argsSize) {
            throw new RuntimeException("The group concat function needs at least one expression to concatenate! args=" + context);
        }
        String expression = context.getArgument(startIndex);
        String separator = null;
        String orderExpression = null;
        ArrayList<Order> orders = new ArrayList<Order>();
        Mode mode = null;
        for (int i = startIndex + 1; i < argsSize; ++i) {
            String argument = context.getArgument(i);
            if ("'SEPARATOR'".equalsIgnoreCase(argument)) {
                mode = Mode.SEPARATOR;
                continue;
            }
            if ("'ORDER BY'".equalsIgnoreCase(argument)) {
                mode = Mode.ORDER_BY;
                continue;
            }
            if (mode == Mode.ORDER_BY) {
                Order order = AbstractGroupConcatFunction.getOrder(argument, orderExpression);
                if (order != null) {
                    orders.add(order);
                    orderExpression = null;
                    continue;
                }
                if (orderExpression != null) {
                    orders.add(new Order(orderExpression, null, null));
                }
                orderExpression = argument;
                continue;
            }
            if (mode == Mode.SEPARATOR) {
                if (separator != null) {
                    throw new IllegalArgumentException("Illegal multiple separators for group concat '" + argument + "'. Expected 'ORDER BY'!");
                }
                separator = argument.substring(argument.indexOf(39) + 1, argument.lastIndexOf(39));
                continue;
            }
            throw new IllegalArgumentException("Illegal input for group concat '" + argument + "'. Expected 'SEPARATOR' or 'ORDER BY'!");
        }
        if (orderExpression != null) {
            orders.add(new Order(orderExpression, null, null));
        }
        if (separator == null) {
            separator = ",";
        }
        return new GroupConcat(distinct, expression, orders, separator);
    }

    protected void render(StringBuilder sb, Order order) {
        sb.append(order.getExpression());
        if (order.isAscending()) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        if (order.isNullsFirst()) {
            sb.append(" NULLS FIRST");
        } else {
            sb.append(" NULLS LAST");
        }
    }

    protected void appendQuoted(StringBuilder sb, String s) {
        sb.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append('\'');
            }
            sb.append(c);
        }
        sb.append('\'');
    }

    protected void appendEmulatedOrderByElementWithNulls(StringBuilder sb, Order element) {
        sb.append("case when ");
        sb.append(element.getExpression());
        sb.append(" is null then ");
        sb.append(element.isNullsFirst() ? 0 : 1);
        sb.append(" else ");
        sb.append(element.isNullsFirst() ? 1 : 0);
        sb.append(" end, ");
        sb.append(element.getExpression());
        sb.append(element.isAscending() ? " asc" : " desc");
    }

    private static Order getOrder(String s, String expression) {
        if (expression == null) {
            return null;
        }
        String type = s.trim().toUpperCase();
        if ("'ASC'".equals(type)) {
            return new Order(expression, true, null);
        }
        if ("'DESC'".equals(type)) {
            return new Order(expression, false, null);
        }
        if ("'ASC NULLS FIRST'".equals(type)) {
            return new Order(expression, true, true);
        }
        if ("'ASC NULLS LAST'".equals(type)) {
            return new Order(expression, true, false);
        }
        if ("'DESC NULLS FIRST'".equals(type)) {
            return new Order(expression, false, true);
        }
        if ("'DESC NULLS LAST'".equals(type)) {
            return new Order(expression, false, false);
        }
        return null;
    }

    protected static final class Order {
        private final String expression;
        private final boolean ascending;
        private final boolean nullsFirst;

        public Order(String expression, Boolean ascending, Boolean nullsFirst) {
            this.expression = expression;
            if (Boolean.FALSE.equals(ascending)) {
                this.ascending = false;
                this.nullsFirst = nullsFirst == null ? true : nullsFirst;
            } else {
                this.ascending = true;
                this.nullsFirst = nullsFirst == null ? false : nullsFirst;
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public boolean isNullsFirst() {
            return this.nullsFirst;
        }
    }

    protected static final class GroupConcat {
        private final boolean distinct;
        private final String expression;
        private final List<Order> orderBys;
        private final String separator;

        public GroupConcat(boolean distinct, String expression, List<Order> orderBys, String separator) {
            this.distinct = distinct;
            this.expression = expression;
            this.orderBys = orderBys;
            this.separator = separator;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public String getExpression() {
            return this.expression;
        }

        public List<Order> getOrderBys() {
            return this.orderBys;
        }

        public String getSeparator() {
            return this.separator;
        }
    }

    private static enum Mode {
        SEPARATOR,
        ORDER_BY;

    }
}

