/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.rowvalue;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public class RowValueComparisonFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "compare_row_value";

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return Boolean.TYPE;
    }

    public void render(FunctionRenderContext context) {
        String operator = context.getArgument(0);
        operator = operator.substring(1, operator.length() - 1);
        context.addChunk(this.getLeftmostChunk());
        int rowValueArity = (context.getArgumentsSize() - 1) / 2;
        this.addArguments(context, 1, rowValueArity + 1);
        context.addChunk(") " + operator + " (");
        this.addArguments(context, rowValueArity + 1, 2 * rowValueArity + 1);
        context.addChunk(this.getRightmostChunk());
    }

    protected String getLeftmostChunk() {
        return "((";
    }

    protected String getRightmostChunk() {
        return "))";
    }

    private void addArguments(FunctionRenderContext context, int from, int to) {
        context.addArgument(from);
        for (int i = from + 1; i < to; ++i) {
            context.addChunk(", ");
            context.addArgument(i);
        }
    }
}

